import { type NextRequest, NextResponse } from "next/server"
import { getProxyHttpBase, withProxyHeaders } from "@/lib/proxy"

export async function POST(request: NextRequest) {
  try {
    const { email, password } = await request.json()

    if (!email || !password) {
      return NextResponse.json(
        {
          success: false,
          message: "Email e senha são obrigatórios",
        },
        { status: 400 },
      )
    }

  console.log("=== TENTATIVA DE LOGIN VIA PROXY ===")
  console.log("User:", email)
  const base = getProxyHttpBase()
  console.log("URL do Proxy:", `${base}/ext/v1/autenticacao/login`)

  // Corpo JSON esperado pela fachada: { login, senha }
  const body = JSON.stringify({ login: email, senha: password })

  console.log("Enviando dados para proxy:", { login: email, senha: "***" })

    // Fazer login via nosso servidor proxy
    const response = await fetch(`${base}/ext/v1/autenticacao/login`, {
      method: "POST",
      headers: withProxyHeaders({
        "Accept": "application/json",
        "Content-Type": "application/json",
      }),
      body,
    })

    console.log("=== RESPOSTA DO PROXY ===")
    console.log("Status:", response.status)
    console.log("Status Text:", response.statusText)

    // Ler a resposta como texto primeiro para debug
    const responseText = await response.text()
    console.log("Resposta bruta do proxy:", responseText)

    let data
    try {
      data = JSON.parse(responseText)
      console.log("Dados parseados do proxy:", data)
    } catch (parseError) {
      console.error("Erro ao parsear JSON do proxy:", parseError)
      return NextResponse.json(
        {
          success: false,
          message: "Resposta inválida do servidor proxy",
          debug: responseText,
        },
        { status: 500 },
      )
    }

    if (!response.ok) {
      console.log("=== ERRO NA RESPOSTA DO PROXY ===")
      console.log("Status:", response.status)
      console.log("Dados:", data)

      return NextResponse.json(
        {
          success: false,
          message: data.msg || data.message || "Credenciais inválidas",
          debug: data,
        },
        { status: response.status },
      )
    }

  // Verificar se o login foi bem-sucedido via fachada (sucesso: true)
  if (!data.sucesso) {
      console.log("=== LOGIN NÃO FOI BEM-SUCEDIDO VIA PROXY ===")
      console.log("Status:", data.status)
      console.log("Dados completos:", data)

      return NextResponse.json({
        success: false,
        message: data.mensagem || data.msg || data.message || "Credenciais inválidas",
        debug: data,
      }, { status: 401 })
    }

    // Verificar se o token está presente
    if (!data.token) {
      console.log("=== TOKEN NÃO ENCONTRADO NA RESPOSTA DO PROXY ===")
      console.log("Dados completos:", data)

      return NextResponse.json(
        {
          success: false,
          message: "Token de acesso não retornado pelo proxy",
          debug: data,
        },
        { status: 500 },
      )
    }

    console.log("=== LOGIN BEM-SUCEDIDO VIA PROXY ===")
  console.log("Token:", data.token.substring(0, 20) + "...")
  console.log("User ID:", data.usuario?.id)
  console.log("Name:", data.usuario?.nome)
  console.log("Credit:", data.usuario?.credito)

    // Retornar os dados conforme a estrutura do proxy
    return NextResponse.json({
      success: true,
      token: data.token,
      user: {
        id: data.usuario?.id,
        name: data.usuario?.nome,
        credit: data.usuario?.credito,
      },
    })
  } catch (error) {
    console.error("=== ERRO GERAL NO LOGIN VIA PROXY ===", error)
    return NextResponse.json(
      {
        success: false,
        message: "Erro ao conectar com o servidor proxy. Verifique se está rodando na porta 3030.",
        error: error instanceof Error ? error.message : "Erro desconhecido",
      },
      { status: 500 },
    )
  }
}
