/*@license Copyright 2015-2022 Ably Real-time Ltd (ably.com)

Ably JavaScript Library v2.10.0
https://github.com/ably/ably-js

Released under the Apache Licence v2.0*/(function (g, f) {
    if ("object" == typeof exports && "object" == typeof module) {
      module.exports = f();
    } else if ("function" == typeof define && define.amd) {
      define([], f);
    } else if ("object" == typeof exports) {
      exports["AblyObjectsPlugin"] = f();
    } else {
      g["AblyObjectsPlugin"] = f();
    }
  }(this, () => {
var exports = {};
var module = { exports };
"use strict";var M=Object.defineProperty,W=Object.defineProperties,J=Object.getOwnPropertyDescriptor,G=Object.getOwnPropertyDescriptors,q=Object.getOwnPropertyNames,N=Object.getOwnPropertySymbols;var B=Object.prototype.hasOwnProperty,Z=Object.prototype.propertyIsEnumerable;var A=(s,e)=>{if(e=Symbol[s])return e;throw Error("Symbol."+s+" is not defined")};var V=(s,e,t)=>e in s?M(s,e,{enumerable:!0,configurable:!0,writable:!0,value:t}):s[e]=t,j=(s,e)=>{for(var t in e||(e={}))B.call(e,t)&&V(s,t,e[t]);if(N)for(var t of N(e))Z.call(e,t)&&V(s,t,e[t]);return s},_=(s,e)=>W(s,G(e));var Y=(s,e)=>{for(var t in e)M(s,t,{get:e[t],enumerable:!0})},H=(s,e,t,i)=>{if(e&&typeof e=="object"||typeof e=="function")for(let n of q(e))!B.call(s,n)&&n!==t&&M(s,n,{get:()=>e[n],enumerable:!(i=J(e,n))||i.enumerable});return s};var Q=s=>H(M({},"__esModule",{value:!0}),s);var X=function(s,e){this[0]=s,this[1]=e};var L=s=>{var e=s[A("asyncIterator")],t=!1,i,n={};return e==null?(e=s[A("iterator")](),i=a=>n[a]=o=>e[a](o)):(e=e.call(s),i=a=>n[a]=o=>{if(t){if(t=!1,a==="throw")throw o;return o}return t=!0,{done:!1,value:new X(new Promise(r=>{var c=e[a](o);if(!(c instanceof Object))throw TypeError("Object expected");r(c)}),1)}}),n[A("iterator")]=()=>n,i("next"),"throw"in e?i("throw"):n.throw=a=>{throw a},"return"in e&&i("return"),n};var ie={};Y(ie,{ObjectMessage:()=>l,Objects:()=>I,default:()=>te});module.exports=Q(ie);var l=class s{constructor(e,t){this._utils=e;this._messageEncoding=t}static encode(e,t){let i=(a,o)=>{let r=typeof a=="string"||typeof a=="number"||typeof a=="boolean"||t.Platform.BufferUtils.isBuffer(a)||a===null||a===void 0,{data:c,encoding:p}=t.MessageEncoding.encodeData(a,o,r);return{data:c,encoding:p}},n=a=>a;return e.operation=e.operation?s._encodeObjectOperation(e.operation,n,i):void 0,e.object=e.object?s._encodeObjectState(e.object,n,i):void 0,e}static async decode(e,t,i,n,a,o){var r,c,p,d,u,O,E,U,P,S,R,k;try{(c=(r=e.object)==null?void 0:r.map)!=null&&c.entries&&await s._decodeMapEntries(e.object.map.entries,t,o),(u=(d=(p=e.object)==null?void 0:p.createOp)==null?void 0:d.map)!=null&&u.entries&&await s._decodeMapEntries(e.object.createOp.map.entries,t,o),(U=(E=(O=e.object)==null?void 0:O.createOp)==null?void 0:E.mapOp)!=null&&U.data&&await s._decodeObjectData(e.object.createOp.mapOp.data,t,o),(S=(P=e.operation)==null?void 0:P.map)!=null&&S.entries&&await s._decodeMapEntries(e.operation.map.entries,t,o),(k=(R=e.operation)==null?void 0:R.mapOp)!=null&&k.data&&await s._decodeObjectData(e.operation.mapOp.data,t,o)}catch(K){n.logAction(i,n.LOG_ERROR,"ObjectMessage.decode()",a.inspectError(K))}}static fromValues(e,t,i){return Object.assign(new s(t,i),e)}static fromValuesArray(e,t,i){let n=e.length,a=new Array(n);for(let o=0;o<n;o++)a[o]=s.fromValues(e[o],t,i);return a}static encodeInitialValue(e,t){let i=t.options.useBinaryProtocol?t.Utils.Format.msgpack:t.Utils.Format.json,n=s.fromValues({operation:e},t.Utils,t.MessageEncoding);s.encode(n,t);let{operation:a}=s._encodeForWireProtocol(n,t.MessageEncoding,i),o=t.Utils.encodeBody(a,t._MsgPack,i);return typeof o=="string"?{encodedInitialValue:t.Platform.BufferUtils.utf8Encode(o),format:i}:{encodedInitialValue:o,format:i}}static async _decodeMapEntries(e,t,i){for(let n of Object.values(e))n.data&&await s._decodeObjectData(n.data,t,i)}static async _decodeObjectData(e,t,i){i!=="msgpack"&&e.bytes!=null&&(e.bytes=t.Platform.BufferUtils.base64Decode(String(e.bytes)))}static _encodeObjectOperation(e,t,i){var a,o,r;let n=JSON.parse(JSON.stringify(e));if((a=n.mapOp)!=null&&a.data&&(n.mapOp.data=s._encodeObjectData((o=e.mapOp)==null?void 0:o.data,t)),(r=n.map)!=null&&r.entries&&Object.entries(n.map.entries).forEach(([c,p])=>{var d,u;p.data&&(p.data=s._encodeObjectData((u=(d=e==null?void 0:e.map)==null?void 0:d.entries)==null?void 0:u[c].data,t))}),e.initialValue){let{data:c}=i(e.initialValue);n.initialValue=c}return n}static _encodeObjectState(e,t,i){var a;let n=JSON.parse(JSON.stringify(e));return(a=n.map)!=null&&a.entries&&Object.entries(n.map.entries).forEach(([o,r])=>{var c,p;r.data&&(r.data=s._encodeObjectData((p=(c=e==null?void 0:e.map)==null?void 0:c.entries)==null?void 0:p[o].data,t))}),n.createOp&&(n.createOp=s._encodeObjectOperation(e.createOp,t,i)),n}static _encodeObjectData(e,t){return t(e)}static _encodeForWireProtocol(e,t,i){let n=(c,p)=>{let{data:d,encoding:u}=t.encodeDataForWire(c,p,i);return{data:d,encoding:u}},a=c=>{let p=c.bytes;return c.bytes!=null&&(p=t.encodeDataForWire(c.bytes,c.encoding,i).data),_(j({},c),{bytes:p})},o=e.operation?s._encodeObjectOperation(e.operation,a,n):void 0,r=e.object?s._encodeObjectState(e.object,a,n):void 0;return{operation:o,objectState:r}}toJSON(){let e=arguments.length>0?this._utils.Format.json:this._utils.Format.msgpack,{operation:t,objectState:i}=s._encodeForWireProtocol(this,this._messageEncoding,e);return{id:this.id,clientId:this.clientId,operation:t,object:i,extras:this.extras}}toString(){let e="[ObjectMessage";return this.id&&(e+="; id="+this.id),this.timestamp&&(e+="; timestamp="+this.timestamp),this.clientId&&(e+="; clientId="+this.clientId),this.connectionId&&(e+="; connectionId="+this.connectionId),this.operation&&(e+="; operation="+JSON.stringify(this.operation)),this.object&&(e+="; object="+JSON.stringify(this.object)),this.extras&&(e+="; extras="+JSON.stringify(this.extras)),this.serial&&(e+="; serial="+this.serial),this.siteCode&&(e+="; siteCode="+this.siteCode),e+="]",e}getMessageSize(){var t,i;let e=0;return e+=(i=(t=this.clientId)==null?void 0:t.length)!=null?i:0,this.operation&&(e+=this._getObjectOperationSize(this.operation)),this.object&&(e+=this._getObjectStateSize(this.object)),this.extras&&(e+=JSON.stringify(this.extras).length),e}_getObjectOperationSize(e){let t=0;return e.mapOp&&(t+=this._getMapOpSize(e.mapOp)),e.counterOp&&(t+=this._getCounterOpSize(e.counterOp)),e.map&&(t+=this._getObjectMapSize(e.map)),e.counter&&(t+=this._getObjectCounterSize(e.counter)),t}_getObjectStateSize(e){let t=0;return e.map&&(t+=this._getObjectMapSize(e.map)),e.counter&&(t+=this._getObjectCounterSize(e.counter)),e.createOp&&(t+=this._getObjectOperationSize(e.createOp)),t}_getObjectMapSize(e){var i;let t=0;return Object.entries((i=e.entries)!=null?i:{}).forEach(([n,a])=>{var o;t+=(o=n==null?void 0:n.length)!=null?o:0,a&&(t+=this._getMapEntrySize(a))}),t}_getObjectCounterSize(e){return e.count==null?0:8}_getMapEntrySize(e){let t=0;return e.data&&(t+=this._getObjectDataSize(e.data)),t}_getMapOpSize(e){var i,n;let t=0;return t+=(n=(i=e.key)==null?void 0:i.length)!=null?n:0,e.data&&(t+=this._getObjectDataSize(e.data)),t}_getCounterOpSize(e){return e.amount==null?0:8}_getObjectDataSize(e){let t=0;return e.boolean!=null&&(t+=this._utils.dataSizeBytes(e.boolean)),e.bytes!=null&&(t+=this._utils.dataSizeBytes(e.bytes)),e.number!=null&&(t+=this._utils.dataSizeBytes(e.number)),e.string!=null&&(t+=this._utils.dataSizeBytes(e.string)),t}};var h=class{constructor(e,t){this._objects=e;this._client=this._objects.getClient(),this._subscriptions=new this._client.EventEmitter(this._client.logger),this._lifecycleEvents=new this._client.EventEmitter(this._client.logger),this._objectId=t,this._dataRef=this._getZeroValueData(),this._siteTimeserials={},this._createOperationIsMerged=!1,this._tombstone=!1}subscribe(e){return this._objects.throwIfInvalidAccessApiConfiguration(),this._subscriptions.on("updated",e),{unsubscribe:()=>{this._subscriptions.off("updated",e)}}}unsubscribe(e){this._client.Utils.isNil(e)||this._subscriptions.off("updated",e)}unsubscribeAll(){this._subscriptions.off("updated")}on(e,t){return this._lifecycleEvents.on(e,t),{off:()=>{this._lifecycleEvents.off(e,t)}}}off(e,t){this._client.Utils.isNil(e)&&this._client.Utils.isNil(t)||this._lifecycleEvents.off(e,t)}offAll(){this._lifecycleEvents.off()}getObjectId(){return this._objectId}notifyUpdated(e){e.noop||this._subscriptions.emit("updated",e)}tombstone(){this._tombstone=!0,this._tombstonedAt=Date.now();let e=this.clearData();return this._lifecycleEvents.emit("deleted"),e}isTombstoned(){return this._tombstone}tombstonedAt(){return this._tombstonedAt}clearData(){let e=this._dataRef;return this._dataRef=this._getZeroValueData(),this._updateFromDataDiff(e,this._dataRef)}_canApplyOperation(e,t){if(!e)throw new this._client.ErrorInfo(`Invalid serial: ${e}`,92e3,500);if(!t)throw new this._client.ErrorInfo(`Invalid site code: ${t}`,92e3,500);let i=this._siteTimeserials[t];return!i||e>i}_applyObjectDelete(){return this.tombstone()}};var m=class s{constructor(e,t,i){this.type=e;this.hash=t;this.msTimestamp=i}static fromInitialValue(e,t,i,n,a){let o=e.BufferUtils.concat([i,e.BufferUtils.utf8Encode(":"),e.BufferUtils.utf8Encode(n)]),r=e.BufferUtils.sha256(o),c=e.BufferUtils.base64UrlEncode(r);return new s(t,c,a)}static fromString(e,t){if(e.Utils.isNil(t))throw new e.ErrorInfo("Invalid object id string",92e3,500);let[i,n]=t.split(":");if(!i||!n)throw new e.ErrorInfo("Invalid object id string",92e3,500);if(!["map","counter"].includes(i))throw new e.ErrorInfo(`Invalid object type in object id: ${t}`,92e3,500);let[a,o]=n.split("@");if(!a||!o)throw new e.ErrorInfo("Invalid object id string",92e3,500);if(!Number.isInteger(Number.parseInt(o)))throw new e.ErrorInfo("Invalid object id string",92e3,500);return new s(i,a,Number.parseInt(o))}toString(){return`${this.type}:${this.hash}@${this.msTimestamp}`}};var f=class s extends h{static zeroValue(e,t){return new s(e,t)}static fromObjectState(e,t){let i=new s(e,t.objectId);return i.overrideWithObjectState(t),i}static fromObjectOperation(e,t){let i=new s(e,t.objectId);return i._mergeInitialDataFromCreateOperation(t),i}static createCounterIncMessage(e,t,i){let n=e.getClient();if(typeof i!="number"||!Number.isFinite(i))throw new n.ErrorInfo("Counter value increment should be a valid number",40003,400);return l.fromValues({operation:{action:4,objectId:t,counterOp:{amount:i}}},n.Utils,n.MessageEncoding)}static async createCounterCreateMessage(e,t){let i=e.getClient();if(t!==void 0&&(typeof t!="number"||!Number.isFinite(t)))throw new i.ErrorInfo("Counter value should be a valid number",40003,400);let n=s.createInitialValueObject(t),{encodedInitialValue:a,format:o}=l.encodeInitialValue(n,i),r=i.Utils.cheapRandStr(),c=await i.getTimestamp(!0),p=m.fromInitialValue(i.Platform,"counter",a,r,c).toString();return l.fromValues({operation:_(j({},n),{action:3,objectId:p,nonce:r,initialValue:a,initialValueEncoding:o})},i.Utils,i.MessageEncoding)}static createInitialValueObject(e){return{counter:{count:e!=null?e:0}}}value(){return this._objects.throwIfInvalidAccessApiConfiguration(),this._dataRef.data}async increment(e){this._objects.throwIfInvalidWriteApiConfiguration();let t=s.createCounterIncMessage(this._objects,this.getObjectId(),e);return this._objects.publish([t])}async decrement(e){if(this._objects.throwIfInvalidWriteApiConfiguration(),typeof e!="number"||!Number.isFinite(e))throw new this._client.ErrorInfo("Counter value decrement should be a valid number",40003,400);return this.increment(-e)}applyOperation(e,t){var o;if(e.objectId!==this.getObjectId())throw new this._client.ErrorInfo(`Cannot apply object operation with objectId=${e.objectId}, to this LiveCounter with objectId=${this.getObjectId()}`,92e3,500);let i=t.serial,n=t.siteCode;if(!this._canApplyOperation(i,n)){this._client.Logger.logAction(this._client.logger,this._client.Logger.LOG_MICRO,"LiveCounter.applyOperation()",`skipping ${e.action} op: op serial ${i.toString()} <= site serial ${(o=this._siteTimeserials[n])==null?void 0:o.toString()}; objectId=${this.getObjectId()}`);return}if(this._siteTimeserials[n]=i,this.isTombstoned())return;let a;switch(e.action){case 3:a=this._applyCounterCreate(e);break;case 4:if(this._client.Utils.isNil(e.counterOp)){this._throwNoPayloadError(e);return}else a=this._applyCounterInc(e.counterOp);break;case 5:a=this._applyObjectDelete();break;default:throw new this._client.ErrorInfo(`Invalid ${e.action} op for LiveCounter objectId=${this.getObjectId()}`,92e3,500)}this.notifyUpdated(a)}overrideWithObjectState(e){var i,n,a,o,r;if(e.objectId!==this.getObjectId())throw new this._client.ErrorInfo(`Invalid object state: object state objectId=${e.objectId}; LiveCounter objectId=${this.getObjectId()}`,92e3,500);if(!this._client.Utils.isNil(e.createOp)){if(e.createOp.objectId!==this.getObjectId())throw new this._client.ErrorInfo(`Invalid object state: object state createOp objectId=${(i=e.createOp)==null?void 0:i.objectId}; LiveCounter objectId=${this.getObjectId()}`,92e3,500);if(e.createOp.action!==3)throw new this._client.ErrorInfo(`Invalid object state: object state createOp action=${(n=e.createOp)==null?void 0:n.action}; LiveCounter objectId=${this.getObjectId()}`,92e3,500)}if(this._siteTimeserials=(a=e.siteTimeserials)!=null?a:{},this.isTombstoned())return{noop:!0};let t=this._dataRef;return e.tombstone?this.tombstone():(this._createOperationIsMerged=!1,this._dataRef={data:(r=(o=e.counter)==null?void 0:o.count)!=null?r:0},this._client.Utils.isNil(e.createOp)||this._mergeInitialDataFromCreateOperation(e.createOp)),this._updateFromDataDiff(t,this._dataRef)}onGCInterval(){}_getZeroValueData(){return{data:0}}_updateFromDataDiff(e,t){return{update:{amount:t.data-e.data}}}_mergeInitialDataFromCreateOperation(e){var t,i,n,a;return this._dataRef.data+=(i=(t=e.counter)==null?void 0:t.count)!=null?i:0,this._createOperationIsMerged=!0,{update:{amount:(a=(n=e.counter)==null?void 0:n.count)!=null?a:0}}}_throwNoPayloadError(e){throw new this._client.ErrorInfo(`No payload found for ${e.action} op for LiveCounter objectId=${this.getObjectId()}`,92e3,500)}_applyCounterCreate(e){return this._createOperationIsMerged?(this._client.Logger.logAction(this._client.logger,this._client.Logger.LOG_MICRO,"LiveCounter._applyCounterCreate()",`skipping applying COUNTER_CREATE op on a counter instance as it was already applied before; objectId=${this.getObjectId()}`),{noop:!0}):this._mergeInitialDataFromCreateOperation(e)}_applyCounterInc(e){return this._dataRef.data+=e.amount,{update:{amount:e.amount}}}};var T=class{constructor(e,t,i){this._batchContext=e;this._objects=t;this._counter=i;this._client=this._objects.getClient()}value(){return this._objects.throwIfInvalidAccessApiConfiguration(),this._batchContext.throwIfClosed(),this._counter.value()}increment(e){this._objects.throwIfInvalidWriteApiConfiguration(),this._batchContext.throwIfClosed();let t=f.createCounterIncMessage(this._objects,this._counter.getObjectId(),e);this._batchContext.queueMessage(t)}decrement(e){if(this._objects.throwIfInvalidWriteApiConfiguration(),this._batchContext.throwIfClosed(),typeof e!="number")throw new this._client.ErrorInfo("Counter value decrement should be a number",40003,400);this.increment(-e)}};var z=Object.prototype.hasOwnProperty;function F(s,e,t){for(t of s.keys())if(v(t,e))return t}function v(s,e){var t,i,n;if(s===e)return!0;if(s&&e&&(t=s.constructor)===e.constructor){if(t===Date)return s.getTime()===e.getTime();if(t===RegExp)return s.toString()===e.toString();if(t===Array){if((i=s.length)===e.length)for(;i--&&v(s[i],e[i]););return i===-1}if(t===Set){if(s.size!==e.size)return!1;for(i of s)if(n=i,n&&typeof n=="object"&&(n=F(e,n),!n)||!e.has(n))return!1;return!0}if(t===Map){if(s.size!==e.size)return!1;for(i of s)if(n=i[0],n&&typeof n=="object"&&(n=F(e,n),!n)||!v(i[1],e.get(n)))return!1;return!0}if(t===ArrayBuffer)s=new Uint8Array(s),e=new Uint8Array(e);else if(t===DataView){if((i=s.byteLength)===e.byteLength)for(;i--&&s.getInt8(i)===e.getInt8(i););return i===-1}if(ArrayBuffer.isView(s)){if((i=s.byteLength)===e.byteLength)for(;i--&&s[i]===e[i];);return i===-1}if(!t||typeof s=="object"){i=0;for(t in s)if(z.call(s,t)&&++i&&!z.call(e,t)||!(t in e)||!v(s[t],e[t]))return!1;return Object.keys(e).length===i}}return s!==s&&e!==e}var g={gcInterval:3e5,gcGracePeriod:864e5};var b=class s extends h{constructor(t,i,n){super(t,n);this._semantics=i}static zeroValue(t,i){return new s(t,0,i)}static fromObjectState(t,i){var a;let n=new s(t,(a=i.map)==null?void 0:a.semantics,i.objectId);return n.overrideWithObjectState(i),n}static fromObjectOperation(t,i){var a;let n=new s(t,(a=i.map)==null?void 0:a.semantics,i.objectId);return n._mergeInitialDataFromCreateOperation(i),n}static createMapSetMessage(t,i,n,a){let o=t.getClient();s.validateKeyValue(t,n,a);let r;if(a instanceof h)r={objectId:a.getObjectId()};else{let p={};typeof a=="string"?p.string=a:typeof a=="number"?p.number=a:typeof a=="boolean"?p.boolean=a:p.bytes=a,r=p}return l.fromValues({operation:{action:1,objectId:i,mapOp:{key:n,data:r}}},o.Utils,o.MessageEncoding)}static createMapRemoveMessage(t,i,n){let a=t.getClient();if(typeof n!="string")throw new a.ErrorInfo("Map key should be string",40003,400);return l.fromValues({operation:{action:2,objectId:i,mapOp:{key:n}}},a.Utils,a.MessageEncoding)}static validateKeyValue(t,i,n){let a=t.getClient();if(typeof i!="string")throw new a.ErrorInfo("Map key should be string",40003,400);if(typeof n!="string"&&typeof n!="number"&&typeof n!="boolean"&&!a.Platform.BufferUtils.isBuffer(n)&&!(n instanceof h))throw new a.ErrorInfo("Map value data type is unsupported",40013,400)}static async createMapCreateMessage(t,i){let n=t.getClient();if(i!==void 0&&(i===null||typeof i!="object"))throw new n.ErrorInfo("Map entries should be a key-value object",40003,400);Object.entries(i!=null?i:{}).forEach(([O,E])=>s.validateKeyValue(t,O,E));let a=s.createInitialValueObject(i),{encodedInitialValue:o,format:r}=l.encodeInitialValue(a,n),c=n.Utils.cheapRandStr(),p=await n.getTimestamp(!0),d=m.fromInitialValue(n.Platform,"map",o,c,p).toString();return l.fromValues({operation:_(j({},a),{action:0,objectId:d,nonce:c,initialValue:o,initialValueEncoding:r})},n.Utils,n.MessageEncoding)}static createInitialValueObject(t){let i={};return Object.entries(t!=null?t:{}).forEach(([n,a])=>{let o;if(a instanceof h)o={objectId:a.getObjectId()};else{let r={};typeof a=="string"?r.string=a:typeof a=="number"?r.number=a:typeof a=="boolean"?r.boolean=a:r.bytes=a,o=r}i[n]={data:o}}),{map:{semantics:0,entries:i}}}get(t){if(this._objects.throwIfInvalidAccessApiConfiguration(),this.isTombstoned())return;let i=this._dataRef.data.get(t);if(i!==void 0&&i.tombstone!==!0)return this._getResolvedValueFromObjectData(i.data)}size(){this._objects.throwIfInvalidAccessApiConfiguration();let t=0;for(let i of this._dataRef.data.values())this._isMapEntryTombstoned(i)||t++;return t}*entries(){this._objects.throwIfInvalidAccessApiConfiguration();for(let[t,i]of this._dataRef.data.entries()){if(this._isMapEntryTombstoned(i))continue;let n=this._getResolvedValueFromObjectData(i.data);yield[t,n]}}*keys(){for(let[t]of this.entries())yield t}*values(){for(let[t,i]of this.entries())yield i}async set(t,i){this._objects.throwIfInvalidWriteApiConfiguration();let n=s.createMapSetMessage(this._objects,this.getObjectId(),t,i);return this._objects.publish([n])}async remove(t){this._objects.throwIfInvalidWriteApiConfiguration();let i=s.createMapRemoveMessage(this._objects,this.getObjectId(),t);return this._objects.publish([i])}applyOperation(t,i){var r;if(t.objectId!==this.getObjectId())throw new this._client.ErrorInfo(`Cannot apply object operation with objectId=${t.objectId}, to this LiveMap with objectId=${this.getObjectId()}`,92e3,500);let n=i.serial,a=i.siteCode;if(!this._canApplyOperation(n,a)){this._client.Logger.logAction(this._client.logger,this._client.Logger.LOG_MICRO,"LiveMap.applyOperation()",`skipping ${t.action} op: op serial ${n.toString()} <= site serial ${(r=this._siteTimeserials[a])==null?void 0:r.toString()}; objectId=${this.getObjectId()}`);return}if(this._siteTimeserials[a]=n,this.isTombstoned())return;let o;switch(t.action){case 0:o=this._applyMapCreate(t);break;case 1:if(this._client.Utils.isNil(t.mapOp)){this._throwNoPayloadError(t);return}else o=this._applyMapSet(t.mapOp,n);break;case 2:if(this._client.Utils.isNil(t.mapOp)){this._throwNoPayloadError(t);return}else o=this._applyMapRemove(t.mapOp,n);break;case 5:o=this._applyObjectDelete();break;default:throw new this._client.ErrorInfo(`Invalid ${t.action} op for LiveMap objectId=${this.getObjectId()}`,92e3,500)}this.notifyUpdated(o)}overrideWithObjectState(t){var n,a,o,r,c,p,d,u,O;if(t.objectId!==this.getObjectId())throw new this._client.ErrorInfo(`Invalid object state: object state objectId=${t.objectId}; LiveMap objectId=${this.getObjectId()}`,92e3,500);if(((n=t.map)==null?void 0:n.semantics)!==this._semantics)throw new this._client.ErrorInfo(`Invalid object state: object state map semantics=${(a=t.map)==null?void 0:a.semantics}; LiveMap semantics=${this._semantics}`,92e3,500);if(!this._client.Utils.isNil(t.createOp)){if(t.createOp.objectId!==this.getObjectId())throw new this._client.ErrorInfo(`Invalid object state: object state createOp objectId=${(o=t.createOp)==null?void 0:o.objectId}; LiveMap objectId=${this.getObjectId()}`,92e3,500);if(t.createOp.action!==0)throw new this._client.ErrorInfo(`Invalid object state: object state createOp action=${(r=t.createOp)==null?void 0:r.action}; LiveMap objectId=${this.getObjectId()}`,92e3,500);if(((c=t.createOp.map)==null?void 0:c.semantics)!==this._semantics)throw new this._client.ErrorInfo(`Invalid object state: object state createOp map semantics=${(p=t.createOp.map)==null?void 0:p.semantics}; LiveMap semantics=${this._semantics}`,92e3,500)}if(this._siteTimeserials=(d=t.siteTimeserials)!=null?d:{},this.isTombstoned())return{noop:!0};let i=this._dataRef;return t.tombstone?this.tombstone():(this._createOperationIsMerged=!1,this._dataRef=this._liveMapDataFromMapEntries((O=(u=t.map)==null?void 0:u.entries)!=null?O:{}),this._client.Utils.isNil(t.createOp)||this._mergeInitialDataFromCreateOperation(t.createOp)),this._updateFromDataDiff(i,this._dataRef)}onGCInterval(){let t=[];for(let[i,n]of this._dataRef.data.entries())n.tombstone===!0&&Date.now()-n.tombstonedAt>=g.gcGracePeriod&&t.push(i);t.forEach(i=>this._dataRef.data.delete(i))}_getZeroValueData(){return{data:new Map}}_updateFromDataDiff(t,i){let n={update:{}};for(let[a,o]of t.data.entries()){let r=a;o.tombstone===!1&&!i.data.has(r)&&(n.update[r]="removed")}for(let[a,o]of i.data.entries()){let r=a;if(!t.data.has(r)){if(o.tombstone===!1){n.update[r]="updated";continue}if(o.tombstone===!0)continue}let c=t.data.get(r);if(c.tombstone===!0&&o.tombstone===!1){n.update[r]="updated";continue}if(c.tombstone===!1&&o.tombstone===!0){n.update[r]="removed";continue}if(c.tombstone===!0&&o.tombstone===!0)continue;if(!v(c.data,o.data)){n.update[r]="updated";continue}}return n}_mergeInitialDataFromCreateOperation(t){var n;if(this._client.Utils.isNil(t.map))return{update:{}};let i={update:{}};return Object.entries((n=t.map.entries)!=null?n:{}).forEach(([a,o])=>{let r=o.timeserial,c;o.tombstone===!0?c=this._applyMapRemove({key:a},r):c=this._applyMapSet({key:a,data:o.data},r),!c.noop&&Object.assign(i.update,c.update)}),this._createOperationIsMerged=!0,i}_throwNoPayloadError(t){throw new this._client.ErrorInfo(`No payload found for ${t.action} op for LiveMap objectId=${this.getObjectId()}`,92e3,500)}_applyMapCreate(t){var i,n;if(this._createOperationIsMerged)return this._client.Logger.logAction(this._client.logger,this._client.Logger.LOG_MICRO,"LiveMap._applyMapCreate()",`skipping applying MAP_CREATE op on a map instance as it was already applied before; objectId=${this.getObjectId()}`),{noop:!0};if(this._semantics!==((i=t.map)==null?void 0:i.semantics))throw new this._client.ErrorInfo(`Cannot apply MAP_CREATE op on LiveMap objectId=${this.getObjectId()}; map's semantics=${this._semantics}, but op expected ${(n=t.map)==null?void 0:n.semantics}`,92e3,500);return this._mergeInitialDataFromCreateOperation(t)}_applyMapSet(t,i){var d;let{ErrorInfo:n,Utils:a}=this._client,o=this._dataRef.data.get(t.key);if(o&&!this._canApplyMapOperation(o.timeserial,i))return this._client.Logger.logAction(this._client.logger,this._client.Logger.LOG_MICRO,"LiveMap._applyMapSet()",`skipping update for key="${t.key}": op serial ${i==null?void 0:i.toString()} <= entry serial ${(d=o.timeserial)==null?void 0:d.toString()}; objectId=${this.getObjectId()}`),{noop:!0};if(a.isNil(t.data)||a.isNil(t.data.objectId)&&a.isNil(t.data.boolean)&&a.isNil(t.data.bytes)&&a.isNil(t.data.number)&&a.isNil(t.data.string))throw new n(`Invalid object data for MAP_SET op on objectId=${this.getObjectId()} on key=${t.key}`,92e3,500);let r;if(a.isNil(t.data.objectId)?r={encoding:t.data.encoding,boolean:t.data.boolean,bytes:t.data.bytes,number:t.data.number,string:t.data.string}:(r={objectId:t.data.objectId},this._objects.getPool().createZeroValueObjectIfNotExists(t.data.objectId)),o)o.tombstone=!1,o.tombstonedAt=void 0,o.timeserial=i,o.data=r;else{let u={tombstone:!1,tombstonedAt:void 0,timeserial:i,data:r};this._dataRef.data.set(t.key,u)}let c={update:{}},p=t.key;return c.update[p]="updated",c}_applyMapRemove(t,i){var r;let n=this._dataRef.data.get(t.key);if(n&&!this._canApplyMapOperation(n.timeserial,i))return this._client.Logger.logAction(this._client.logger,this._client.Logger.LOG_MICRO,"LiveMap._applyMapRemove()",`skipping remove for key="${t.key}": op serial ${i==null?void 0:i.toString()} <= entry serial ${(r=n.timeserial)==null?void 0:r.toString()}; objectId=${this.getObjectId()}`),{noop:!0};if(n)n.tombstone=!0,n.tombstonedAt=Date.now(),n.timeserial=i,n.data=void 0;else{let c={tombstone:!0,tombstonedAt:Date.now(),timeserial:i,data:void 0};this._dataRef.data.set(t.key,c)}let a={update:{}},o=t.key;return a.update[o]="removed",a}_canApplyMapOperation(t,i){return!t&&!i?!1:t?i?i>t:!1:!0}_liveMapDataFromMapEntries(t){let i={data:new Map};return Object.entries(t!=null?t:{}).forEach(([n,a])=>{let o;this._client.Utils.isNil(a.data)||(this._client.Utils.isNil(a.data.objectId)?o={encoding:a.data.encoding,boolean:a.data.boolean,bytes:a.data.bytes,number:a.data.number,string:a.data.string}:o={objectId:a.data.objectId});let r={timeserial:a.timeserial,data:o,tombstone:a.tombstone===!0,tombstonedAt:a.tombstone===!0?Date.now():void 0};i.data.set(n,r)}),i}_getResolvedValueFromObjectData(t){let i=t;if(i.boolean!==void 0)return i.boolean;if(i.bytes!==void 0)return i.bytes;if(i.number!==void 0)return i.number;if(i.string!==void 0)return i.string;let n=t.objectId,a=this._objects.getPool().get(n);if(a&&!a.isTombstoned())return a}_isMapEntryTombstoned(t){if(t.tombstone===!0)return!0;let i=t.data;if("objectId"in i){let n=this._objects.getPool().get(i.objectId);if(n!=null&&n.isTombstoned())return!0}return!1}};var C=class{constructor(e,t,i){this._batchContext=e;this._objects=t;this._map=i}get(e){this._objects.throwIfInvalidAccessApiConfiguration(),this._batchContext.throwIfClosed();let t=this._map.get(e);return t instanceof h?this._batchContext.getWrappedObject(t.getObjectId()):t}size(){return this._objects.throwIfInvalidAccessApiConfiguration(),this._batchContext.throwIfClosed(),this._map.size()}*entries(){this._objects.throwIfInvalidAccessApiConfiguration(),this._batchContext.throwIfClosed(),yield*L(this._map.entries())}*keys(){this._objects.throwIfInvalidAccessApiConfiguration(),this._batchContext.throwIfClosed(),yield*L(this._map.keys())}*values(){this._objects.throwIfInvalidAccessApiConfiguration(),this._batchContext.throwIfClosed(),yield*L(this._map.values())}set(e,t){this._objects.throwIfInvalidWriteApiConfiguration(),this._batchContext.throwIfClosed();let i=b.createMapSetMessage(this._objects,this._map.getObjectId(),e,t);this._batchContext.queueMessage(i)}remove(e){this._objects.throwIfInvalidWriteApiConfiguration(),this._batchContext.throwIfClosed();let t=b.createMapRemoveMessage(this._objects,this._map.getObjectId(),e);this._batchContext.queueMessage(t)}};var y="root",w=class{constructor(e){this._objects=e;var t,i;this._client=this._objects.getClient(),this._pool=this._createInitialPool(),this._gcInterval=setInterval(()=>{this._onGCInterval()},g.gcInterval),(i=(t=this._gcInterval).unref)==null||i.call(t)}get(e){return this._pool.get(e)}deleteExtraObjectIds(e){[...this._pool.keys()].filter(n=>!e.includes(n)).forEach(n=>this._pool.delete(n))}set(e,t){this._pool.set(e,t)}resetToInitialPool(e){let t=this._pool.get(y);this._pool.clear(),this._pool.set(t.getObjectId(),t),this.clearObjectsData(e)}clearObjectsData(e){for(let t of this._pool.values()){let i=t.clearData();e&&t.notifyUpdated(i)}}createZeroValueObjectIfNotExists(e){let t=this.get(e);if(t)return t;let i=m.fromString(this._client,e),n;switch(i.type){case"map":{n=b.zeroValue(this._objects,e);break}case"counter":n=f.zeroValue(this._objects,e);break}return this.set(e,n),n}_createInitialPool(){let e=new Map,t=b.zeroValue(this._objects,y);return e.set(t.getObjectId(),t),e}_onGCInterval(){let e=[];for(let[t,i]of this._pool.entries()){if(i.isTombstoned()&&Date.now()-i.tombstonedAt()>=g.gcGracePeriod){e.push(t);continue}i.onGCInterval()}e.forEach(t=>this._pool.delete(t))}};var D=class{constructor(e,t){this._objects=e;this._root=t;this._wrappedObjects=new Map;this._queuedMessages=[];this._isClosed=!1;this._client=e.getClient(),this._wrappedObjects.set(this._root.getObjectId(),new C(this,this._objects,this._root))}getRoot(){return this._objects.throwIfInvalidAccessApiConfiguration(),this.throwIfClosed(),this.getWrappedObject(y)}getWrappedObject(e){if(this._wrappedObjects.has(e))return this._wrappedObjects.get(e);let t=this._objects.getPool().get(e);if(!t)return;let i;if(t instanceof b)i=new C(this,this._objects,t);else if(t instanceof f)i=new T(this,this._objects,t);else throw new this._client.ErrorInfo(`Unknown LiveObject instance type: objectId=${t.getObjectId()}`,5e4,500);return this._wrappedObjects.set(e,i),i}throwIfClosed(){if(this.isClosed())throw new this._client.ErrorInfo("Batch is closed",4e4,400)}isClosed(){return this._isClosed}close(){this._isClosed=!0}queueMessage(e){this._queuedMessages.push(e)}async flush(){try{this.close(),this._queuedMessages.length>0&&await this._objects.publish(this._queuedMessages)}finally{this._wrappedObjects.clear(),this._queuedMessages=[]}}};var x=class{constructor(e){this._objects=e;this._client=this._objects.getClient(),this._channel=this._objects.getChannel(),this._pool=new Map}entries(){return this._pool.entries()}size(){return this._pool.size}isEmpty(){return this._pool.size===0}clear(){this._pool.clear()}applyObjectSyncMessages(e){for(let t of e){if(!t.object){this._client.Logger.logAction(this._client.logger,this._client.Logger.LOG_MAJOR,"SyncObjectsDataPool.applyObjectSyncMessages()",`object message is received during OBJECT_SYNC without 'object' field, skipping message; message id: ${t.id}, channel: ${this._channel.name}`);continue}let i=t.object;i.counter?this._pool.set(i.objectId,this._createLiveCounterDataEntry(i)):i.map?this._pool.set(i.objectId,this._createLiveMapDataEntry(i)):this._client.Logger.logAction(this._client.logger,this._client.Logger.LOG_MAJOR,"SyncObjectsDataPool.applyObjectSyncMessages()",`received unsupported object state message during OBJECT_SYNC, expected 'counter' or 'map' to be present, skipping message; message id: ${t.id}, channel: ${this._channel.name}`)}}_createLiveCounterDataEntry(e){return{objectState:e,objectType:"LiveCounter"}}_createLiveMapDataEntry(e){return{objectState:e,objectType:"LiveMap"}}};var ee={initialized:void 0,syncing:"syncing",synced:"synced"},I=class{constructor(e){this._channel=e,this._client=e.client,this._state="initialized",this._eventEmitterInternal=new this._client.EventEmitter(this._client.logger),this._eventEmitterPublic=new this._client.EventEmitter(this._client.logger),this._objectsPool=new w(this),this._syncObjectsDataPool=new x(this),this._bufferedObjectOperations=[]}async getRoot(){return this.throwIfInvalidAccessApiConfiguration(),this._state!=="synced"&&await this._eventEmitterInternal.once("synced"),this._objectsPool.get(y)}async batch(e){this.throwIfInvalidWriteApiConfiguration();let t=await this.getRoot(),i=new D(this,t);try{e(i),await i.flush()}finally{i.close()}}async createMap(e){var a;this.throwIfInvalidWriteApiConfiguration();let t=await b.createMapCreateMessage(this,e),i=(a=t.operation)==null?void 0:a.objectId;if(await this.publish([t]),this._objectsPool.get(i))return this._objectsPool.get(i);let n=b.fromObjectOperation(this,t.operation);return this._objectsPool.set(i,n),n}async createCounter(e){var a;this.throwIfInvalidWriteApiConfiguration();let t=await f.createCounterCreateMessage(this,e),i=(a=t.operation)==null?void 0:a.objectId;if(await this.publish([t]),this._objectsPool.get(i))return this._objectsPool.get(i);let n=f.fromObjectOperation(this,t.operation);return this._objectsPool.set(i,n),n}on(e,t){return this._eventEmitterPublic.on(e,t),{off:()=>{this._eventEmitterPublic.off(e,t)}}}off(e,t){this._client.Utils.isNil(e)&&this._client.Utils.isNil(t)||this._eventEmitterPublic.off(e,t)}offAll(){this._eventEmitterPublic.off()}getPool(){return this._objectsPool}getChannel(){return this._channel}getClient(){return this._client}handleObjectSyncMessages(e,t){let{syncId:i,syncCursor:n}=this._parseSyncChannelSerial(t),a=this._currentSyncId!==i;a&&this._startNewSync(i,n),this._syncObjectsDataPool.applyObjectSyncMessages(e),n||this._endSync(a)}handleObjectMessages(e){if(this._state!=="synced"){this._bufferedObjectOperations.push(...e);return}this._applyObjectMessages(e)}onAttached(e){this._client.Logger.logAction(this._client.logger,this._client.Logger.LOG_MINOR,"Objects.onAttached()",`channel=${this._channel.name}, hasObjects=${e}`);let t=this._state==="initialized";(e||t)&&this._startNewSync(),e||(this._objectsPool.resetToInitialPool(!0),this._syncObjectsDataPool.clear(),this._endSync(t))}actOnChannelState(e,t){switch(e){case"attached":this.onAttached(t);break;case"detached":case"failed":this._objectsPool.clearObjectsData(!1),this._syncObjectsDataPool.clear();break}}async publish(e){this._channel.throwIfUnpublishableState(),e.forEach(n=>l.encode(n,this._client));let t=this._client.options.maxMessageSize,i=e.reduce((n,a)=>n+a.getMessageSize(),0);if(i>t)throw new this._client.ErrorInfo(`Maximum size of object messages that can be published at once exceeded (was ${i} bytes; limit is ${t} bytes)`,40009,400);return this._channel.sendState(e)}throwIfInvalidAccessApiConfiguration(){this._throwIfMissingChannelMode("object_subscribe"),this._throwIfInChannelState(["detached","failed"])}throwIfInvalidWriteApiConfiguration(){this._throwIfMissingChannelMode("object_publish"),this._throwIfInChannelState(["detached","failed","suspended"]),this._throwIfEchoMessagesDisabled()}_startNewSync(e,t){this._bufferedObjectOperations=[],this._syncObjectsDataPool.clear(),this._currentSyncId=e,this._currentSyncCursor=t,this._stateChange("syncing",!1)}_endSync(e){this._applySync(),this._applyObjectMessages(this._bufferedObjectOperations),this._bufferedObjectOperations=[],this._syncObjectsDataPool.clear(),this._currentSyncId=void 0,this._currentSyncCursor=void 0,this._stateChange("synced",e)}_parseSyncChannelSerial(e){let t,i,n;return e&&(t=e.match(/^([\w-]+):(.*)$/))&&(i=t[1],n=t[2]),{syncId:i,syncCursor:n}}_applySync(){if(this._syncObjectsDataPool.isEmpty())return;let e=new Set,t=[];for(let[i,n]of this._syncObjectsDataPool.entries()){e.add(i);let a=this._objectsPool.get(i);if(a){let c=a.overrideWithObjectState(n.objectState);t.push({object:a,update:c});continue}let o,r=n.objectType;switch(r){case"LiveCounter":o=f.fromObjectState(this,n.objectState);break;case"LiveMap":o=b.fromObjectState(this,n.objectState);break;default:throw new this._client.ErrorInfo(`Unknown LiveObject type: ${r}`,5e4,500)}this._objectsPool.set(i,o)}this._objectsPool.deleteExtraObjectIds([...e]),t.forEach(({object:i,update:n})=>i.notifyUpdated(n))}_applyObjectMessages(e){for(let t of e){if(!t.operation){this._client.Logger.logAction(this._client.logger,this._client.Logger.LOG_MAJOR,"Objects._applyObjectMessages()",`object operation message is received without 'operation' field, skipping message; message id: ${t.id}, channel: ${this._channel.name}`);continue}let i=t.operation;switch(i.action){case 0:case 3:case 1:case 2:case 4:case 5:this._objectsPool.createZeroValueObjectIfNotExists(i.objectId),this._objectsPool.get(i.objectId).applyOperation(i,t);break;default:this._client.Logger.logAction(this._client.logger,this._client.Logger.LOG_MAJOR,"Objects._applyObjectMessages()",`received unsupported action in object operation message: ${i.action}, skipping message; message id: ${t.id}, channel: ${this._channel.name}`)}}}_throwIfMissingChannelMode(e){var t;if(this._channel.modes!=null&&!this._channel.modes.includes(e))throw new this._client.ErrorInfo(`"${e}" channel mode must be set for this operation`,40024,400);if(!this._client.Utils.allToLowerCase((t=this._channel.channelOptions.modes)!=null?t:[]).includes(e))throw new this._client.ErrorInfo(`"${e}" channel mode must be set for this operation`,40024,400)}_stateChange(e,t){if(this._state===e)return;this._state=e;let i=ee[e];i&&(t?this._client.Platform.Config.nextTick(()=>{this._eventEmitterInternal.emit(i),this._eventEmitterPublic.emit(i)}):(this._eventEmitterInternal.emit(i),this._eventEmitterPublic.emit(i)))}_throwIfInChannelState(e){if(e.includes(this._channel.state))throw this._client.ErrorInfo.fromValues(this._channel.invalidStateError())}_throwIfEchoMessagesDisabled(){if(this._channel.client.options.echoMessages===!1)throw new this._channel.client.ErrorInfo('"echoMessages" client option must be enabled for this operation',4e4,400)}};I._DEFAULTS=g;var te={Objects:I,ObjectMessage:l};
if (typeof module.exports == "object" && typeof exports == "object") {
  var __cp = (to, from, except, desc) => {
    if ((from && typeof from === "object") || typeof from === "function") {
      for (let key of Object.getOwnPropertyNames(from)) {
        if (!Object.prototype.hasOwnProperty.call(to, key) && key !== except)
        Object.defineProperty(to, key, {
          get: () => from[key],
          enumerable: !(desc = Object.getOwnPropertyDescriptor(from, key)) || desc.enumerable,
        });
      }
    }
    return to;
  };
  module.exports = __cp(module.exports, exports);
}
return module.exports;
}))
//# sourceMappingURL=objects.umd.min.js.map
