/*@license Copyright 2015-2022 Ably Real-time Ltd (ably.com)

Ably JavaScript Library v2.10.0
https://github.com/ably/ably-js

Released under the Apache Licence v2.0*/(function (g, f) {
    if ("object" == typeof exports && "object" == typeof module) {
      module.exports = f();
    } else if ("function" == typeof define && define.amd) {
      define([], f);
    } else if ("object" == typeof exports) {
      exports["AblyPushPlugin"] = f();
    } else {
      g["AblyPushPlugin"] = f();
    }
  }(this, () => {
var exports = {};
var module = { exports };
"use strict";var R=Object.defineProperty,ee=Object.defineProperties,te=Object.getOwnPropertyDescriptor,ne=Object.getOwnPropertyDescriptors,re=Object.getOwnPropertyNames,H=Object.getOwnPropertySymbols;var _=Object.prototype.hasOwnProperty,ie=Object.prototype.propertyIsEnumerable;var J=(r,e,t)=>e in r?R(r,e,{enumerable:!0,configurable:!0,writable:!0,value:t}):r[e]=t,q=(r,e)=>{for(var t in e||(e={}))_.call(e,t)&&J(r,t,e[t]);if(H)for(var t of H(e))ie.call(e,t)&&J(r,t,e[t]);return r},z=(r,e)=>ee(r,ne(e));var oe=(r,e)=>()=>(e||r((e={exports:{}}).exports,e),e.exports),se=(r,e)=>{for(var t in e)R(r,t,{get:e[t],enumerable:!0})},ae=(r,e,t,n)=>{if(e&&typeof e=="object"||typeof e=="function")for(let i of re(e))!_.call(r,i)&&i!==t&&R(r,i,{get:()=>e[i],enumerable:!(n=te(e,i))||n.enumerable});return r};var ce=r=>ae(R({},"__esModule",{value:!0}),r);var $=oe(()=>{});var Ce={};se(Ce,{ActivationStateMachine:()=>k,CalledActivate:()=>c,CalledDeactivate:()=>f,PushChannel:()=>F,default:()=>ke,getW3CPushDeviceDetails:()=>w,localDeviceFactory:()=>j});module.exports=ce(Ce);var N=class{constructor(e){this.channel=e,this.client=e.client}async subscribeDevice(){let e=this.client,t=e.device(),n=e.options.useBinaryProtocol?e.Utils.Format.msgpack:e.Utils.Format.json,i={deviceId:t.id,channel:this.channel.name},o=e.Defaults.defaultPostHeaders(e.options,{format:n});e.options.headers&&e.Utils.mixin(o,e.options.headers),e.Utils.mixin(o,this._getPushAuthHeaders());let s=e.Utils.encodeBody(i,e._MsgPack,n);await e.rest.Resource.post(e,"/push/channelSubscriptions",s,o,{},n,!0)}async unsubscribeDevice(){let e=this.client,t=e.device(),n=e.options.useBinaryProtocol?e.Utils.Format.msgpack:e.Utils.Format.json,i=e.Defaults.defaultPostHeaders(e.options,{format:n});e.options.headers&&e.Utils.mixin(i,e.options.headers),e.Utils.mixin(i,this._getPushAuthHeaders()),await e.rest.Resource.delete(e,"/push/channelSubscriptions",i,{deviceId:t.id,channel:this.channel.name},n,!0)}async subscribeClient(){let e=this.client,t=this.client.auth.clientId;if(!t)throw new this.client.ErrorInfo("Cannot subscribe from client without client ID",5e4,500);let n=e.options.useBinaryProtocol?e.Utils.Format.msgpack:e.Utils.Format.json,i={clientId:t,channel:this.channel.name},o=e.Defaults.defaultPostHeaders(e.options,{format:n});e.options.headers&&e.Utils.mixin(o,e.options.headers);let s=e.Utils.encodeBody(i,e._MsgPack,n);await e.rest.Resource.post(e,"/push/channelSubscriptions",s,o,{},n,!0)}async unsubscribeClient(){let e=this.client,t=this.client.auth.clientId;if(!t)throw new this.client.ErrorInfo("Cannot unsubscribe from client without client ID",5e4,500);let n=e.options.useBinaryProtocol?e.Utils.Format.msgpack:e.Utils.Format.json,i=e.Defaults.defaultPostHeaders(e.options,{format:n});e.options.headers&&e.Utils.mixin(i,e.options.headers),await e.rest.Resource.delete(e,"/push/channelSubscriptions",i,{clientId:t,channel:this.channel.name},n,!0)}async listSubscriptions(e){return this.client.Logger.logAction(this.client.logger,this.client.Logger.LOG_MICRO,"PushChannel.listSubscriptions()","channel = "+this.channel.name),this.client.push.admin.channelSubscriptions.list(z(q({},e),{channel:this.channel.name,concatFilters:!0}))}_getDeviceIdentityToken(){let t=this.client.device().deviceIdentityToken;if(t)return t;throw new this.client.ErrorInfo("Cannot subscribe from client without deviceIdentityToken",5e4,500)}_getPushAuthHeaders(){return{"X-Ably-DeviceToken":this._getDeviceIdentityToken()}}},F=N;function X(r){let e=new Uint8Array(r.slice(0,r.byteLength));return btoa(String.fromCharCode.apply(null,Array.from(e)))}function le(r){let e="=".repeat((4-r.length%4)%4);return(r+e).replace(/-/g,"+").replace(/_/g,"/")}function ue(r){let e=window.atob(r),t=[];for(let n=0;n<e.length;n++)t.push(e[n].charCodeAt(0));return Uint8Array.from(t)}async function w(r){let e=r.GettingPushDeviceDetailsFailed,t=r.GotPushDeviceDetails,{ErrorInfo:n,Defaults:i}=r.client;if(await Notification.requestPermission()!=="granted"){r.handleEvent(new e(new n("User denied permission to send notifications",400,4e4)));return}let s=r.client.options.pushServiceWorkerUrl;if(!s){r.handleEvent(new e(new n("Missing ClientOptions.pushServiceWorkerUrl",400,4e4)));return}try{let a=await navigator.serviceWorker.register(s);r._pushManager=a.pushManager;let d=i.defaultGetHeaders(r.client.options,{format:"text"}),p=(await r.client.rest.Resource.get(r.client,"/push/publicVapidKey",d,{},null,!0)).body;a.active||await navigator.serviceWorker.ready;let l=await a.pushManager.subscribe({userVisibleOnly:!0,applicationServerKey:ue(le(p))}),M=l.endpoint,[K,G]=[l.getKey("p256dh"),l.getKey("auth")];if(!K||!G)throw new n("Public key not found",5e4,500);let V=r.client.device();V.push.recipient={transportType:"web",targetUrl:btoa(M),publicVapidKey:p,encryptionKey:{p256dh:X(K),auth:X(G)}},V.persist(),r.handleEvent(new t)}catch(a){r.handleEvent(new e(new n("Failed to register service worker",5e4,500,a)))}}function S(r){var e=new Error(r);return e.source="ulid",e}var L="0123456789ABCDEFGHJKMNPQRSTVWXYZ",I=L.length,Q=Math.pow(2,48)-1,fe=10,de=16;function pe(r){var e=Math.floor(r()*I);return e===I&&(e=I-1),L.charAt(e)}function he(r,e){if(isNaN(r))throw new Error(r+" must be a number");if(r>Q)throw S("cannot encode time greater than "+Q);if(r<0)throw S("time must be positive");if(Number.isInteger(r)===!1)throw S("time must be an integer");for(var t=void 0,n="";e>0;e--)t=r%I,n=L.charAt(t)+n,r=(r-t)/I;return n}function ge(r,e){for(var t="";r>0;r--)t=pe(e)+t;return t}function me(){var r=arguments.length>0&&arguments[0]!==void 0?arguments[0]:!1,e=arguments[1];e||(e=typeof window!="undefined"?window:null);var t=e&&(e.crypto||e.msCrypto);if(t)return function(){var i=new Uint8Array(1);return t.getRandomValues(i),i[0]/255};try{var n=$();return function(){return n.randomBytes(1).readUInt8()/255}}catch(i){}if(r){try{console.error("secure crypto unusable, falling back to insecure Math.random()!")}catch(i){}return function(){return Math.random()}}throw S("secure crypto unusable, insecure Math.random not allowed")}function ve(r){return r||(r=me()),function(t){return isNaN(t)&&(t=Date.now()),he(t,fe)+ge(de,r)}}var W=ve();var u={deviceId:"ably.push.deviceId",deviceSecret:"ably.push.deviceSecret",deviceIdentityToken:"ably.push.deviceIdentityToken",pushRecipient:"ably.push.pushRecipient",activationState:"ably.push.activationState"};function j(r){return class Z extends r{constructor(n){super();this.push={},this.rest=n}static load(n){let i=new Z(n);return i.loadPersisted(),i}async listSubscriptions(){if(!this.rest.Platform.Config.push)throw new this.rest.ErrorInfo("Push activation is not available on this platform",4e4,400);if(!this.id)throw new this.rest.ErrorInfo("Device not activated",4e4,400);if(!this.deviceIdentityToken)throw new this.rest.ErrorInfo("Cannot list device subscriptions without deviceIdentityToken",5e4,500);let i=this.rest,o=i.options.useBinaryProtocol?i.Utils.Format.msgpack:i.Utils.Format.json,s=i.http.supportsLinkHeaders?void 0:o,a=i.Defaults.defaultGetHeaders(i.options,{format:o});return i.Utils.mixin(a,i.options.headers,{"X-Ably-DeviceToken":this.deviceIdentityToken}),new i.rest.PaginatedResource(i,"/push/channelSubscriptions",a,s,async function(d,p,l){return i.rest.PushChannelSubscription.fromResponseBody(d,i._MsgPack,l?void 0:o)}).get({deviceId:this.id})}loadPersisted(){var i;let n=this.rest.Platform;if(!n.Config.push)throw new this.rest.ErrorInfo("Push activation is not available on this platform",4e4,400);this.platform=n.Config.push.platform,this.clientId=(i=this.rest.auth.clientId)!=null?i:void 0,this.formFactor=n.Config.push.formFactor,this.id=n.Config.push.storage.get(u.deviceId),this.id?(this.deviceSecret=n.Config.push.storage.get(u.deviceSecret),this.deviceIdentityToken=JSON.parse(n.Config.push.storage.get(u.deviceIdentityToken)||"null"),this.push.recipient=JSON.parse(n.Config.push.storage.get(u.pushRecipient)||"null")):this.resetId()}persist(){let n=this.rest.Platform.Config;if(!n.push)throw new this.rest.ErrorInfo("Push activation is not available on this platform",4e4,400);this.id&&n.push.storage.set(u.deviceId,this.id),this.deviceSecret&&n.push.storage.set(u.deviceSecret,this.deviceSecret),this.deviceIdentityToken&&n.push.storage.set(u.deviceIdentityToken,JSON.stringify(this.deviceIdentityToken)),this.push.recipient&&n.push.storage.set(u.pushRecipient,JSON.stringify(this.push.recipient))}resetId(){this.id=W(),this.deviceSecret=W(),this.persist()}getAuthDetails(n,i,o){if(!this.deviceIdentityToken)throw new this.rest.ErrorInfo("Unable to update device registration; no deviceIdentityToken",5e4,500);return this.rest.http.supportsAuthHeaders?{headers:n.Utils.mixin({authorization:"Bearer "+n.Utils.toBase64(this.deviceIdentityToken)},i),params:o}:{headers:i,params:n.Utils.mixin({access_token:this.deviceIdentityToken},o)}}}}var k=class{constructor(e){this.GettingPushDeviceDetailsFailed=C;this.GotPushDeviceDetails=g;this.client=e,this._pushConfig=e.Platform.Config.push,this.current=new we[this.pushConfig.storage.get(u.activationState)||"NotActivated"](null),this.pendingEvents=[],this.handling=!1}get pushConfig(){if(!this._pushConfig)throw new this.client.ErrorInfo("This platform is not supported as a target of push notifications",4e4,400);return this._pushConfig}persist(){Ie(this.current)&&this.pushConfig.storage.set(u.activationState,this.current.name)}callUpdateRegistrationFailedCallback(e){this.updateFailedCallback?this.updateFailedCallback(e):this.client.Logger.logAction(this.client.logger,this.client.Logger.LOG_ERROR,"UpdateRegistrationFailed","Failed updating device push registration: "+this.client.Utils.inspectError(e))}callCustomRegisterer(e,t){var n;(n=this.registerCallback)==null||n.call(this,e,(i,o)=>{if(i){t?this.handleEvent(new m(i)):this.handleEvent(new E(i));return}o||this.handleEvent(new m(new this.client.ErrorInfo("registerCallback did not return deviceRegistration",4e4,400))),t?this.handleEvent(new y(o)):this.handleEvent(new T)})}callCustomDeregisterer(e){var t;(t=this.deregisterCallback)==null||t.call(this,e,n=>{if(n){this.handleEvent(new A(n));return}this.handleEvent(new D)})}async updateRegistration(){let e=this.client.device();if(this.registerCallback)this.callCustomRegisterer(e,!1);else{let t=this.client,n=t.options.useBinaryProtocol?this.client.Utils.Format.msgpack:this.client.Utils.Format.json,i=t.rest.DeviceDetails.fromLocalDevice(e),o=this.client.Defaults.defaultPostHeaders(this.client.options,{format:n}),s={};t.options.headers&&this.client.Utils.mixin(o,t.options.headers),t.options.pushFullWait&&this.client.Utils.mixin(s,{fullWait:"true"});let a=this.client.Utils.encodeBody(i,t._MsgPack,n),d=e.getAuthDetails(t,o,s);try{let p=await this.client.rest.Resource.patch(t,"/push/deviceRegistrations",a,d.headers,d.params,n,!0);this.handleEvent(new y(p.body))}catch(p){this.handleEvent(new m(p))}}}async deregister(){let e=this.client.device();if(this.deregisterCallback)this.callCustomDeregisterer(e);else{let t=this.client,n=t.options.useBinaryProtocol?this.client.Utils.Format.msgpack:this.client.Utils.Format.json,i=this.client.Defaults.defaultPostHeaders(t.options,{format:n}),o={deviceId:e.id};t.options.headers&&this.client.Utils.mixin(i,t.options.headers);let s=this.client.device().getAuthDetails(this.client,i,o);t.options.pushFullWait&&this.client.Utils.mixin(o,{fullWait:"true"});try{await this.client.rest.Resource.delete(t,"/push/deviceRegistrations",s.headers,s.params,n,!0),this.handleEvent(new D)}catch(a){this.handleEvent(new A(a))}}}callActivatedCallback(e){var t;(t=this.activatedCallback)==null||t.call(this,e),delete this.activatedCallback}callDeactivatedCallback(e){var t;(t=this.deactivatedCallback)==null||t.call(this,e),delete this.deactivatedCallback}handleEvent(e){if(this.handling){this.client.Platform.Config.nextTick(()=>{this.handleEvent(e)});return}this.handling=!0,this.client.Logger.logAction(this.client.logger,this.client.Logger.LOG_MAJOR,"Push.ActivationStateMachine.handleEvent()","handling event "+e.name+" from "+this.current.name);let t=this.current.processEvent(this,e);if(!t){this.client.Logger.logAction(this.client.logger,this.client.Logger.LOG_MAJOR,"Push.ActivationStateMachine.handleEvent()","enqueing event: "+e.name),this.pendingEvents.push(e),this.handling=!1;return}for(this.client.Logger.logAction(this.client.logger,this.client.Logger.LOG_MAJOR,"Push.ActivationStateMachine.handleEvent()","transition: "+this.current.name+" -("+e.name+")-> "+t.name),this.current=t;this.pendingEvents.length>0;){let n=this.pendingEvents[0];if(this.client.Logger.logAction(this.client.logger,this.client.Logger.LOG_MAJOR,"Push.ActivationStateMachine.handleEvent()","attempting to consume pending event: "+n.name),t=this.current.processEvent(this,n),!t)break;this.pendingEvents.splice(0,1),this.client.Logger.logAction(this.client.logger,this.client.Logger.LOG_MAJOR,"Push.ActivationStateMachine.handleEvent()","transition: "+this.current.name+" -("+n.name+")-> "+t.name),this.current=t}this.persist(),this.handling=!1}},c=class{constructor(e,t){this.name="CalledActivate";t&&(e.registerCallback=t),e.persist()}},f=class{constructor(e,t){this.name="CalledDeactivate";e.deregisterCallback=t,e.persist()}},g=class{constructor(){this.name="GotPushDeviceDetails"}},C=class{constructor(e){this.name="GettingPushDeviceDetailsFailed";this.reason=e}},y=class{constructor(e){this.name="GotDeviceRegistration";this.tokenDetails=e.deviceIdentityToken}},m=class{constructor(e){this.name="GettingDeviceRegistrationFailed";this.reason=e}},T=class{constructor(){this.name="RegistrationSynced"}},E=class{constructor(e){this.name="SyncRegistrationFailed";this.reason=e}},D=class{constructor(){this.name="Deregistered"}},A=class{constructor(e){this.name="DeregistrationFailed";this.reason=e}},h=class{constructor(e){this.name=e}},v=class r extends h{constructor(){super("NotActivated")}processEvent(e,t){var n,i;if(t instanceof f)return e.callDeactivatedCallback(null),new r;if(t instanceof c){let o=e.client.device();return o.deviceIdentityToken!=null?o.clientId&&o.clientId!==e.client.auth.clientId?(e.handleEvent(new E(new e.client.ErrorInfo("clientId not compatible with local device clientId",61002,400))),null):(e.pendingEvents.push(t),new b):(o.push.recipient?e.pendingEvents.push(new g):e.pushConfig.getPushDeviceDetails?(i=(n=e.pushConfig).getPushDeviceDetails)==null||i.call(n,e):e.pushConfig.platform==="browser"?w(e):e.handleEvent(new C(new e.client.ErrorInfo("No available implementation to get push device details",5e4,500))),new U)}else if(t instanceof g)return new r;return null}},U=class r extends h{constructor(){super("WaitingForPushDeviceDetails")}processEvent(e,t){if(t instanceof c)return new r;if(t instanceof f)return e.callDeactivatedCallback(null),new v;if(t instanceof g){let n=e.client,i=n.device();if(e.registerCallback)e.callCustomRegisterer(i,!0);else{let o=n.options.useBinaryProtocol?e.client.Utils.Format.msgpack:e.client.Utils.Format.json,s=n.rest.DeviceDetails.fromLocalDevice(i),a=e.client.Defaults.defaultPostHeaders(n.options,{format:o}),d={};n.options.headers&&e.client.Utils.mixin(a,n.options.headers),n.options.pushFullWait&&e.client.Utils.mixin(d,{fullWait:"true"});let p=e.client.Utils.encodeBody(s,n._MsgPack,o);e.client.rest.Resource.post(n,"/push/deviceRegistrations",p,a,d,null,!0).then(l=>{let M=l.unpacked?l.body:n.rest.DeviceDetails.fromResponseBody(l.body,n._MsgPack,o);e.handleEvent(new y(M))}).catch(l=>{e.handleEvent(new m(l))})}return new B}else if(t instanceof C)return e.callActivatedCallback(t.reason),new v;return null}},B=class r extends h{constructor(){super("WaitingForDeviceRegistration")}processEvent(e,t){if(t instanceof c)return new r;if(t instanceof y){let n=e.client.device();return n.deviceIdentityToken=t.tokenDetails.token,n.persist(),e.callActivatedCallback(null),new b}else if(t instanceof m)return e.callActivatedCallback(t.reason),new v;return null}},b=class r extends h{constructor(){super("WaitingForNewPushDeviceDetails")}processEvent(e,t){return t instanceof c?(e.callActivatedCallback(null),new r):t instanceof f?(e.deregister(),new x(this)):t instanceof g?(e.updateRegistration(),new P):null}},P=class r extends h{constructor(t=!1){super("WaitingForRegistrationSync");this.triggeredByCalledActivate=t}processEvent(t,n){return n instanceof c&&!this.triggeredByCalledActivate?(t.callActivatedCallback(null),new r(!0)):n instanceof T?new b:n instanceof E?(t.callUpdateRegistrationFailedCallback(n.reason),new O):null}},O=class extends h{constructor(){super("AfterRegistrationSyncFailed")}processEvent(e,t){return t instanceof c||t instanceof g?(e.updateRegistration(),new P(t instanceof c)):t instanceof f?(e.deregister(),new x(this)):null}},x=class r extends h{constructor(t){super("WaitingForDeregistration");this.previousState=t}processEvent(t,n){if(n instanceof f)return new r(this.previousState);if(n instanceof D){let i=t.client.device();return delete i.deviceIdentityToken,delete i.push.recipient,i.resetId(),i.persist(),t.callDeactivatedCallback(null),new v}else if(n instanceof A)return t.callDeactivatedCallback(n.reason),this.previousState;return null}},we={NotActivated:v,WaitingForPushDeviceDetails:U,WaitingForDeviceRegistration:B,WaitingForNewPushDeviceDetails:b,WaitingForRegistrationSync:P,AfterRegistrationSyncFailed:O,WaitingForDeregistration:x};function Ie(r){return r.name=="NotActivated"||r.name=="WaitingForNewPushDeviceDetails"}var ke={ActivationStateMachine:k,localDeviceFactory:j,CalledActivate:c,CalledDeactivate:f,PushChannel:F,getW3CPushDeviceDetails:w};
if (typeof module.exports == "object" && typeof exports == "object") {
  var __cp = (to, from, except, desc) => {
    if ((from && typeof from === "object") || typeof from === "function") {
      for (let key of Object.getOwnPropertyNames(from)) {
        if (!Object.prototype.hasOwnProperty.call(to, key) && key !== except)
        Object.defineProperty(to, key, {
          get: () => from[key],
          enumerable: !(desc = Object.getOwnPropertyDescriptor(from, key)) || desc.enumerable,
        });
      }
    }
    return to;
  };
  module.exports = __cp(module.exports, exports);
}
return module.exports;
}))
//# sourceMappingURL=push.umd.min.js.map
