import Link from 'next/link';
import { ReactNode } from 'react';
import { getObfuscatedRoute } from '@/hooks/use-obfuscated-router';

interface ObfuscatedLinkProps {
  href: 'dashboard' | 'analysis' | 'ai-operation' | 'ai-result' | 'automation' | 'login';
  children: ReactNode;
  className?: string;
  target?: string;
  rel?: string;
  title?: string;
}

/**
 * Link que automatically converte rotas reais para ofuscadas
 * Uso: <ObfuscatedLink href="dashboard">Dashboard</ObfuscatedLink>
 */
export function ObfuscatedLink({
  href,
  children,
  className,
  target,
  rel,
  title,
}: ObfuscatedLinkProps) {
  const obfuscatedHref = `/${getObfuscatedRoute(href)}`;

  return (
    <Link
      href={obfuscatedHref}
      className={className}
      target={target}
      rel={rel}
      title={title}
    >
      {children}
    </Link>
  );
}
