export function getProxyHttpBase(): string {
  const base = (
    process.env.PROXY_HTTP_BASE ||
    process.env.NEXT_PUBLIC_PROXY_HTTP_BASE ||
    "http://localhost:3030"
  )
  // Remove barra final para evitar duplicação
  return base.endsWith("/") ? base.slice(0, -1) : base
}

export function getProxyWsUrl(): string {
  return process.env.NEXT_PUBLIC_PROXY_WS_URL || "ws://localhost:3030/ws"
}

export function getProxyInternalKey(): string | undefined {
  // Permite configurar um segredo para chamadas server->server passarem no allowlist do proxy
  return process.env.PROXY_INTERNAL_KEY || process.env.INTERNAL_KEY || undefined
}

export function withProxyHeaders(init?: HeadersInit): HeadersInit {
  const key = getProxyInternalKey()
  if (!key) return init || {}
  const base: Record<string, string> = { "X-Internal-Key": key }
  // mescla mantendo headers existentes
  if (!init) return base
  if (Array.isArray(init)) return [...init, ["X-Internal-Key", key]]
  return { ...(init as Record<string, string>), ...base }
}
