/**
 * Mapeamento de Rotas Ofuscadas
 * 
 * Este arquivo mapeia rotas amigáveis para códigos ofuscados
 * para ocultar a estrutura da aplicação
 */

const routeMapping = {
  // Rotas públicas
  'login': 'a7f2b9c1',
  
  // Rotas protegidas - Dashboard e análise
  'dashboard': 'b3d4e8f2',
  'analysis': 'c5e6f7a3',
  
  // Rotas de operações de IA
  'ai-operation': 'd8f9a4b2',
  'ai-result': 'e2g3h5i7',
  
  // Rotas de automação
  'automation': 'f4j6k8l9',
};

// Gerar mapeamento reverso (para frontend)
const reverseMapping: Record<string, string> = {};
Object.entries(routeMapping).forEach(([route, hash]) => {
  reverseMapping[hash] = route;
});

export { routeMapping, reverseMapping };
