#!/bin/bash

# Script para fazer build e subir aplicação localmente via Apache
# Uso: ./start-local.sh

echo "🔨 Fazendo build da aplicação..."
npm run build

if [ $? -ne 0 ]; then
  echo "❌ Build falhou!"
  exit 1
fi

echo ""
echo "🛑 Matando processo anterior na porta 3000..."
fuser -k 3000/tcp 2>/dev/null
sleep 2

echo ""
echo "🚀 Iniciando Next.js em produção..."
npm run start &

sleep 3

echo ""
echo "✅ Aplicação iniciada!"
echo ""
echo "🌐 Acesse: http://optimus.local/"
echo ""
echo "📝 Logs em tempo real (Ctrl+C para sair):"
wait
