import { type NextRequest, NextResponse } from "next/server"

export const runtime = "nodejs"
export const dynamic = "force-dynamic"
export const fetchCache = "force-no-store"

export async function GET(request: NextRequest) {
  try {
    const authHeader = request.headers.get("authorization")
    if (!authHeader?.startsWith("Bearer ")) {
      return NextResponse.json({ error: "Token required" }, { status: 401 })
    }
    const token = authHeader.replace("Bearer ", "")

    console.log("=== CONSULTANDO SETTLEMENT ===")

    const response = await fetch("https://web-taurus.com/ws/settlement", {
      headers: { Authorization: `Bearer ${token}`, Accept: "application/json" },
    })

    if (!response.ok) {
      throw new Error(`Settlement failed: ${response.status}`)
    }

    const data = await response.json()
    console.log("=== SETTLEMENT RECEBIDO ===", data)

    return NextResponse.json(data)
  } catch (error) {
    console.error("Error getting settlement:", error)
    return NextResponse.json({ error: "Failed to get settlement" }, { status: 500 })
  }
}
