import { NextResponse } from "next/server"

export const runtime = "nodejs"
export const dynamic = "force-dynamic"
export const fetchCache = "force-no-store"

// Fallback (mantido do seu)
const fallbackSymbols = [
  { id: 1, code: "BTCUSDT", type: "crypto", name: "Bitcoin", status: 1, is_otc: 0, is_market_open: 1, img: "https://zlincontent.com/cdn/icons/symbols/bitcoin.png", last_price: "105688.900000", first_price_day: "103654.6", open_hour: "00:00:00", close_hour: "23:59:59", blocked_weekend: 0, daily_percent_variation: 1.96, payout: 1.85 },
  { id: 2, code: "LTCUSDT", type: "crypto", name: "Litecoin", status: 1, is_otc: 0, is_market_open: 1, img: "https://zlincontent.com/cdn/icons/symbols/litecoin.png", last_price: "84.260000", first_price_day: "81.98", open_hour: "00:00:00", close_hour: "23:59:59", blocked_weekend: 0, daily_percent_variation: 2.78, payout: 1.92 },
  { id: 3, code: "EURUSD", type: "forex", name: "Euro / US Dollar", status: 1, is_otc: 0, is_market_open: 1, img: "https://zlincontent.com/cdn/icons/symbols/eurusd.png", last_price: "1.0742", first_price_day: "1.0738", open_hour: "00:00:00", close_hour: "23:59:59", blocked_weekend: 1, daily_percent_variation: 0.04, payout: 1.85 },
  { id: 4, code: "AAPL", type: "stock", name: "Apple Inc.", status: 1, is_otc: 0, is_market_open: 1, img: "https://zlincontent.com/cdn/icons/symbols/aapl.png", last_price: "213.07", first_price_day: "212.85", open_hour: "09:30:00", close_hour: "16:00:00", blocked_weekend: 1, daily_percent_variation: 0.1, payout: 1.8 },
]

export async function GET() {
  const UPSTREAM = process.env.UPSTREAM_BASE_URL ?? "https://web-taurus.com"
  try {
    const response = await fetch(`${UPSTREAM}/ws/symbols`, {
      method: "GET",
      headers: { Accept: "application/json" },
      cache: "no-store",
    })

    if (!response.ok) {
      return NextResponse.json({ symbols: fallbackSymbols })
    }

    const data = await response.json()

    if (data && Array.isArray((data as any).symbols)) {
      return NextResponse.json({ symbols: (data as any).symbols })
    }
    if (Array.isArray(data)) {
      return NextResponse.json({ symbols: data })
    }

    return NextResponse.json({ symbols: fallbackSymbols })
  } catch {
    return NextResponse.json({ symbols: fallbackSymbols })
  }
}
