// /var/www/html/optimus/app/api/transaction/schedule-settlement/route.ts
export const runtime = "nodejs"

import { NextResponse } from "next/server"
import { scheduleSettlement } from "../../../../lib/scheduler"

export async function POST(req: Request) {
  try {
    const authHeader = req.headers.get("authorization") || ""
    const bearerToken = authHeader.replace(/^Bearer\s+/i, "").trim()
    if (!bearerToken) {
      return NextResponse.json({ ok: false, message: "Token ausente" }, { status: 401 })
    }

    // Monta baseUrl correta atrás de proxy/docker
    const proto = req.headers.get("x-forwarded-proto") ?? "http"
    const host  = req.headers.get("x-forwarded-host") ?? req.headers.get("host")
    if (!host) {
      return NextResponse.json({ ok: false, message: "Host ausente nos headers" }, { status: 400 })
    }
    const baseUrl = `${proto}://${host}`

    const body = await req.json().catch(() => ({}))
    const transactionId = Number(body?.transaction_id)
    const expirationDatetime = String(body?.expiration_datetime || "")

    if (!transactionId || !expirationDatetime) {
      return NextResponse.json(
        { ok: false, message: "transaction_id e expiration_datetime são obrigatórios" },
        { status: 400 },
      )
    }

    const info = scheduleSettlement({ transactionId, expirationDatetime, bearerToken, baseUrl })
    return NextResponse.json({ ok: true, ...info })
  } catch (e: any) {
    console.error("[schedule-settlement] erro:", e?.message || e)
    return NextResponse.json({ ok: false, message: "erro interno" }, { status: 500 })
  }
}
