/*@license Copyright 2015-2022 Ably Real-time Ltd (ably.com)

Ably JavaScript Library v2.10.0
https://github.com/ably/ably-js

Released under the Apache Licence v2.0*/(function (g, f) {
    if ("object" == typeof exports && "object" == typeof module) {
      module.exports = f();
    } else if ("function" == typeof define && define.amd) {
      define([], f);
    } else if ("object" == typeof exports) {
      exports["Ably"] = f();
    } else {
      g["Ably"] = f();
    }
  }(this, () => {
var exports = {};
var module = { exports };
"use strict";var mt=Object.defineProperty,Fs=Object.defineProperties,Gs=Object.getOwnPropertyDescriptor,js=Object.getOwnPropertyDescriptors,Ws=Object.getOwnPropertyNames,ft=Object.getOwnPropertySymbols;var zt=Object.prototype.hasOwnProperty,br=Object.prototype.propertyIsEnumerable;var Pr=(r,t,e)=>t in r?mt(r,t,{enumerable:!0,configurable:!0,writable:!0,value:e}):r[t]=e,E=(r,t)=>{for(var e in t||(t={}))zt.call(t,e)&&Pr(r,e,t[e]);if(ft)for(var e of ft(t))br.call(t,e)&&Pr(r,e,t[e]);return r},D=(r,t)=>Fs(r,js(t));var Cr=(r,t)=>{var e={};for(var n in r)zt.call(r,n)&&t.indexOf(n)<0&&(e[n]=r[n]);if(r!=null&&ft)for(var n of ft(r))t.indexOf(n)<0&&br.call(r,n)&&(e[n]=r[n]);return e};var Ar=(r,t)=>{for(var e in t)mt(r,e,{get:t[e],enumerable:!0})},Vs=(r,t,e,n)=>{if(t&&typeof t=="object"||typeof t=="function")for(let s of Ws(t))!zt.call(r,s)&&s!==e&&mt(r,s,{get:()=>t[s],enumerable:!(n=Gs(t,s))||n.enumerable});return r};var zs=r=>Vs(mt({},"__esModule",{value:!0}),r);var Ti={};Ar(Ti,{ErrorInfo:()=>h,Realtime:()=>Ve,Rest:()=>We,default:()=>Ai,makeProtocolMessageFromDeserialized:()=>Ln,msgpack:()=>Vt});module.exports=zs(Ti);var p=class{};var Jt=typeof global!="undefined"?global:typeof window!="undefined"?window:self;function yt(r,t){return`${r}`.padStart(t?3:2,"0")}function Js(r){return p.Config.logTimestamps?function(t){let e=new Date;r(yt(e.getHours())+":"+yt(e.getMinutes())+":"+yt(e.getSeconds())+"."+yt(e.getMilliseconds(),1)+" "+t)}:function(t){r(t)}}var Ks=()=>{var e;let r,t;return typeof((e=Jt==null?void 0:Jt.console)==null?void 0:e.log)=="function"?(r=function(...n){console.log.apply(console,n)},t=console.warn?function(...n){console.warn.apply(console,n)}:r):r=t=function(){},[r,t].map(Js)},J=class J{constructor(){this.deprecated=(t,e)=>{this.deprecationWarning(`${t} is deprecated and will be removed in a future version. ${e}`)};this.shouldLog=t=>t<=this.logLevel;this.setLog=(t,e)=>{t!==void 0&&(this.logLevel=t),e!==void 0&&(this.logHandler=this.logErrorHandler=e)};this.logLevel=J.defaultLogLevel,this.logHandler=J.defaultLogHandler,this.logErrorHandler=J.defaultLogErrorHandler}static initLogHandlers(){let[t,e]=Ks();this.defaultLogHandler=t,this.defaultLogErrorHandler=e,this.defaultLogger=new J}static logActionNoStrip(t,e,n,s){t.logAction(e,n,s)}logAction(t,e,n){this.shouldLog(t)&&(t===1?this.logErrorHandler:this.logHandler)("Ably: "+e+": "+n,t)}renamedClientOption(t,e){this.deprecationWarning(`The \`${t}\` client option has been renamed to \`${e}\`. Please update your code to use \`${e}\` instead. \`${t}\` will be removed in a future version.`)}renamedMethod(t,e,n){this.deprecationWarning(`\`${t}\`\u2019s \`${e}\` method has been renamed to \`${n}\`. Please update your code to use \`${n}\` instead. \`${e}\` will be removed in a future version.`)}deprecationWarning(t){this.shouldLog(1)&&this.logErrorHandler(`Ably: Deprecation warning - ${t}`,1)}};J.defaultLogLevel=1,J.LOG_NONE=0,J.LOG_ERROR=1,J.LOG_MAJOR=2,J.LOG_MINOR=3,J.LOG_MICRO=4,J.logAction=(t,e,n,s)=>{J.logActionNoStrip(t,e,n,s)};var Kt=J,i=Kt;var O={};Ar(O,{Format:()=>X,allSame:()=>Zt,allToLowerCase:()=>$e,allToUpperCase:()=>sn,arrChooseN:()=>rn,arrDeleteValue:()=>kr,arrEquals:()=>cn,arrIntersect:()=>wr,arrIntersectOb:()=>Or,arrPopRandomElement:()=>Rt,arrWithoutValue:()=>eo,cheapRandStr:()=>Te,containsValue:()=>Zs,copy:()=>oe,createMissingPluginError:()=>Ze,dataSizeBytes:()=>tn,decodeBody:()=>B,encodeBody:()=>H,ensureArray:()=>Qt,forInOwnNonNullProperties:()=>Yt,getBackoffCoefficient:()=>Mr,getGlobalObject:()=>Ye,getJitterCoefficient:()=>Er,getRetryTime:()=>Xe,inherits:()=>Ys,inspectBody:()=>en,inspectError:()=>w,intersect:()=>$t,isEmpty:()=>$s,isErrorInfoOrPartialErrorInfo:()=>Qe,isNil:()=>V,isObject:()=>ie,keysArray:()=>pe,matchDerivedChannel:()=>an,mixin:()=>C,parseQueryString:()=>Ae,prototypicalClone:()=>Ir,randomString:()=>nn,shallowClone:()=>Xs,shallowEquals:()=>on,throwMissingPluginError:()=>_,toBase64:()=>Ee,toQueryString:()=>le,valuesArray:()=>Xt,whenPromiseSettles:()=>N,withTimeoutAsync:()=>ln});function Tr(r){let t="["+r.constructor.name;return r.message&&(t+=": "+r.message),r.statusCode&&(t+="; statusCode="+r.statusCode),r.code&&(t+="; code="+r.code),r.cause&&(t+="; cause="+w(r.cause)),r.href&&!(r.message&&r.message.indexOf("help.ably.io")>-1)&&(t+="; see "+r.href+" "),t+="]",t}var h=class r extends Error{constructor(e,n,s,o){super(e);typeof Object.setPrototypeOf!="undefined"&&Object.setPrototypeOf(this,r.prototype),this.code=n,this.statusCode=s,this.cause=o}toString(){return Tr(this)}static fromValues(e){let{message:n,code:s,statusCode:o}=e;if(typeof n!="string"||typeof s!="number"||typeof o!="number")throw new Error("ErrorInfo.fromValues(): invalid values: "+p.Config.inspect(e));let a=Object.assign(new r(n,s,o),e);return a.code&&!a.href&&(a.href="https://help.ably.io/error/"+a.code),a}},v=class r extends Error{constructor(e,n,s,o){super(e);typeof Object.setPrototypeOf!="undefined"&&Object.setPrototypeOf(this,r.prototype),this.code=n,this.statusCode=s,this.cause=o}toString(){return Tr(this)}static fromValues(e){let{message:n,code:s,statusCode:o}=e;if(typeof n!="string"||!V(s)&&typeof s!="number"||!V(o)&&typeof o!="number")throw new Error("PartialErrorInfo.fromValues(): invalid values: "+p.Config.inspect(e));let a=Object.assign(new r(n,s,o),e);return a.code&&!a.href&&(a.href="https://help.ably.io/error/"+a.code),a}};function Qs(r){return Math.floor(Math.random()*r.length)}function C(r,...t){for(let e=0;e<t.length;e++){let n=t[e];if(!n)break;for(let s in n)Object.prototype.hasOwnProperty.call(n,s)&&(r[s]=n[s])}return r}function oe(r){return C({},r)}function Qt(r){return V(r)?[]:Array.isArray(r)?r:[r]}function ie(r){return Object.prototype.toString.call(r)=="[object Object]"}function $s(r){for(let t in r)return!1;return!0}function V(r){return r==null}function Xs(r){let t=new Object;for(let e in r)t[e]=r[e];return t}function Ir(r,t){class e{}e.prototype=r;let n=new e;return t&&C(n,t),n}var Ys=function(r,t){if(p.Config.inherits){p.Config.inherits(r,t);return}r.super_=t,r.prototype=Ir(t.prototype,{constructor:r})};function Zs(r,t){for(let e in r)if(r[e]==t)return!0;return!1}function $t(r,t){return Array.isArray(t)?wr(r,t):Or(r,t)}function wr(r,t){let e=[];for(let n=0;n<r.length;n++){let s=r[n];t.indexOf(s)!=-1&&e.push(s)}return e}function Or(r,t){let e=[];for(let n=0;n<r.length;n++){let s=r[n];s in t&&e.push(s)}return e}function kr(r,t){let e=r.indexOf(t),n=e!=-1;return n&&r.splice(e,1),n}function eo(r,t){let e=r.slice();return kr(e,t),e}function pe(r,t){let e=[];for(let n in r)t&&!Object.prototype.hasOwnProperty.call(r,n)||e.push(n);return e}function Xt(r,t){let e=[];for(let n in r)t&&!Object.prototype.hasOwnProperty.call(r,n)||e.push(r[n]);return e}function Yt(r,t){for(let e in r)Object.prototype.hasOwnProperty.call(r,e)&&r[e]&&t(e)}function Zt(r,t){if(r.length===0)return!0;let e=r[0][t];return r.every(function(n){return n[t]===e})}var X=(e=>(e.msgpack="msgpack",e.json="json",e))(X||{});function Rt(r){return r.splice(Qs(r),1)[0]}function le(r){let t=[];if(r)for(let e in r)t.push(encodeURIComponent(e)+"="+encodeURIComponent(r[e]));return t.length?"?"+t.join("&"):""}function Ae(r){let t,e=/([^?&=]+)=?([^&]*)/g,n={};for(;t=e.exec(r);)n[decodeURIComponent(t[1])]=decodeURIComponent(t[2]);return n}function Qe(r){return typeof r=="object"&&r!==null&&(r instanceof h||r instanceof v)}function w(r){var t,e;return r instanceof Error||((t=r==null?void 0:r.constructor)==null?void 0:t.name)==="ErrorInfo"||((e=r==null?void 0:r.constructor)==null?void 0:e.name)==="PartialErrorInfo"?r.toString():p.Config.inspect(r)}function en(r){return p.BufferUtils.isBuffer(r)?r.toString():typeof r=="string"?r:p.Config.inspect(r)}function tn(r){if(p.BufferUtils.isBuffer(r))return p.BufferUtils.byteLength(r);if(typeof r=="string")return p.Config.stringByteSize(r);if(typeof r=="number")return 8;if(typeof r=="boolean")return 1;throw new Error(`Expected input of Utils.dataSizeBytes to be a string, a number, a boolean or a buffer, but was: ${typeof r}`)}function Te(){return String(Math.random()).substr(2)}var nn=async r=>{let t=await p.Config.getRandomArrayBuffer(r);return p.BufferUtils.base64Encode(t)};function rn(r,t){let e=Math.min(t,r.length),n=r.slice(),s=[];for(let o=0;o<e;o++)s.push(Rt(n));return s}function N(r,t){r.then(e=>{t==null||t(null,e)}).catch(e=>{t==null||t(e)})}function B(r,t,e){return e=="msgpack"?(t||_("MsgPack"),t.decode(r)):JSON.parse(String(r))}function H(r,t,e){return e=="msgpack"?(t||_("MsgPack"),t.encode(r,!0)):JSON.stringify(r)}function $e(r){return r.map(function(t){return t&&t.toLowerCase()})}function sn(r){return r.map(function(t){return t&&t.toUpperCase()})}function Mr(r){return Math.min((r+2)/3,2)}function Er(){return 1-Math.random()*.2}function Xe(r,t){return r*Mr(t)*Er()}function Ye(){return typeof global!="undefined"?global:typeof window!="undefined"?window:self}function on(r,t){return Object.keys(r).every(e=>r[e]===t[e])&&Object.keys(t).every(e=>t[e]===r[e])}function an(r){let t=/^(\[([^?]*)(?:(.*))\])?(.+)$/,e=r.match(t);if(!e||!e.length||e.length<5)throw new h("regex match failed",400,40010);if(e[2])throw new h(`cannot use a derived option with a ${e[2]} channel`,400,40010);return{qualifierParam:e[3]||"",channelName:e[4]}}function Ee(r){let t=p.BufferUtils,e=t.utf8Encode(r);return t.base64Encode(e)}function cn(r,t){return r.length===t.length&&r.every(function(e,n){return e===t[n]})}function Ze(r){return new h(`${r} plugin not provided`,40019,400)}function _(r){throw Ze(r)}async function ln(r,t=5e3,e="Timeout expired"){let n=new h(e,5e4,500);return Promise.race([r,new Promise((s,o)=>setTimeout(()=>o(n),t))])}var un="2.10.0";var no="ably-js/"+un,Z={ENDPOINT:"main",ENVIRONMENT:"",REST_HOST:"rest.ably.io",REALTIME_HOST:"realtime.ably.io",FALLBACK_HOSTS:["main.a.fallback.ably-realtime.com","main.b.fallback.ably-realtime.com","main.c.fallback.ably-realtime.com","main.d.fallback.ably-realtime.com","main.e.fallback.ably-realtime.com"],PORT:80,TLS_PORT:443,TIMEOUTS:{disconnectedRetryTimeout:15e3,suspendedRetryTimeout:3e4,httpRequestTimeout:1e4,httpMaxRetryDuration:15e3,channelRetryTimeout:15e3,fallbackRetryTimeout:6e5,connectionStateTtl:12e4,realtimeRequestTimeout:1e4,recvTimeout:9e4,webSocketConnectTimeout:1e4,webSocketSlowTimeout:4e3},httpMaxRetryCount:3,maxMessageSize:65536,version:un,protocolVersion:3,agent:no,getPort:ro,getHttpScheme:so,getPrimaryDomainFromEndpoint:xr,getEndpointFallbackHosts:Ur,getFallbackHosts:Br,getHosts:oo,checkHost:_r,objectifyOptions:ao,normaliseOptions:lo,defaultGetHeaders:uo,defaultPostHeaders:ho};function ro(r,t){return t||r.tls?r.tlsPort:r.port}function so(r){return r.tls?"https://":"http://"}function Sr(r){return r.includes(".")||r.includes("::")||r==="localhost"}function xr(r){return Sr(r)?r:r.startsWith("nonprod:")?`${r.replace("nonprod:","")}.realtime.ably-nonprod.net`:`${r}.realtime.ably.net`}function Ur(r){if(Sr(r))return[];if(r.startsWith("nonprod:")){let t=r.replace("nonprod:","");return vr(t,"ably-realtime-nonprod.com")}return vr(r,"ably-realtime.com")}function vr(r,t){return["a","b","c","d","e"].map(e=>`${r}.${e}.fallback.${t}`)}function Br(r){let t=r.fallbackHosts,e=typeof r.httpMaxRetryCount!="undefined"?r.httpMaxRetryCount:Z.httpMaxRetryCount;return t?rn(t,e):[]}function oo(r){return[r.primaryDomain].concat(Br(r))}function _r(r){if(typeof r!="string")throw new h("host must be a string; was a "+typeof r,4e4,400);if(!r.length)throw new h("host must not be zero-length",4e4,400)}function io(r){let t={};for(let e in Z.TIMEOUTS)t[e]=r[e]||Z.TIMEOUTS[e];return t}function bt(r){let t=Z.agent;if(r.agents)for(var e in r.agents)t+=" "+e+"/"+r.agents[e];return t}function ao(r,t,e,n,s){if(r===void 0){let a=t?`${e} must be initialized with either a client options object, an Ably API key, or an Ably Token`:`${e} must be initialized with a client options object`;throw i.logAction(n,i.LOG_ERROR,`${e}()`,a),new Error(a)}let o;if(typeof r=="string")if(r.indexOf(":")==-1){if(!t){let a=`${e} cannot be initialized with just an Ably Token; you must provide a client options object with a \`plugins\` property. (Set this Ably Token as the object\u2019s \`token\` property.)`;throw i.logAction(n,i.LOG_ERROR,`${e}()`,a),new Error(a)}o={token:r}}else{if(!t){let a=`${e} cannot be initialized with just an Ably API key; you must provide a client options object with a \`plugins\` property. (Set this Ably API key as the object\u2019s \`key\` property.)`;throw i.logAction(n,i.LOG_ERROR,`${e}()`,a),new Error(a)}o={key:r}}else o=r;return s&&(o=D(E({},o),{plugins:E(E({},s),o.plugins)})),o}function co(r){if(r.endpoint&&(r.environment||r.restHost||r.realtimeHost))throw new h("The `endpoint` option cannot be used in conjunction with the `environment`, `restHost`, or `realtimeHost` options.",40106,400);if(r.environment&&(r.restHost||r.realtimeHost))throw new h("The `environment` option cannot be used in conjunction with the `restHost`, or `realtimeHost` options.",40106,400)}function lo(r,t,e){let n=e!=null?e:i.defaultLogger;r.environment&&n.deprecated("The `environment` client option","Use the `endpoint` client option instead."),r.restHost&&n.deprecated("The `restHost` client option","Use the `endpoint` client option instead."),r.realtimeHost&&n.deprecated("The `realtimeHost` client option","Use the `endpoint` client option instead."),co(r),typeof r.recover=="function"&&r.closeOnUnload===!0&&(i.logAction(n,i.LOG_ERROR,"Defaults.normaliseOptions","closeOnUnload was true and a session recovery function was set - these are mutually exclusive, so unsetting the latter"),r.recover=void 0),"closeOnUnload"in r||(r.closeOnUnload=!r.recover),"queueMessages"in r||(r.queueMessages=!0);let s=r.endpoint||Z.ENDPOINT;!r.fallbackHosts&&!r.restHost&&!r.realtimeHost&&!r.port&&!r.tlsPort&&(r.fallbackHosts=Ur(r.environment||s));let o=r.environment&&`${r.environment}.realtime.ably.net`,c=r.restHost||r.realtimeHost||o||xr(s);(r.fallbackHosts||[]).concat(c).forEach(_r),r.port=r.port||Z.PORT,r.tlsPort=r.tlsPort||Z.TLS_PORT,"tls"in r||(r.tls=!0);let l=io(r);t?"useBinaryProtocol"in r?r.useBinaryProtocol=p.Config.supportsBinary&&r.useBinaryProtocol:r.useBinaryProtocol=p.Config.preferBinary:r.useBinaryProtocol=!1;let u={};r.clientId&&(u["X-Ably-ClientId"]=p.BufferUtils.base64Encode(p.BufferUtils.utf8Encode(r.clientId))),"idempotentRestPublishing"in r||(r.idempotentRestPublishing=!0);let g=null,d=r.connectivityCheckUrl;if(r.connectivityCheckUrl){let[f,y]=r.connectivityCheckUrl.split("?");g=y?Ae(y):{},f.indexOf("://")===-1&&(f="https://"+f),d=f}let m=r.wsConnectivityCheckUrl;return m&&m.indexOf("://")===-1&&(m="wss://"+m),D(E({},r),{primaryDomain:c,maxMessageSize:r.maxMessageSize||Z.maxMessageSize,timeouts:l,connectivityCheckParams:g,connectivityCheckUrl:d,wsConnectivityCheckUrl:m,headers:u})}function ve(r,t,e){let n=e||{};if(n.cipher){r||_("Crypto");let s=r.getCipher(n.cipher,t);n.cipher=s.cipherParams,n.channelCipher=s.cipher}else"cipher"in n&&(n.cipher=void 0,n.channelCipher=null);return n}var Lr={json:"application/json",xml:"application/xml",html:"text/html",msgpack:"application/x-msgpack",text:"text/plain"},Pt={format:"json",protocolVersion:Z.protocolVersion};function uo(r,{format:t=Pt.format,protocolVersion:e=Pt.protocolVersion}={}){return{accept:Lr[t],"X-Ably-Version":e.toString(),"Ably-Agent":bt(r)}}function ho(r,{format:t=Pt.format,protocolVersion:e=Pt.protocolVersion}={}){let n;return{accept:n=Lr[t],"content-type":n,"X-Ably-Version":e.toString(),"Ably-Agent":bt(r)}}var R=Z;function Nr(r){return Object.assign(Z,r)}var hn=class r{constructor(t,e){this.logger=t;this.members=e||[]}call(t,e){for(let n of this.members)if(n)try{n(t,e)}catch(s){i.logAction(this.logger,i.LOG_ERROR,"Multicaster multiple callback handler","Unexpected exception: "+s+"; stack = "+s.stack)}}push(...t){this.members.push(...t)}createPromise(){return new Promise((t,e)=>{this.push((n,s)=>{n?e(n):t(s)})})}resolveAll(t){this.call(null,t)}rejectAll(t){this.call(t)}static create(t,e){let n=new r(t,e);return Object.assign((s,o)=>n.call(s,o),{push:s=>n.push(s),createPromise:()=>n.createPromise(),resolveAll:s=>n.resolveAll(s),rejectAll:s=>n.rejectAll(s)})}},Se=hn;var qr=(o=>(o.Get="get",o.Delete="delete",o.Post="post",o.Put="put",o.Patch="patch",o))(qr||{}),x=qr;var Dr=(c=>(c[c.Success=200]="Success",c[c.NoContent=204]="NoContent",c[c.BadRequest=400]="BadRequest",c[c.Unauthorized=401]="Unauthorized",c[c.Forbidden=403]="Forbidden",c[c.RequestTimeout=408]="RequestTimeout",c[c.InternalServerError=500]="InternalServerError",c))(Dr||{});function Hr(r){return r>=200&&r<400}var ge=Dr;var dn=Math.pow(2,17);function po(){return("000000"+Math.floor(Math.random()*1e16)).slice(-16)}function go(r){return!!r.connection}function Fr(r){return Qe(r)?(r.code||(r.statusCode===403?r.code=40300:(r.code=40170,r.statusCode=401)),r):new h(w(r),r.code||40170,r.statusCode||401)}var fo=(r,t)=>{let e=p.BufferUtils,n=e.utf8Encode(r),s=e.utf8Encode(t),o=e.hmacSha256(n,s);return e.base64Encode(o)};function Gr(r){if(!r)return"";typeof r=="string"&&(r=JSON.parse(r));let t=Object.create(null),e=pe(r,!0);if(!e)return"";e.sort();for(let n=0;n<e.length;n++)t[e[n]]=r[e[n]].sort();return JSON.stringify(t)}function jr(r,t){if(r.authCallback)i.logAction(t,i.LOG_MINOR,"Auth()","using token auth with authCallback");else if(r.authUrl)i.logAction(t,i.LOG_MINOR,"Auth()","using token auth with authUrl");else if(r.key)i.logAction(t,i.LOG_MINOR,"Auth()","using token auth with client-side signing");else if(r.tokenDetails)i.logAction(t,i.LOG_MINOR,"Auth()","using token auth with supplied token only");else{let e="authOptions must include valid authentication parameters";throw i.logAction(t,i.LOG_ERROR,"Auth()",e),new Error(e)}}function mo(r){return"useTokenAuth"in r&&!r.useTokenAuth}function gn(r){return r.useTokenAuth||!mo(r)&&(r.authCallback||r.authUrl||r.token||r.tokenDetails)}function yo(r){return!r.key&&!r.authCallback&&!r.authUrl}var Ro=0;function Po(){return Ro++}var pn=class{constructor(t,e){this.authOptions={};if(this.client=t,this.tokenParams=e.defaultTokenParams||{},this.currentTokenRequestId=null,this.waitingForTokenRequest=null,gn(e))yo(e)&&i.logAction(this.logger,i.LOG_ERROR,"Auth()","Warning: library initialized with a token literal without any way to renew the token when it expires (no authUrl, authCallback, or key). See https://help.ably.io/error/40171 for help"),this._saveTokenOptions(e.defaultTokenParams,e),jr(this.authOptions,this.logger);else{if(!e.key){let n="No authentication options provided; need one of: key, authUrl, or authCallback (or for testing only, token or tokenDetails)";throw i.logAction(this.logger,i.LOG_ERROR,"Auth()",n),new h(n,40160,401)}i.logAction(this.logger,i.LOG_MINOR,"Auth()","anonymous, using basic auth"),this._saveBasicOptions(e)}}get logger(){return this.client.logger}async authorize(t,e){if(e&&e.key&&this.authOptions.key!==e.key)throw new h("Unable to update auth options with incompatible key",40102,401);try{let n=await this._forceNewToken(t!=null?t:null,e!=null?e:null);return go(this.client)?new Promise((s,o)=>{this.client.connection.connectionManager.onAuthUpdated(n,(a,c)=>a?o(a):s(c))}):n}catch(n){throw this.client.connection&&n.statusCode===ge.Forbidden&&this.client.connection.connectionManager.actOnErrorFromAuthorize(n),n}}async _forceNewToken(t,e){this.tokenDetails=null,this._saveTokenOptions(t,e),jr(this.authOptions,this.logger);try{return this._ensureValidAuthCredentials(!0)}finally{delete this.tokenParams.timestamp,delete this.authOptions.queryTime}}async requestToken(t,e){let n=e||this.authOptions,s=t||oe(this.tokenParams),o,a=this.client;if(n.authCallback)i.logAction(this.logger,i.LOG_MINOR,"Auth.requestToken()","using token auth with authCallback"),o=n.authCallback;else if(n.authUrl)i.logAction(this.logger,i.LOG_MINOR,"Auth.requestToken()","using token auth with authUrl"),o=(l,u)=>{let g=C({accept:"application/json, text/plain"},n.authHeaders),d=n.authMethod&&n.authMethod.toLowerCase()==="post",m,f=n.authUrl.indexOf("?");f>-1&&(m=Ae(n.authUrl.slice(f)),n.authUrl=n.authUrl.slice(0,f),d||(n.authParams=C(m,n.authParams)));let y=C({},n.authParams||{},l),P=A=>{var I,$;let T=(I=A.body)!=null?I:null,k=null;if(A.error)i.logAction(this.logger,i.LOG_MICRO,"Auth.requestToken().tokenRequestCallback","Received Error: "+w(A.error));else{let G=($=A.headers["content-type"])!=null?$:null;Array.isArray(G)?k=G.join(", "):k=G,i.logAction(this.logger,i.LOG_MICRO,"Auth.requestToken().tokenRequestCallback","Received; content-type: "+k+"; body: "+en(T))}if(A.error){u(A.error,null);return}if(A.unpacked){u(null,T);return}if(p.BufferUtils.isBuffer(T)&&(T=T.toString()),!k){u(new h("authUrl response is missing a content-type header",40170,401),null);return}let U=k.indexOf("application/json")>-1,Me=k.indexOf("text/plain")>-1||k.indexOf("application/jwt")>-1;if(!U&&!Me){u(new h("authUrl responded with unacceptable content-type "+k+", should be either text/plain, application/jwt or application/json",40170,401),null);return}if(U){if(T.length>dn){u(new h("authUrl response exceeded max permitted length",40170,401),null);return}try{T=JSON.parse(T)}catch(G){u(new h("Unexpected error processing authURL response; err = "+G.message,40170,401),null);return}}u(null,T,k)};if(i.logAction(this.logger,i.LOG_MICRO,"Auth.requestToken().tokenRequestCallback","Requesting token from "+n.authUrl+"; Params: "+JSON.stringify(y)+"; method: "+(d?"POST":"GET")),d){let A=g||{};A["content-type"]="application/x-www-form-urlencoded";let T=le(y).slice(1);N(this.client.http.doUri(x.Post,n.authUrl,A,T,m),(k,U)=>P(k||U))}else N(this.client.http.doUri(x.Get,n.authUrl,g||{},null,y),(A,T)=>P(A||T))};else if(n.key)i.logAction(this.logger,i.LOG_MINOR,"Auth.requestToken()","using token auth with client-side signing"),o=(l,u)=>{N(this.createTokenRequest(l,n),(g,d)=>u(g,d!=null?d:null))};else{let l="Need a new token, but authOptions does not include any way to request one (no authUrl, authCallback, or key)";throw i.logAction(this.logger,i.LOG_ERROR,"Auth()","library initialized with a token literal without any way to renew the token when it expires (no authUrl, authCallback, or key). See https://help.ably.io/error/40171 for help"),new h(l,40171,403)}"capability"in s&&(s.capability=Gr(s.capability));let c=(l,u)=>{let g=l.keyName,d="/keys/"+g+"/requestToken",m=function(y){return a.baseUri(y)+d},f=R.defaultPostHeaders(this.client.options);n.requestHeaders&&C(f,n.requestHeaders),i.logAction(this.logger,i.LOG_MICRO,"Auth.requestToken().requestToken","Sending POST to "+d+"; Token params: "+JSON.stringify(l)),N(this.client.http.do(x.Post,m,f,JSON.stringify(l),null),(y,P)=>y?u(y):u(P.error,P.body,P.unpacked))};return new Promise((l,u)=>{let g=!1,d=this.client.options.timeouts.realtimeRequestTimeout,m=setTimeout(()=>{g=!0;let f="Token request callback timed out after "+d/1e3+" seconds";i.logAction(this.logger,i.LOG_ERROR,"Auth.requestToken()",f),u(new h(f,40170,401))},d);o(s,(f,y,P)=>{if(g)return;if(clearTimeout(m),f){i.logAction(this.logger,i.LOG_ERROR,"Auth.requestToken()","token request signing call returned error; err = "+w(f)),u(Fr(f));return}if(typeof y=="string"){y.length===0?u(new h("Token string is empty",40170,401)):y.length>dn?u(new h("Token string exceeded max permitted length (was "+y.length+" bytes)",40170,401)):y==="undefined"||y==="null"?u(new h("Token string was literal null/undefined",40170,401)):y[0]==="{"&&!(P&&P.indexOf("application/jwt")>-1)?u(new h("Token was double-encoded; make sure you're not JSON-encoding an already encoded token request or details",40170,401)):l({token:y});return}if(typeof y!="object"||y===null){let T="Expected token request callback to call back with a token string or token request/details object, but got a "+typeof y;i.logAction(this.logger,i.LOG_ERROR,"Auth.requestToken()",T),u(new h(T,40170,401));return}let A=JSON.stringify(y).length;if(A>dn&&!n.suppressMaxLengthCheck){u(new h("Token request/details object exceeded max permitted stringified size (was "+A+" bytes)",40170,401));return}if("issued"in y){l(y);return}if(!("keyName"in y)){let T="Expected token request callback to call back with a token string, token request object, or token details object";i.logAction(this.logger,i.LOG_ERROR,"Auth.requestToken()",T),u(new h(T,40170,401));return}c(y,(T,k,U)=>{if(T){i.logAction(this.logger,i.LOG_ERROR,"Auth.requestToken()","token request API call returned error; err = "+w(T)),u(Fr(T));return}U||(k=JSON.parse(k)),i.logAction(this.logger,i.LOG_MINOR,"Auth.getToken()","token received"),l(k)})})})}async createTokenRequest(t,e){e=e||this.authOptions,t=t||oe(this.tokenParams);let n=e.key;if(!n)throw new h("No key specified",40101,403);let s=n.split(":"),o=s[0],a=s[1];if(!a)throw new h("Invalid key specified",40101,403);if(t.clientId==="")throw new h("clientId can\u2019t be an empty string",40012,400);"capability"in t&&(t.capability=Gr(t.capability));let c=C({keyName:o},t),l=t.clientId||"",u=t.ttl||"",g=t.capability||"";c.timestamp||(c.timestamp=await this._getTimestamp(e&&e.queryTime));let d=c.nonce||(c.nonce=po()),m=c.timestamp,f=c.keyName+`
`+u+`
`+g+`
`+l+`
`+m+`
`+d+`
`;return c.mac=c.mac||fo(f,a),i.logAction(this.logger,i.LOG_MINOR,"Auth.getTokenRequest()","generated signed request"),c}async getAuthParams(){if(this.method=="basic")return{key:this.key};{let t=await this._ensureValidAuthCredentials(!1);if(!t)throw new Error("Auth.getAuthParams(): _ensureValidAuthCredentials returned no error or tokenDetails");return{access_token:t.token}}}async getAuthHeaders(){if(this.method=="basic")return{authorization:"Basic "+this.basicKey};{let t=await this._ensureValidAuthCredentials(!1);if(!t)throw new Error("Auth.getAuthParams(): _ensureValidAuthCredentials returned no error or tokenDetails");return{authorization:"Bearer "+Ee(t.token)}}}_saveBasicOptions(t){this.method="basic",this.key=t.key,this.basicKey=Ee(t.key),this.authOptions=t||{},"clientId"in t&&this._userSetClientId(t.clientId)}_saveTokenOptions(t,e){this.method="token",t&&(this.tokenParams=t),e&&(e.token&&(e.tokenDetails=typeof e.token=="string"?{token:e.token}:e.token),e.tokenDetails&&(this.tokenDetails=e.tokenDetails),"clientId"in e&&this._userSetClientId(e.clientId),this.authOptions=e)}async _ensureValidAuthCredentials(t){let e=this.tokenDetails;if(e){if(this._tokenClientIdMismatch(e.clientId))throw new h("Mismatch between clientId in token ("+e.clientId+") and current clientId ("+this.clientId+")",40102,403);if(!this.client.isTimeOffsetSet()||!e.expires||e.expires>=this.client.getTimestampUsingOffset())return i.logAction(this.logger,i.LOG_MINOR,"Auth.getToken()","using cached token; expires = "+e.expires),e;i.logAction(this.logger,i.LOG_MINOR,"Auth.getToken()","deleting expired token"),this.tokenDetails=null}let n=(this.waitingForTokenRequest||(this.waitingForTokenRequest=Se.create(this.logger))).createPromise();if(this.currentTokenRequestId!==null&&!t)return n;let s=this.currentTokenRequestId=Po(),o,a=null;try{o=await this.requestToken(this.tokenParams,this.authOptions)}catch(l){a=l}if(this.currentTokenRequestId>s)return i.logAction(this.logger,i.LOG_MINOR,"Auth._ensureValidAuthCredentials()","Discarding token request response; overtaken by newer one"),n;this.currentTokenRequestId=null;let c=this.waitingForTokenRequest;return this.waitingForTokenRequest=null,a?(c==null||c.rejectAll(a),n):(c==null||c.resolveAll(this.tokenDetails=o),n)}_userSetClientId(t){if(typeof t=="string"||t===null){if(t==="*")throw new h('Can\u2019t use "*" as a clientId as that string is reserved. (To change the default token request behaviour to use a wildcard clientId, instantiate the library with {defaultTokenParams: {clientId: "*"}}), or if calling authorize(), pass it in as a tokenParam: authorize({clientId: "*"}, authOptions)',40012,400);{let e=this._uncheckedSetClientId(t);if(e)throw e}}else throw new h("clientId must be either a string or null",40012,400)}_uncheckedSetClientId(t){if(this._tokenClientIdMismatch(t)){let e="Unexpected clientId mismatch: client has "+this.clientId+", requested "+t,n=new h(e,40102,401);return i.logAction(this.logger,i.LOG_ERROR,"Auth._uncheckedSetClientId()",e),n}else return this.clientId=this.tokenParams.clientId=t,null}_tokenClientIdMismatch(t){return!!(this.clientId&&this.clientId!=="*"&&t&&t!=="*"&&this.clientId!==t)}static isTokenErr(t){return t.code&&t.code>=40140&&t.code<40150}revokeTokens(t,e){return this.client.rest.revokeTokens(t,e)}async _getTimestamp(t){return this.client.getTimestamp(t||!!this.authOptions.queryTime)}},Q=pn;function Ct(r){let t=[];if(r)for(let e in r)t.push(e+"="+r[e]);return t.join("&")}function Ie(r,t){return r+(t?"?":"")+Ct(t)}function bo(r,t,e,n,s){r.error?i.logActionNoStrip(s,i.LOG_MICRO,"Http."+t+"()","Received Error; "+Ie(e,n)+"; Error: "+w(r.error)):i.logActionNoStrip(s,i.LOG_MICRO,"Http."+t+"()","Received; "+Ie(e,n)+"; Headers: "+Ct(r.headers)+"; StatusCode: "+r.statusCode+"; Body"+(p.BufferUtils.isBuffer(r.body)?" (Base64): "+p.BufferUtils.base64Encode(r.body):": "+r.body))}function Co(r,t,e,n,s){s.shouldLog(i.LOG_MICRO)&&i.logActionNoStrip(s,i.LOG_MICRO,"Http."+r+"()","Sending; "+Ie(t,n)+"; Body"+(p.BufferUtils.isBuffer(e)?" (Base64): "+p.BufferUtils.base64Encode(e):": "+e))}var fe=class{constructor(t){this.client=t;this.platformHttp=new p.Http(t),this.checkConnectivity=this.platformHttp.checkConnectivity?()=>this.platformHttp.checkConnectivity():void 0}get logger(){var t,e;return(e=(t=this.client)==null?void 0:t.logger)!=null?e:i.defaultLogger}get supportsAuthHeaders(){return this.platformHttp.supportsAuthHeaders}get supportsLinkHeaders(){return this.platformHttp.supportsLinkHeaders}_getHosts(t){let e=t.connection,n=e&&e.connectionManager.host;return n?[n].concat(R.getFallbackHosts(t.options)):R.getHosts(t.options)}async do(t,e,n,s,o){try{let a=this.client;if(!a)return{error:new h("http.do called without client",5e4,500)};let c=typeof e=="function"?e:function(m){return a.baseUri(m)+e},l=a._currentFallback;if(l)if(l.validUntil>Date.now()){let m=await this.doUri(t,c(l.host),n,s,o);return m.error&&this.platformHttp.shouldFallback(m.error)?(a._currentFallback=null,this.do(t,e,n,s,o)):m}else a._currentFallback=null;let u=this._getHosts(a);if(u.length===1)return this.doUri(t,c(u[0]),n,s,o);let g=null,d=async(m,f)=>{let y=m.shift();g=g!=null?g:new Date;let P=await this.doUri(t,c(y),n,s,o);return P.error&&this.platformHttp.shouldFallback(P.error)&&m.length?Date.now()-g.getTime()>a.options.timeouts.httpMaxRetryDuration?{error:new h(`Timeout for trying fallback hosts retries. Total elapsed time exceeded the ${a.options.timeouts.httpMaxRetryDuration}ms limit`,50003,500)}:d(m,!0):(f&&(a._currentFallback={host:y,validUntil:Date.now()+a.options.timeouts.fallbackRetryTimeout}),P)};return d(u)}catch(a){return{error:new h(`Unexpected error in Http.do: ${w(a)}`,500,5e4)}}}async doUri(t,e,n,s,o){try{Co(t,e,s,o,this.logger);let a=await this.platformHttp.doUri(t,e,n,s,o);return this.logger.shouldLog(i.LOG_MICRO)&&bo(a,t,e,o,this.logger),a}catch(a){return{error:new h(`Unexpected error in Http.doUri: ${w(a)}`,500,5e4)}}}};function Ao(r,t,e,n){try{e.apply(t,n)}catch(s){i.logAction(r,i.LOG_ERROR,"EventEmitter.emit()","Unexpected listener exception: "+s+"; stack = "+(s&&s.stack))}}function fn(r,t,e){let n,s,o;for(let a=0;a<r.length;a++)if(n=r[a],e&&(n=n[e]),Array.isArray(n)){for(;(s=n.indexOf(t))!==-1;)n.splice(s,1);e&&n.length===0&&delete r[a][e]}else if(ie(n))for(o in n)Object.prototype.hasOwnProperty.call(n,o)&&Array.isArray(n[o])&&fn([n],t,o)}var mn=class{constructor(t){this.logger=t;this.any=[],this.events=Object.create(null),this.anyOnce=[],this.eventsOnce=Object.create(null)}on(...t){if(t.length===1){let e=t[0];if(typeof e=="function")this.any.push(e);else throw new Error("EventListener.on(): Invalid arguments: "+p.Config.inspect(t))}if(t.length===2){let[e,n]=t;if(typeof n!="function")throw new Error("EventListener.on(): Invalid arguments: "+p.Config.inspect(t));if(V(e))this.any.push(n);else if(Array.isArray(e))e.forEach(s=>{this.on(s,n)});else{if(typeof e!="string")throw new Error("EventListener.on(): Invalid arguments: "+p.Config.inspect(t));(this.events[e]||(this.events[e]=[])).push(n)}}}off(...t){if(t.length==0||V(t[0])&&V(t[1])){this.any=[],this.events=Object.create(null),this.anyOnce=[],this.eventsOnce=Object.create(null);return}let[e,n]=t,s=null,o=null;if(t.length===1||!n)typeof e=="function"?s=e:o=e;else{if(typeof n!="function")throw new Error("EventEmitter.off(): invalid arguments:"+p.Config.inspect(t));[o,s]=[e,n]}if(s&&V(o)){fn([this.any,this.events,this.anyOnce,this.eventsOnce],s);return}if(Array.isArray(o)){o.forEach(a=>{this.off(a,s)});return}if(typeof o!="string")throw new Error("EventEmitter.off(): invalid arguments:"+p.Config.inspect(t));s?fn([this.events,this.eventsOnce],s,o):(delete this.events[o],delete this.eventsOnce[o])}listeners(t){if(t){let e=this.events[t]||[];return this.eventsOnce[t]&&Array.prototype.push.apply(e,this.eventsOnce[t]),e.length?e:null}return this.any.length?this.any:null}emit(t,...e){let n={event:t},s=[];this.anyOnce.length&&(Array.prototype.push.apply(s,this.anyOnce),this.anyOnce=[]),this.any.length&&Array.prototype.push.apply(s,this.any);let o=this.eventsOnce[t];o&&(Array.prototype.push.apply(s,o),delete this.eventsOnce[t]);let a=this.events[t];a&&Array.prototype.push.apply(s,a),s.forEach(c=>{Ao(this.logger,n,c,e)})}once(...t){let e=t.length;if(e===0||e===1&&typeof t[0]!="function"){let o=t[0];return new Promise(a=>{this.once(o,a)})}let[n,s]=t;if(t.length===1&&typeof n=="function")this.anyOnce.push(n);else if(V(n)){if(typeof s!="function")throw new Error("EventEmitter.once(): Invalid arguments:"+p.Config.inspect(t));this.anyOnce.push(s)}else if(Array.isArray(n)){let o=this,a=function(){let c=Array.prototype.slice.call(arguments);if(n.forEach(function(l){o.off(l,a)}),typeof s!="function")throw new Error("EventEmitter.once(): Invalid arguments:"+p.Config.inspect(t));s.apply(this,c)};n.forEach(function(c){o.on(c,a)})}else{if(typeof n!="string")throw new Error("EventEmitter.once(): Invalid arguments:"+p.Config.inspect(t));let o=this.eventsOnce[n]||(this.eventsOnce[n]=[]);if(s){if(typeof s!="function")throw new Error("EventEmitter.once(): Invalid arguments:"+p.Config.inspect(t));o.push(s)}}}async whenState(t,e){if(typeof t!="string"||typeof e!="string")throw new Error("whenState requires a valid state String argument");return t===e?null:this.once(t)}},M=mn;var b={HEARTBEAT:0,ACK:1,NACK:2,CONNECT:3,CONNECTED:4,DISCONNECT:5,DISCONNECTED:6,CLOSE:7,CLOSED:8,ERROR:9,ATTACH:10,ATTACHED:11,DETACH:12,DETACHED:13,PRESENCE:14,MESSAGE:15,SYNC:16,AUTH:17,ACTIVATE:18,OBJECT:19,OBJECT_SYNC:20,ANNOTATION:21},yn=[];Object.keys(b).forEach(function(r){yn[b[r]]=r});var j={HAS_PRESENCE:1,HAS_BACKLOG:2,RESUMED:4,TRANSIENT:16,ATTACH_RESUME:32,HAS_OBJECTS:128,PRESENCE:65536,PUBLISH:1<<17,SUBSCRIBE:1<<18,PRESENCE_SUBSCRIBE:1<<19,ANNOTATION_PUBLISH:1<<21,ANNOTATION_SUBSCRIBE:1<<22,OBJECT_SUBSCRIBE:1<<24,OBJECT_PUBLISH:1<<25},Wr=Object.keys(j);j.MODE_ALL=j.PRESENCE|j.PUBLISH|j.SUBSCRIBE|j.PRESENCE_SUBSCRIBE|j.ANNOTATION_PUBLISH|j.ANNOTATION_SUBSCRIBE|j.OBJECT_SUBSCRIBE|j.OBJECT_PUBLISH;var At=["PRESENCE","PUBLISH","SUBSCRIBE","PRESENCE_SUBSCRIBE","ANNOTATION_PUBLISH","ANNOTATION_SUBSCRIBE","OBJECT_SUBSCRIBE","OBJECT_PUBLISH"];function To(r){return!r||!r.channelOptions?{channelOptions:r,plugins:{},baseEncodedPreviousPayload:void 0}:r}function Tt(r,t,e){if(e&&e.cipher){r||_("Crypto");let n=r.getCipher(e.cipher,t);return{cipher:n.cipherParams,channelCipher:n.cipher}}return e!=null?e:{}}async function Io(r,t){let{data:e,encoding:n}=await Vr(r.data,r.encoding,t);return r.data=e,r.encoding=n,r}async function Vr(r,t,e){let n=e.channelCipher,s=r,o=t?t+"/":"";p.BufferUtils.isBuffer(s)||(s=p.BufferUtils.utf8Encode(String(s)),o=o+"utf-8/");let a=await n.encrypt(s);return o=o+"cipher+"+n.algorithm,{data:a,encoding:o}}async function xe(r,t){let e=typeof r.data=="string"||p.BufferUtils.isBuffer(r.data)||r.data===null||r.data===void 0,{data:n,encoding:s}=zr(r.data,r.encoding,e);return r.data=n,r.encoding=s,t!=null&&t.cipher?Io(r,t):r}function zr(r,t,e){if(e)return{data:r,encoding:t};if(ie(r)||Array.isArray(r))return{data:JSON.stringify(r),encoding:t?t+"/json":"json"};throw new h("Data type is unsupported",40013,400)}async function Ue(r,t){let{data:e,encoding:n,error:s}=await Jr(r.data,r.encoding,t);if(r.data=e,r.encoding=n,s)throw s}async function Jr(r,t,e){let n=To(e),s=r,o=r,a=t,c;if(t){let l=t.split("/"),u,g=l.length,d="";try{for(;(u=g)>0;){let m=l[--g].match(/([-\w]+)(\+([\w-]+))?/);if(!m)break;switch(d=m[1],d){case"base64":o=p.BufferUtils.base64Decode(String(o)),u==l.length&&(s=o);continue;case"utf-8":o=p.BufferUtils.utf8Decode(o);continue;case"json":o=JSON.parse(o);continue;case"cipher":if(n.channelOptions!=null&&n.channelOptions.cipher&&n.channelOptions.channelCipher){let f=m[3],y=n.channelOptions.channelCipher;if(f!=y.algorithm)throw new Error("Unable to decrypt message with given cipher; incompatible cipher params");o=await y.decrypt(o);continue}else throw new Error("Unable to decrypt message; not an encrypted channel");case"vcdiff":if(!n.plugins||!n.plugins.vcdiff)throw new h("Missing Vcdiff decoder (https://github.com/ably-forks/vcdiff-decoder)",40019,400);if(typeof Uint8Array=="undefined")throw new h("Delta decoding not supported on this browser (need ArrayBuffer & Uint8Array)",40020,400);try{let f=n.baseEncodedPreviousPayload;typeof f=="string"&&(f=p.BufferUtils.utf8Encode(f));let y=p.BufferUtils.toBuffer(f);o=p.BufferUtils.toBuffer(o),o=p.BufferUtils.arrayBufferViewToBuffer(n.plugins.vcdiff.decode(o,y)),s=o}catch(f){throw new h("Vcdiff delta decode failed with "+f,40018,400)}continue;default:throw new Error("Unknown encoding")}}}catch(m){let f=m;c=new h(`Error processing the ${d} encoding, decoder returned \u2018${f.message}\u2019`,f.code||40013,400)}finally{a=u<=0?null:l.slice(0,u).join("/")}}return c?{error:c,data:o,encoding:a}:(n.baseEncodedPreviousPayload=s,{data:o,encoding:a})}function Be(...r){let t=r.length>0?"json":"msgpack",{data:e,encoding:n}=Kr(this.data,this.encoding,t);return Object.assign({},this,{encoding:n,data:e})}function Kr(r,t,e){return!r||!p.BufferUtils.isBuffer(r)?{data:r,encoding:t}:e==="msgpack"?{data:p.BufferUtils.toBuffer(r),encoding:t}:{data:p.BufferUtils.base64Encode(r),encoding:t?t+"/base64":"base64"}}var we={encryptData:Vr,encodeData:zr,encodeDataForWire:Kr,decodeData:Jr};function et(r){let{id:t,connectionId:e,timestamp:n}=r,s;switch(r.action){case b.MESSAGE:{s=r.messages;break}case b.PRESENCE:case b.SYNC:s=r.presence;break;case b.ANNOTATION:s=r.annotations;break;case b.OBJECT:case b.OBJECT_SYNC:s=r.state;break;default:throw new h("Unexpected action "+r.action,4e4,400)}for(let o=0;o<s.length;o++){let a=s[o];a.connectionId||(a.connectionId=e),a.timestamp||(a.timestamp=n),t&&!a.id&&(a.id=t+":"+o)}}function ue(r,t){let e="["+t;for(let n in r)n==="data"?typeof r.data=="string"?e+="; data="+r.data:p.BufferUtils.isBuffer(r.data)?e+="; data (buffer)="+p.BufferUtils.base64Encode(r.data):typeof r.data!="undefined"&&(e+="; data (json)="+JSON.stringify(r.data)):n&&(n==="extras"||n==="operation")?e+="; "+n+"="+JSON.stringify(r[n]):r[n]!==void 0&&(e+="; "+n+"="+r[n]);return e+="]",e}var ee=class{};var It=class{constructor(t){this.Platform=p;this.ErrorInfo=h;this.Logger=i;this.Defaults=R;this.Utils=O;this.EventEmitter=M;this.MessageEncoding=we;var n,s,o,a,c,l,u,g,d,m;this._additionalHTTPRequestImplementations=(n=t.plugins)!=null?n:null,this.logger=new i,this.logger.setLog(t.logLevel,t.logHandler),i.logAction(this.logger,i.LOG_MICRO,"BaseClient()","initialized with clientOptions "+p.Config.inspect(t)),this._MsgPack=(o=(s=t.plugins)==null?void 0:s.MsgPack)!=null?o:null;let e=this.options=R.normaliseOptions(t,this._MsgPack,this.logger);if(e.key){let f=e.key.match(/^([^:\s]+):([^:.\s]+)$/);if(!f){let y="invalid key parameter";throw i.logAction(this.logger,i.LOG_ERROR,"BaseClient()",y),new h(y,40400,404)}e.keyName=f[1],e.keySecret=f[2]}if("clientId"in e)if(typeof e.clientId=="string"||e.clientId===null){if(e.clientId==="*")throw new h('Can\u2019t use "*" as a clientId as that string is reserved. (To change the default token request behaviour to use a wildcard clientId, use {defaultTokenParams: {clientId: "*"}})',40012,400)}else throw new h("clientId must be either a string or null",40012,400);i.logAction(this.logger,i.LOG_MINOR,"BaseClient()","started; version = "+R.version),this._currentFallback=null,this.serverTimeOffset=null,this.http=new fe(this),this.auth=new Q(this,e),this._rest=(a=t.plugins)!=null&&a.Rest?new t.plugins.Rest(this):null,this._Crypto=(l=(c=t.plugins)==null?void 0:c.Crypto)!=null?l:null,this.__FilteredSubscriptions=(g=(u=t.plugins)==null?void 0:u.MessageInteractions)!=null?g:null,this._Annotations=(m=(d=t.plugins)==null?void 0:d.Annotations)!=null?m:null}get rest(){return this._rest||_("Rest"),this._rest}get _FilteredSubscriptions(){return this.__FilteredSubscriptions||_("MessageInteractions"),this.__FilteredSubscriptions}get channels(){return this.rest.channels}get push(){return this.rest.push}device(){var t;return(!((t=this.options.plugins)!=null&&t.Push)||!this.push.LocalDevice)&&_("Push"),this._device||(this._device=this.push.LocalDevice.load(this)),this._device}baseUri(t){return R.getHttpScheme(this.options)+t+":"+R.getPort(this.options,!1)}async stats(t){return this.rest.stats(t)}async time(t){return this.rest.time(t)}async request(t,e,n,s,o,a){return this.rest.request(t,e,n,s,o,a)}batchPublish(t){return this.rest.batchPublish(t)}batchPresence(t){return this.rest.batchPresence(t)}setLog(t){this.logger.setLog(t.level,t.handler)}async getTimestamp(t){return!this.isTimeOffsetSet()&&t?this.time():this.getTimestampUsingOffset()}getTimestampUsingOffset(){return Date.now()+(this.serverTimeOffset||0)}isTimeOffsetSet(){return this.serverTimeOffset!==null}};It.Platform=p;var wt=It;var Rn=class r{toJSON(){var t,e,n;return{id:this.id,deviceSecret:this.deviceSecret,platform:this.platform,formFactor:this.formFactor,clientId:this.clientId,metadata:this.metadata,deviceIdentityToken:this.deviceIdentityToken,push:{recipient:(t=this.push)==null?void 0:t.recipient,state:(e=this.push)==null?void 0:e.state,error:(n=this.push)==null?void 0:n.error}}}toString(){var e,n,s,o;let t="[DeviceDetails";return this.id&&(t+="; id="+this.id),this.platform&&(t+="; platform="+this.platform),this.formFactor&&(t+="; formFactor="+this.formFactor),this.clientId&&(t+="; clientId="+this.clientId),this.metadata&&(t+="; metadata="+this.metadata),this.deviceIdentityToken&&(t+="; deviceIdentityToken="+JSON.stringify(this.deviceIdentityToken)),(e=this.push)!=null&&e.recipient&&(t+="; push.recipient="+JSON.stringify(this.push.recipient)),(n=this.push)!=null&&n.state&&(t+="; push.state="+this.push.state),(s=this.push)!=null&&s.error&&(t+="; push.error="+JSON.stringify(this.push.error)),(o=this.push)!=null&&o.metadata&&(t+="; push.metadata="+this.push.metadata),t+="]",t}static toRequestBody(t,e,n){return H(t,e,n)}static fromResponseBody(t,e,n){return n&&(t=B(t,e,n)),Array.isArray(t)?r.fromValuesArray(t):r.fromValues(t)}static fromValues(t){return t.error=t.error&&h.fromValues(t.error),Object.assign(new r,t)}static fromLocalDevice(t){return Object.assign(new r,t)}static fromValuesArray(t){let e=t.length,n=new Array(e);for(let s=0;s<e;s++)n[s]=r.fromValues(t[s]);return n}},me=Rn;async function Qr(r,t,e,n){if(r.http.supportsAuthHeaders){let s=await r.auth.getAuthHeaders();return n(C(s,t),e)}else{let s=await r.auth.getAuthParams();return n(t,C(s,e))}}function wo(r,t,e){if(r.err&&!r.body)return{err:r.err};if(r.statusCode===ge.NoContent)return D(E({},r),{body:[],unpacked:!0});let n=r.body;if(!r.unpacked)try{n=B(n,t,e)}catch(c){return Qe(c)?{err:c}:{err:new v(w(c),null)}}if(!n)return{err:new v("unenvelope(): Response body is missing",null)};let{statusCode:s,response:o,headers:a}=n;if(s===void 0)return D(E({},r),{body:n,unpacked:!0});if(s<200||s>=300){let c=o&&o.error||r.err;return c||(c=new Error("Error in unenveloping "+n),c.statusCode=s),{err:c,body:o,headers:a,unpacked:!0,statusCode:s}}return{err:r.err,body:o,headers:a,unpacked:!0,statusCode:s}}function Oo(r,t,e,n,s){r.err?i.logAction(s,i.LOG_MICRO,"Resource."+t+"()","Received Error; "+Ie(e,n)+"; Error: "+w(r.err)):i.logAction(s,i.LOG_MICRO,"Resource."+t+"()","Received; "+Ie(e,n)+"; Headers: "+Ct(r.headers)+"; StatusCode: "+r.statusCode+"; Body: "+(p.BufferUtils.isBuffer(r.body)?" (Base64): "+p.BufferUtils.base64Encode(r.body):": "+p.Config.inspect(r.body)))}var Pn=class r{static async get(t,e,n,s,o,a){return r.do(x.Get,t,e,null,n,s,o,a!=null?a:!1)}static async delete(t,e,n,s,o,a){return r.do(x.Delete,t,e,null,n,s,o,a)}static async post(t,e,n,s,o,a,c){return r.do(x.Post,t,e,n,s,o,a,c)}static async patch(t,e,n,s,o,a,c){return r.do(x.Patch,t,e,n,s,o,a,c)}static async put(t,e,n,s,o,a,c){return r.do(x.Put,t,e,n,s,o,a,c)}static async do(t,e,n,s,o,a,c,l){c&&((a=a||{}).envelope=c);let u=e.logger;async function g(m,f){var P;if(u.shouldLog(i.LOG_MICRO)){let A=s;if(((P=m["content-type"])==null?void 0:P.indexOf("msgpack"))>0)try{e._MsgPack||_("MsgPack"),A=e._MsgPack.decode(s)}catch(T){i.logAction(u,i.LOG_MICRO,"Resource."+t+"()","Sending MsgPack Decoding Error: "+w(T))}i.logAction(u,i.LOG_MICRO,"Resource."+t+"()","Sending; "+Ie(n,f)+"; Body: "+A)}let y=await e.http.do(t,n,m,s,f);return y.error&&Q.isTokenErr(y.error)?(await e.auth.authorize(null,null),Qr(e,m,f,g)):{err:y.error,body:y.body,headers:y.headers,unpacked:y.unpacked,statusCode:y.statusCode}}let d=await Qr(e,o,a,g);if(c&&(d=wo(d,e._MsgPack,c)),u.shouldLog(i.LOG_MICRO)&&Oo(d,t,n,a,u),l){if(d.err)throw d.err;{let m=E({},d);return delete m.err,m}}return d}},S=Pn;function ko(r){let t=r.match(/^\.\/(\w+)\?(.*)$/);return t&&t[2]&&Ae(t[2])}function Mo(r){typeof r=="string"&&(r=r.split(","));let t={};for(let e=0;e<r.length;e++){let n=r[e].match(/^\s*<(.+)>;\s*rel="(\w+)"$/);if(n){let s=ko(n[1]);s&&(t[n[2]]=s)}}return t}function Eo(r,t,e){return!(e&&(t||typeof r.code=="number"))}var bn=class{constructor(t,e,n,s,o,a){this.client=t,this.path=e,this.headers=n,this.envelope=s!=null?s:null,this.bodyHandler=o,this.useHttpPaginatedResponse=a||!1}get logger(){return this.client.logger}async get(t){let e=await S.get(this.client,this.path,this.headers,t,this.envelope,!1);return this.handlePage(e)}async delete(t){let e=await S.delete(this.client,this.path,this.headers,t,this.envelope,!1);return this.handlePage(e)}async post(t,e){let n=await S.post(this.client,this.path,e,this.headers,t,this.envelope,!1);return this.handlePage(n)}async put(t,e){let n=await S.put(this.client,this.path,e,this.headers,t,this.envelope,!1);return this.handlePage(n)}async patch(t,e){let n=await S.patch(this.client,this.path,e,this.headers,t,this.envelope,!1);return this.handlePage(n)}async handlePage(t){if(t.err&&Eo(t.err,t.body,this.useHttpPaginatedResponse))throw i.logAction(this.logger,i.LOG_ERROR,"PaginatedResource.handlePage()","Unexpected error getting resource: err = "+w(t.err)),t.err;let e,n,s;try{e=t.statusCode==ge.NoContent?[]:await this.bodyHandler(t.body,t.headers||{},t.unpacked)}catch(o){throw t.err||o}return t.headers&&(n=t.headers.Link||t.headers.link)&&(s=Mo(n)),this.useHttpPaginatedResponse?new Cn(this,e,t.headers||{},t.statusCode,s,t.err):new Ot(this,e,s)}},Ot=class{constructor(t,e,n){this.resource=t,this.items=e,this._relParams=n}async first(){if(this.hasFirst())return this.get(this._relParams.first);throw new h("No link to the first page of results",40400,404)}async current(){if(this.hasCurrent())return this.get(this._relParams.current);throw new h("No link to the current page of results",40400,404)}async next(){return this.hasNext()?this.get(this._relParams.next):null}hasFirst(){return this._relParams!=null&&"first"in this._relParams}hasCurrent(){return this._relParams!=null&&"current"in this._relParams}hasNext(){return this._relParams!=null&&"next"in this._relParams}isLast(){return!this.hasNext()}async get(t){let e=this.resource,n=await S.get(e.client,e.path,e.headers,t,e.envelope,!1);return e.handlePage(n)}},Cn=class extends Ot{constructor(e,n,s,o,a,c){super(e,n,a);this.statusCode=o,this.success=o<300&&o>=200,this.headers=s,this.errorCode=c&&c.code,this.errorMessage=c&&c.message}toJSON(){return{items:this.items,statusCode:this.statusCode,success:this.success,headers:this.headers,errorCode:this.errorCode,errorMessage:this.errorMessage}}},W=bn;var Oe=class Oe{toJSON(){return{channel:this.channel,deviceId:this.deviceId,clientId:this.clientId}}toString(){let t="[PushChannelSubscription";return this.channel&&(t+="; channel="+this.channel),this.deviceId&&(t+="; deviceId="+this.deviceId),this.clientId&&(t+="; clientId="+this.clientId),t+="]",t}static fromResponseBody(t,e,n){return n&&(t=B(t,e,n)),Array.isArray(t)?Oe.fromValuesArray(t):Oe.fromValues(t)}static fromValues(t){return Object.assign(new Oe,t)}static fromValuesArray(t){let e=t.length,n=new Array(e);for(let s=0;s<e;s++)n[s]=Oe.fromValues(t[s]);return n}};Oe.toRequestBody=H;var An=Oe,_e=An;var Tn=class{constructor(t){var e;this.client=t,this.admin=new In(t),p.Config.push&&((e=t.options.plugins)!=null&&e.Push)&&(this.stateMachine=new t.options.plugins.Push.ActivationStateMachine(t),this.LocalDevice=t.options.plugins.Push.localDeviceFactory(me))}async activate(t,e){await new Promise((n,s)=>{var o;if(!((o=this.client.options.plugins)!=null&&o.Push)){s(Ze("Push"));return}if(!this.stateMachine){s(new h("This platform is not supported as a target of push notifications",4e4,400));return}if(this.stateMachine.activatedCallback){s(new h("Activation already in progress",4e4,400));return}this.stateMachine.activatedCallback=a=>{if(a){s(a);return}n()},this.stateMachine.updateFailedCallback=e,this.stateMachine.handleEvent(new this.client.options.plugins.Push.CalledActivate(this.stateMachine,t))})}async deactivate(t){await new Promise((e,n)=>{var s;if(!((s=this.client.options.plugins)!=null&&s.Push)){n(Ze("Push"));return}if(!this.stateMachine){n(new h("This platform is not supported as a target of push notifications",4e4,400));return}if(this.stateMachine.deactivatedCallback){n(new h("Deactivation already in progress",4e4,400));return}this.stateMachine.deactivatedCallback=o=>{if(o){n(o);return}e()},this.stateMachine.handleEvent(new this.client.options.plugins.Push.CalledDeactivate(this.stateMachine,t))})}},In=class{constructor(t){this.client=t,this.deviceRegistrations=new wn(t),this.channelSubscriptions=new On(t)}async publish(t,e){let n=this.client,s=n.options.useBinaryProtocol?"msgpack":"json",o=R.defaultPostHeaders(n.options,{format:s}),a={},c=C({recipient:t},e);C(o,n.options.headers),n.options.pushFullWait&&C(a,{fullWait:"true"});let l=H(c,n._MsgPack,s);await S.post(n,"/push/publish",l,o,a,null,!0)}},wn=class{constructor(t){this.client=t}async save(t){let e=this.client,n=me.fromValues(t),s=e.options.useBinaryProtocol?"msgpack":"json",o=R.defaultPostHeaders(e.options,{format:s}),a={};C(o,e.options.headers),e.options.pushFullWait&&C(a,{fullWait:"true"});let c=H(n,e._MsgPack,s),l=await S.put(e,"/push/deviceRegistrations/"+encodeURIComponent(t.id),c,o,a,null,!0);return me.fromResponseBody(l.body,e._MsgPack,l.unpacked?void 0:s)}async get(t){let e=this.client,n=e.options.useBinaryProtocol?"msgpack":"json",s=R.defaultGetHeaders(e.options,{format:n}),o=t.id||t;if(typeof o!="string"||!o.length)throw new h("First argument to DeviceRegistrations#get must be a deviceId string or DeviceDetails",4e4,400);C(s,e.options.headers);let a=await S.get(e,"/push/deviceRegistrations/"+encodeURIComponent(o),s,{},null,!0);return me.fromResponseBody(a.body,e._MsgPack,a.unpacked?void 0:n)}async list(t){let e=this.client,n=e.options.useBinaryProtocol?"msgpack":"json",s=this.client.http.supportsLinkHeaders?void 0:n,o=R.defaultGetHeaders(e.options,{format:n});return C(o,e.options.headers),new W(e,"/push/deviceRegistrations",o,s,async function(a,c,l){return me.fromResponseBody(a,e._MsgPack,l?void 0:n)}).get(t)}async remove(t){let e=this.client,n=e.options.useBinaryProtocol?"msgpack":"json",s=R.defaultGetHeaders(e.options,{format:n}),o={},a=t.id||t;if(typeof a!="string"||!a.length)throw new h("First argument to DeviceRegistrations#remove must be a deviceId string or DeviceDetails",4e4,400);C(s,e.options.headers),e.options.pushFullWait&&C(o,{fullWait:"true"}),await S.delete(e,"/push/deviceRegistrations/"+encodeURIComponent(a),s,o,null,!0)}async removeWhere(t){let e=this.client,n=e.options.useBinaryProtocol?"msgpack":"json",s=R.defaultGetHeaders(e.options,{format:n});C(s,e.options.headers),e.options.pushFullWait&&C(t,{fullWait:"true"}),await S.delete(e,"/push/deviceRegistrations",s,t,null,!0)}},On=class r{constructor(t){this.remove=r.prototype.removeWhere;this.client=t}async save(t){let e=this.client,n=_e.fromValues(t),s=e.options.useBinaryProtocol?"msgpack":"json",o=R.defaultPostHeaders(e.options,{format:s}),a={};C(o,e.options.headers),e.options.pushFullWait&&C(a,{fullWait:"true"});let c=H(n,e._MsgPack,s),l=await S.post(e,"/push/channelSubscriptions",c,o,a,null,!0);return _e.fromResponseBody(l.body,e._MsgPack,l.unpacked?void 0:s)}async list(t){let e=this.client,n=e.options.useBinaryProtocol?"msgpack":"json",s=this.client.http.supportsLinkHeaders?void 0:n,o=R.defaultGetHeaders(e.options,{format:n});return C(o,e.options.headers),new W(e,"/push/channelSubscriptions",o,s,async function(a,c,l){return _e.fromResponseBody(a,e._MsgPack,l?void 0:n)}).get(t)}async removeWhere(t){let e=this.client,n=e.options.useBinaryProtocol?"msgpack":"json",s=R.defaultGetHeaders(e.options,{format:n});C(s,e.options.headers),e.options.pushFullWait&&C(t,{fullWait:"true"}),await S.delete(e,"/push/channelSubscriptions",s,t,null,!0)}async listChannels(t){let e=this.client,n=e.options.useBinaryProtocol?"msgpack":"json",s=this.client.http.supportsLinkHeaders?void 0:n,o=R.defaultGetHeaders(e.options,{format:n});return C(o,e.options.headers),e.options.pushFullWait&&C(t,{fullWait:"true"}),new W(e,"/push/channels",o,s,async function(a,c,l){let u=!l&&n?B(a,e._MsgPack,n):a;for(let g=0;g<u.length;g++)u[g]=String(u[g]);return u}).get(t)}},$r=Tn;var Xr=["absent","present","enter","leave","update"];async function kn(r,t,e,n){let s=Tt(t,r,n!=null?n:null);return he.fromValues(e).decode(s,r)}async function Yr(r,t,e,n){return Promise.all(e.map(function(s){return kn(r,t,s,n)}))}async function vo(r,t){return he.fromValues(r).decode(t.channelOptions,t.logger)}async function Mt(r,t){return Promise.all(r.map(function(e){return vo(e,t)}))}var kt=class r extends ee{isSynthesized(){return!this.id||!this.connectionId?!0:this.id.substring(this.connectionId.length,0)!==this.connectionId}parseId(){if(!this.id)throw new Error("parseId(): Presence message does not contain an id");let e=this.id.split(":");return{connectionId:e[0],msgSerial:parseInt(e[1],10),index:parseInt(e[2],10)}}async encode(e){let n=Object.assign(new he,this,{action:Xr.indexOf(this.action||"present")});return xe(n,e)}static fromValues(e){return Object.assign(new r,e)}static fromValuesArray(e){return e.map(n=>r.fromValues(n))}static fromData(e){return e instanceof r?e:r.fromValues({data:e})}toString(){return ue(this,"PresenceMessage")}},he=class r extends ee{toJSON(...e){return Be.call(this,...e)}static fromValues(e){return Object.assign(new r,e)}static fromValuesArray(e){return e.map(n=>r.fromValues(n))}async decode(e,n){let s=Object.assign(new kt,D(E({},this),{action:Xr[this.action]}));try{await Ue(s,e)}catch(o){i.logAction(n,i.LOG_ERROR,"WirePresenceMessage.decode()",w(o))}return s}toString(){return ue(this,"WirePresenceMessage")}},K=kt;var Mn=class{constructor(t){this.channel=t}get logger(){return this.channel.logger}async get(t){i.logAction(this.logger,i.LOG_MICRO,"RestPresence.get()","channel = "+this.channel.name);let e=this.channel.client,n=e.options.useBinaryProtocol?"msgpack":"json",s=this.channel.client.http.supportsLinkHeaders?void 0:n,o=R.defaultGetHeaders(e.options,{format:n});return C(o,e.options.headers),new W(e,this.channel.client.rest.presenceMixin.basePath(this),o,s,async(a,c,l)=>{let u=l?a:B(a,e._MsgPack,n);return Mt(u,this.channel)}).get(t)}async history(t){return i.logAction(this.logger,i.LOG_MICRO,"RestPresence.history()","channel = "+this.channel.name),this.channel.client.rest.presenceMixin.history(this,t)}},Zr=Mn;var es=["message.create","message.update","message.delete","meta","message.summary"];function So(r){return es[r||0]||"unknown"}function xo(r){let t=0;return r.name&&(t+=r.name.length),r.clientId&&(t+=r.clientId.length),r.extras&&(t+=JSON.stringify(r.extras).length),r.data&&(t+=tn(r.data)),t}async function En(r,t,e,n){let s=Tt(t,r,n!=null?n:null);return ye.fromValues(e).decode(s,r)}async function ts(r,t,e,n){return Promise.all(e.map(function(s){return En(r,t,s,n)}))}async function Uo(r,t){return ye.fromValues(r).decode(t.channelOptions,t.logger)}async function ns(r,t){return Promise.all(r.map(function(e){return Uo(e,t)}))}async function vt(r,t){return Promise.all(r.map(e=>e.encode(t)))}var rs=H;function Le(r){let t,e=0;for(let n=0;n<r.length;n++)t=r[n],e+=t.size||(t.size=xo(t));return e}var Et=class r extends ee{expandFields(){this.action==="message.create"&&(this.version&&!this.serial&&(this.serial=this.version),this.timestamp&&!this.createdAt&&(this.createdAt=this.timestamp))}async encode(e){let n=Object.assign(new ye,this,{action:es.indexOf(this.action||"message.create")});return xe(n,e)}static fromValues(e){return Object.assign(new r,e)}static fromValuesArray(e){return e.map(n=>r.fromValues(n))}toString(){return ue(this,"Message")}},ye=class r extends ee{toJSON(...e){return Be.call(this,...e)}static fromValues(e){return Object.assign(new r,e)}static fromValuesArray(e){return e.map(n=>r.fromValues(n))}async decodeWithErr(e,n){let s=Object.assign(new Et,D(E({},this),{action:So(this.action)})),o;try{await Ue(s,e)}catch(a){i.logAction(n,i.LOG_ERROR,"WireMessage.decode()",w(a)),o=a}return s.expandFields(),{decoded:s,err:o}}async decode(e,n){let{decoded:s}=await this.decodeWithErr(e,n);return s}toString(){return ue(this,"WireMessage")}},te=Et;var Bo=9;function _o(r){return r.every(function(t){return!t.id})}var vn=class{constructor(t,e,n){this._annotations=null;var s,o;i.logAction(t.logger,i.LOG_MINOR,"RestChannel()","started; name = "+e),this.name=e,this.client=t,this.presence=new Zr(this),this.channelOptions=ve((s=t._Crypto)!=null?s:null,this.logger,n),(o=t.options.plugins)!=null&&o.Push&&(this._push=new t.options.plugins.Push.PushChannel(this)),t._Annotations&&(this._annotations=new t._Annotations.RestAnnotations(this))}get annotations(){return this._annotations||_("Annotations"),this._annotations}get push(){return this._push||_("Push"),this._push}get logger(){return this.client.logger}setOptions(t){var e;this.channelOptions=ve((e=this.client._Crypto)!=null?e:null,this.logger,t)}async history(t){return i.logAction(this.logger,i.LOG_MICRO,"RestChannel.history()","channel = "+this.name),this.client.rest.channelMixin.history(this,t)}async publish(...t){let e=t[0],n=t[1],s,o;if(typeof e=="string"||e===null)s=[te.fromValues({name:e,data:n})],o=t[2];else if(ie(e))s=[te.fromValues(e)],o=t[1];else if(Array.isArray(e))s=te.fromValuesArray(e),o=t[1];else throw new h("The single-argument form of publish() expects a message object or an array of message objects",40013,400);o||(o={});let a=this.client,c=a.options,l=c.useBinaryProtocol?"msgpack":"json",u=a.options.idempotentRestPublishing,g=R.defaultPostHeaders(a.options,{format:l});if(C(g,c.headers),u&&_o(s)){let y=await nn(Bo);s.forEach(function(P,A){P.id=y+":"+A.toString()})}let d=await vt(s,this.channelOptions),m=Le(d),f=c.maxMessageSize;if(m>f)throw new h(`Maximum size of messages that can be published at once exceeded (was ${m} bytes; limit is ${f} bytes)`,40009,400);await this._publish(rs(d,a._MsgPack,l),g,o)}async _publish(t,e,n){await S.post(this.client,this.client.rest.channelMixin.basePath(this)+"/messages",t,e,n,null,!0)}async status(){return this.client.rest.channelMixin.status(this)}},ss=vn;var Sn=class r{constructor(t){this.entries=t&&t.entries||void 0,this.schema=t&&t.schema||void 0,this.appId=t&&t.appId||void 0,this.inProgress=t&&t.inProgress||void 0,this.unit=t&&t.unit||void 0,this.intervalId=t&&t.intervalId||void 0}static fromValues(t){return new r(t)}},os=Sn;var Ne=class{static basePath(t){return"/channels/"+encodeURIComponent(t.name)}static history(t,e){let n=t.client,s=n.options.useBinaryProtocol?"msgpack":"json",o=t.client.http.supportsLinkHeaders?void 0:s,a=R.defaultGetHeaders(n.options,{format:s});return C(a,n.options.headers),new W(n,this.basePath(t)+"/messages",a,o,async function(c,l,u){let g=u?c:B(c,n._MsgPack,s);return ns(g,t)}).get(e)}static async status(t){let e=t.client.options.useBinaryProtocol?"msgpack":"json",n=R.defaultPostHeaders(t.client.options,{format:e});return(await S.get(t.client,this.basePath(t),n,{},e,!0)).body}};var St=class{static basePath(t){return Ne.basePath(t.channel)+"/presence"}static async history(t,e){let n=t.channel.client,s=n.options.useBinaryProtocol?"msgpack":"json",o=t.channel.client.http.supportsLinkHeaders?void 0:s,a=R.defaultGetHeaders(n.options,{format:s});return C(a,n.options.headers),new W(n,this.basePath(t)+"/history",a,o,async(c,l,u)=>{let g=u?c:B(c,n._MsgPack,s);return Mt(g,t.channel)}).get(e)}};var qe=class{constructor(t){this.channelMixin=Ne;this.presenceMixin=St;this.Resource=S;this.PaginatedResource=W;this.DeviceDetails=me;this.PushChannelSubscription=_e;this.client=t,this.channels=new xn(this.client),this.push=new $r(this.client)}async stats(t){let e=R.defaultGetHeaders(this.client.options),n=this.client.options.useBinaryProtocol?"msgpack":"json",s=this.client.http.supportsLinkHeaders?void 0:n;return C(e,this.client.options.headers),new W(this.client,"/stats",e,s,function(o,a,c){let l=c?o:JSON.parse(o);for(let u=0;u<l.length;u++)l[u]=os.fromValues(l[u]);return l}).get(t)}async time(t){let e=R.defaultGetHeaders(this.client.options);this.client.options.headers&&C(e,this.client.options.headers);let n=l=>this.client.baseUri(l)+"/time",{error:s,body:o,unpacked:a}=await this.client.http.do(x.Get,n,e,null,t);if(s)throw s;a||(o=JSON.parse(o));let c=o[0];if(!c)throw new h("Internal error (unexpected result type from GET /time)",5e4,500);return this.client.serverTimeOffset=c-Date.now(),c}async request(t,e,n,s,o,a){var y;let[c,l,u]=(()=>this.client.options.useBinaryProtocol?(this.client._MsgPack||_("MsgPack"),[this.client._MsgPack.encode,this.client._MsgPack.decode,"msgpack"]):[JSON.stringify,JSON.parse,"json"])(),g=this.client.http.supportsLinkHeaders?void 0:u;s=s||{};let d=t.toLowerCase(),m=d=="get"?R.defaultGetHeaders(this.client.options,{format:u,protocolVersion:n}):R.defaultPostHeaders(this.client.options,{format:u,protocolVersion:n});typeof o!="string"&&(o=(y=c(o))!=null?y:null),C(m,this.client.options.headers),a&&C(m,a);let f=new W(this.client,e,m,g,async function(P,A,T){return Qt(T?P:l(P))},!0);if(!p.Http.methods.includes(d))throw new h("Unsupported method "+d,40500,405);return p.Http.methodsWithBody.includes(d)?f[d](s,o):f[d](s)}async batchPublish(t){let e,n;Array.isArray(t)?(e=t,n=!1):(e=[t],n=!0);let s=this.client.options.useBinaryProtocol?"msgpack":"json",o=R.defaultPostHeaders(this.client.options,{format:s});this.client.options.headers&&C(o,this.client.options.headers);let a=H(e,this.client._MsgPack,s),c=await S.post(this.client,"/messages",a,o,{},null,!0),l=c.unpacked?c.body:B(c.body,this.client._MsgPack,s);return n?l[0]:l}async batchPresence(t){let e=this.client.options.useBinaryProtocol?"msgpack":"json",n=R.defaultPostHeaders(this.client.options,{format:e});this.client.options.headers&&C(n,this.client.options.headers);let s=t.join(","),o=await S.get(this.client,"/presence",n,{channels:s},null,!0);return o.unpacked?o.body:B(o.body,this.client._MsgPack,e)}async revokeTokens(t,e){if(gn(this.client.options))throw new h("Cannot revoke tokens when using token auth",40162,401);let n=this.client.options.keyName,s=e!=null?e:{},o=E({targets:t.map(g=>`${g.type}:${g.value}`)},s),a=this.client.options.useBinaryProtocol?"msgpack":"json",c=R.defaultPostHeaders(this.client.options,{format:a});this.client.options.headers&&C(c,this.client.options.headers);let l=H(o,this.client._MsgPack,a),u=await S.post(this.client,`/keys/${n}/revokeTokens`,l,c,{},null,!0);return u.unpacked?u.body:B(u.body,this.client._MsgPack,a)}},xn=class{constructor(t){this.client=t,this.all=Object.create(null)}get(t,e){t=String(t);let n=this.all[t];return n?e&&n.setOptions(e):this.all[t]=n=new ss(this.client,t,e),n}release(t){delete this.all[String(t)]}};var xt=class extends wt{constructor(t){super(R.objectifyOptions(t,!1,"BaseRest",i.defaultLogger,{Rest:qe}))}};var Ut={Rest:qe};var De=class extends te{static async fromEncoded(t,e){return En(i.defaultLogger,p.Crypto,t,e)}static async fromEncodedArray(t,e){return ts(i.defaultLogger,p.Crypto,t,e)}static fromValues(t){return te.fromValues(t)}};var He=class extends K{static async fromEncoded(t,e){return kn(i.defaultLogger,p.Crypto,t,e)}static async fromEncodedArray(t,e){return Yr(i.defaultLogger,p.Crypto,t,e)}static fromValues(t){return K.fromValues(t)}};var is=["annotation.create","annotation.delete"];async function Un(r,t,e){return ne.fromValues(t).decode(e||{},r)}async function as(r,t,e){return Promise.all(t.map(function(n){return Un(r,n,e)}))}async function Lo(r,t){return ne.fromValues(r).decode(t.channelOptions,t.logger)}async function cs(r,t){return Promise.all(r.map(function(e){return Lo(e,t)}))}var Bt=class r extends ee{async encode(){let e=Object.assign(new ne,this,{action:is.indexOf(this.action||"annotation.create")});return xe(e,{})}static fromValues(e){return Object.assign(new r,e)}static fromValuesArray(e){return e.map(n=>r.fromValues(n))}toString(){return ue(this,"Annotation")}},ne=class r extends ee{toJSON(...e){return Be.call(this,...e)}static fromValues(e){return Object.assign(new r,e)}static fromValuesArray(e){return e.map(n=>r.fromValues(n))}async decode(e,n){let s=Object.assign(new Bt,D(E({},this),{action:is[this.action]}));try{await Ue(s,e)}catch(o){i.logAction(n,i.LOG_ERROR,"WireAnnotation.decode()",w(o))}return s}toString(){return ue(this,"WireAnnotation")}},re=Bt;var Fe=class extends re{static async fromEncoded(t,e){return Un(i.defaultLogger,t,e)}static async fromEncodedArray(t,e){return as(i.defaultLogger,t,e)}static fromValues(t){return re.fromValues(t)}};function us(r){let t;switch(typeof r){case"string":t=r;break;case"object":t=r.serial;break}if(!t||typeof t!="string")throw new h("First argument of annotations.publish() must be either a Message (or at least an object with a string `serial` property) or a message serial (string)",40003,400);return t}function _n(r,t){let e=us(r);if(!t||typeof t!="object")throw new h("Second argument of annotations.publish() must be an object (the intended annotation to publish)",40003,400);let n=re.fromValues(t);return n.messageSerial=e,n.action||(n.action="annotation.create"),n}function ls(r,t){return r.client.rest.channelMixin.basePath(r)+"/messages/"+encodeURIComponent(t)+"/annotations"}var Bn=class{constructor(t){this.channel=t}async publish(t,e){let n=_n(t,e),s=await n.encode(),o=this.channel.client,a=o.options,c=a.useBinaryProtocol?"msgpack":"json",l=R.defaultPostHeaders(o.options,{format:c}),u={};C(l,o.options.headers);let g=H([s],o._MsgPack,c);await S.post(o,ls(this.channel,n.messageSerial),g,l,u,null,!0)}async delete(t,e){return e.action="annotation.delete",this.publish(t,e)}async get(t,e){let n=this.channel.client,s=us(t),o=n.options.useBinaryProtocol?"msgpack":"json",a=n.http.supportsLinkHeaders?void 0:o,c=R.defaultGetHeaders(n.options,{format:o});return C(c,n.options.headers),new W(n,ls(this.channel,s),c,a,async(l,u,g)=>{let d=g?l:B(l,n._MsgPack,o);return cs(d,this.channel)}).get(e)}},Re=Bn;var hs=H;function _t(r){let t=[];if(r)for(let e=0;e<r.length;e++)t.push(r[e].toString());return"[ "+t.join(", ")+" ]"}function ds(r,t,e,n,s,o){let a=B(r,t,o);return Lt(a,e,n,s)}function Lt(r,t,e,n){let s;r.error&&(s=h.fromValues(r.error));let o;r.messages&&(o=ye.fromValuesArray(r.messages));let a;t&&r.presence&&(a=t.WirePresenceMessage.fromValuesArray(r.presence));let c;e&&r.annotations&&(c=e.WireAnnotation.fromValuesArray(r.annotations));let l;return n&&r.state&&(l=n.ObjectMessage.fromValuesArray(r.state,O,we)),Object.assign(new tt,D(E({},r),{presence:a,messages:o,annotations:c,state:l,error:s}))}function Ln(r){return t=>{var e;return Lt(t,{PresenceMessage:K,WirePresenceMessage:he},{Annotation:re,WireAnnotation:ne,RealtimeAnnotations:je,RestAnnotations:Re},(e=r==null?void 0:r.ObjectsPlugin)!=null?e:null)}}function F(r){return Object.assign(new tt,r)}function Ge(r,t,e,n){let s="[ProtocolMessage";r.action!==void 0&&(s+="; action="+yn[r.action]||r.action);let o=["id","channel","channelSerial","connectionId","count","msgSerial","timestamp"],a;for(let c=0;c<o.length;c++)a=o[c],r[a]!==void 0&&(s+="; "+a+"="+r[a]);if(r.messages&&(s+="; messages="+_t(ye.fromValuesArray(r.messages))),r.presence&&t&&(s+="; presence="+_t(t.WirePresenceMessage.fromValuesArray(r.presence))),r.annotations&&e&&(s+="; annotations="+_t(e.WireAnnotation.fromValuesArray(r.annotations))),r.state&&n&&(s+="; state="+_t(n.ObjectMessage.fromValuesArray(r.state,O,we))),r.error&&(s+="; error="+h.fromValues(r.error).toString()),r.auth&&r.auth.accessToken&&(s+="; token="+r.auth.accessToken),r.flags&&(s+="; flags="+Wr.filter(r.hasFlag).join(",")),r.params){let c="";Yt(r.params,function(l){c.length>0&&(c+="; "),c+=l+"="+r.params[l]}),c.length>0&&(s+="; params=["+c+"]")}return s+="]",s}var tt=class{constructor(){this.hasFlag=t=>(this.flags&j[t])>0}setFlag(t){return this.flags=this.flags|j[t]}getMode(){return(this.flags||0)&j.MODE_ALL}encodeModesToFlags(t){t.forEach(e=>this.setFlag(e))}decodeModesFromFlags(){let t=[];return At.forEach(e=>{this.hasFlag(e)&&t.push(e)}),t.length>0?t:void 0}},ps=tt;var Nn=class{constructor(t,e,n,s,o){this.previous=t,this.current=e,e==="attached"&&(this.resumed=n,this.hasBacklog=s),o&&(this.reason=o)}},nt=Nn;var gs=function(){};function No(r){if(r&&"params"in r&&!ie(r.params))return new h("options.params must be an object",4e4,400);if(r&&"modes"in r){if(!Array.isArray(r.modes))return new h("options.modes must be an array",4e4,400);for(let t=0;t<r.modes.length;t++){let e=r.modes[t];if(!e||typeof e!="string"||!At.includes(String.prototype.toUpperCase.call(e)))return new h("Invalid channel mode: "+e,4e4,400)}}}var qn=class r extends M{constructor(e,n,s){var o,a,c;super(e.logger);this._annotations=null;this._mode=0;this.retryCount=0;this.history=async function(e){i.logAction(this.logger,i.LOG_MICRO,"RealtimeChannel.history()","channel = "+this.name);let n=this.client.rest.channelMixin;if(e&&e.untilAttach){if(this.state!=="attached")throw new h("option untilAttach requires the channel to be attached",4e4,400);if(!this.properties.attachSerial)throw new h("untilAttach was specified and channel is attached, but attachSerial is not defined",4e4,400);delete e.untilAttach,e.from_serial=this.properties.attachSerial}return n.history(this,e)};this.whenState=e=>M.prototype.whenState.call(this,e,this.state);i.logAction(this.logger,i.LOG_MINOR,"RealtimeChannel()","started; name = "+n),this.name=n,this.channelOptions=ve((o=e._Crypto)!=null?o:null,this.logger,s),this.client=e,this._presence=e._RealtimePresence?new e._RealtimePresence.RealtimePresence(this):null,e._Annotations&&(this._annotations=new e._Annotations.RealtimeAnnotations(this)),this.connectionManager=e.connection.connectionManager,this.state="initialized",this.subscriptions=new M(this.logger),this.syncChannelSerial=void 0,this.properties={attachSerial:void 0,channelSerial:void 0},this.setOptions(s),this.errorReason=null,this._attachResume=!1,this._decodingContext={channelOptions:this.channelOptions,plugins:e.options.plugins||{},baseEncodedPreviousPayload:void 0},this._lastPayload={messageId:null,protocolMessageChannelSerial:null,decodeFailureRecoveryInProgress:null},this._allChannelChanges=new M(this.logger),(a=e.options.plugins)!=null&&a.Push&&(this._push=new e.options.plugins.Push.PushChannel(this)),(c=e.options.plugins)!=null&&c.Objects&&(this._objects=new e.options.plugins.Objects.Objects(this))}get presence(){return this._presence||_("RealtimePresence"),this._presence}get annotations(){return this._annotations||_("Annotations"),this._annotations}get push(){return this._push||_("Push"),this._push}get objects(){return this._objects||_("Objects"),this._objects}invalidStateError(){return new h("Channel operation failed as channel state is "+this.state,90001,400,this.errorReason||void 0)}static processListenerArgs(e){return e=Array.prototype.slice.call(e),typeof e[0]=="function"&&e.unshift(null),e}async setOptions(e){var o;let n=this.channelOptions,s=No(e);if(s)throw s;if(this.channelOptions=ve((o=this.client._Crypto)!=null?o:null,this.logger,e),this._decodingContext&&(this._decodingContext.channelOptions=this.channelOptions),this._shouldReattachToSetOptions(e,n))return this.attachImpl(),new Promise((a,c)=>{this._allChannelChanges.once(["attached","update","detached","failed"],function(l){switch(this.event){case"update":case"attached":a();break;default:c(l.reason)}})})}_shouldReattachToSetOptions(e,n){if(!(this.state==="attached"||this.state==="attaching"))return!1;if(e!=null&&e.params){let s=fs(e.params),o=fs(n.params);if(Object.keys(s).length!==Object.keys(o).length||!on(o,s))return!0}return!!(e!=null&&e.modes&&(!n.modes||!cn(e.modes,n.modes)))}async publish(...e){let n;if(e.length==1)if(ie(e[0]))n=[te.fromValues(e[0])];else if(Array.isArray(e[0]))n=te.fromValuesArray(e[0]);else throw new h("The single-argument form of publish() expects a message object or an array of message objects",40013,400);else n=[te.fromValues({name:e[0],data:e[1]})];let o=this.client.options.maxMessageSize,a=await vt(n,this.channelOptions),c=Le(a);if(c>o)throw new h(`Maximum size of messages that can be published at once exceeded (was ${c} bytes; limit is ${o} bytes)`,40009,400);this.throwIfUnpublishableState(),i.logAction(this.logger,i.LOG_MICRO,"RealtimeChannel.publish()","sending message; channel state is "+this.state+", message count = "+a.length);let l=F({action:b.MESSAGE,channel:this.name,messages:a});return this.sendMessage(l)}throwIfUnpublishableState(){if(!this.connectionManager.activeState())throw this.connectionManager.getError();if(this.state==="failed"||this.state==="suspended")throw this.invalidStateError()}onEvent(e){i.logAction(this.logger,i.LOG_MICRO,"RealtimeChannel.onEvent()","received message");let n=this.subscriptions;for(let s=0;s<e.length;s++){let o=e[s];n.emit(o.name,o)}}async attach(){return this.state==="attached"?null:new Promise((e,n)=>{this._attach(!1,null,(s,o)=>s?n(s):e(o))})}_attach(e,n,s){s||(s=a=>{a&&i.logAction(this.logger,i.LOG_ERROR,"RealtimeChannel._attach()","Channel attach failed: "+a.toString())});let o=this.connectionManager;if(!o.activeState()){s(o.getError());return}(this.state!=="attaching"||e)&&this.requestState("attaching",n),this.once(function(a){switch(this.event){case"attached":s==null||s(null,a);break;case"detached":case"suspended":case"failed":s==null||s(a.reason||o.getError()||new h("Unable to attach; reason unknown; state = "+this.event,9e4,500));break;case"detaching":s==null||s(new h("Attach request superseded by a subsequent detach request",9e4,409));break}})}attachImpl(){i.logAction(this.logger,i.LOG_MICRO,"RealtimeChannel.attachImpl()","sending ATTACH message");let e=F({action:b.ATTACH,channel:this.name,params:this.channelOptions.params,channelSerial:this.properties.channelSerial});this.channelOptions.modes&&e.encodeModesToFlags(sn(this.channelOptions.modes)),this._attachResume&&e.setFlag("ATTACH_RESUME"),this._lastPayload.decodeFailureRecoveryInProgress&&(e.channelSerial=this._lastPayload.protocolMessageChannelSerial),this.sendMessage(e).catch(gs)}async detach(){let e=this.connectionManager;if(!e.activeState())throw e.getError();switch(this.state){case"suspended":this.notifyState("detached");return;case"detached":return;case"failed":throw new h("Unable to detach; channel state = failed",90001,400);default:this.requestState("detaching");case"detaching":return new Promise((n,s)=>{this.once(function(o){switch(this.event){case"detached":n();break;case"attached":case"suspended":case"failed":s(o.reason||e.getError()||new h("Unable to detach; reason unknown; state = "+this.event,9e4,500));break;case"attaching":s(new h("Detach request superseded by a subsequent attach request",9e4,409));break}})})}}detachImpl(){i.logAction(this.logger,i.LOG_MICRO,"RealtimeChannel.detach()","sending DETACH message");let e=F({action:b.DETACH,channel:this.name});this.sendMessage(e).catch(gs)}async subscribe(...e){let[n,s]=r.processListenerArgs(e);if(this.state==="failed")throw h.fromValues(this.invalidStateError());return n&&typeof n=="object"&&!Array.isArray(n)?this.client._FilteredSubscriptions.subscribeFilter(this,n,s):this.subscriptions.on(n,s),this.channelOptions.attachOnSubscribe!==!1?this.attach():null}unsubscribe(...e){var o;let[n,s]=r.processListenerArgs(e);if(typeof n=="object"&&!s||(o=this.filteredSubscriptions)!=null&&o.has(s)){this.client._FilteredSubscriptions.getAndDeleteFilteredSubscriptions(this,n,s).forEach(a=>this.subscriptions.off(a));return}this.subscriptions.off(n,s)}sync(){switch(this.state){case"initialized":case"detaching":case"detached":throw new v("Unable to sync to channel; not attached",4e4);default:}let e=this.connectionManager;if(!e.activeState())throw e.getError();let n=F({action:b.SYNC,channel:this.name});this.syncChannelSerial&&(n.channelSerial=this.syncChannelSerial),e.send(n)}async sendMessage(e){return new Promise((n,s)=>{this.connectionManager.send(e,this.client.options.queueMessages,o=>{o?s(o):n()})})}async sendPresence(e){let n=F({action:b.PRESENCE,channel:this.name,presence:e});return this.sendMessage(n)}sendState(e){let n=F({action:b.OBJECT,channel:this.name,state:e});return this.sendMessage(n)}async processMessage(e){(e.action===b.ATTACHED||e.action===b.MESSAGE||e.action===b.PRESENCE||e.action===b.OBJECT||e.action===b.ANNOTATION)&&this.setChannelSerial(e.channelSerial);let n,s=!1;switch(e.action){case b.ATTACHED:{this.properties.attachSerial=e.channelSerial,this._mode=e.getMode(),this.params=e.params||{};let o=e.decodeModesFromFlags();this.modes=o&&$e(o)||void 0;let a=e.hasFlag("RESUMED"),c=e.hasFlag("HAS_PRESENCE"),l=e.hasFlag("HAS_BACKLOG"),u=e.hasFlag("HAS_OBJECTS");if(this.state==="attached"){a||(this._presence&&this._presence.onAttached(c),this._objects&&this._objects.onAttached(u));let g=new nt(this.state,this.state,a,l,e.error);this._allChannelChanges.emit("update",g),(!a||this.channelOptions.updateOnAttached)&&this.emit("update",g)}else this.state==="detaching"?this.checkPendingState():this.notifyState("attached",e.error,a,c,l,u);break}case b.DETACHED:{let o=e.error?h.fromValues(e.error):new h("Channel detached",90001,404);this.state==="detaching"?this.notifyState("detached",o):this.state==="attaching"?this.notifyState("suspended",o):(this.state==="attached"||this.state==="suspended")&&this.requestState("attaching",o);break}case b.SYNC:if(s=!0,n=this.syncChannelSerial=e.channelSerial,!e.presence)break;case b.PRESENCE:{if(!e.presence)break;et(e);let o=this.channelOptions;if(this._presence){let a=await Promise.all(e.presence.map(c=>c.decode(o,this.logger)));this._presence.setPresence(a,s,n)}break}case b.OBJECT:case b.OBJECT_SYNC:{if(!this._objects||!e.state)return;et(e);let o=e.state,a=this.client.connection.connectionManager.getActiveTransportFormat();await Promise.all(o.map(c=>this.client._objectsPlugin.ObjectMessage.decode(c,this.client,this.logger,i,O,a))),e.action===b.OBJECT?this._objects.handleObjectMessages(o):this._objects.handleObjectSyncMessages(o,e.channelSerial);break}case b.MESSAGE:{if(this.state!=="attached"){i.logAction(this.logger,i.LOG_MAJOR,"RealtimeChannel.processMessage()",'Message "'+e.id+'" skipped as this channel "'+this.name+'" state is not "attached" (state is "'+this.state+'").');return}et(e);let o=e.messages,a=o[0],c=o[o.length-1];if(a.extras&&a.extras.delta&&a.extras.delta.from!==this._lastPayload.messageId){let u='Delta message decode failure - previous message not available for message "'+e.id+'" on this channel "'+this.name+'".';i.logAction(this.logger,i.LOG_ERROR,"RealtimeChannel.processMessage()",u),this._startDecodeFailureRecovery(new h(u,40018,400));break}let l=[];for(let u=0;u<o.length;u++){let{decoded:g,err:d}=await o[u].decodeWithErr(this._decodingContext,this.logger);if(l[u]=g,d)switch(d.code){case 40018:this._startDecodeFailureRecovery(d);return;case 40019:case 40021:this.notifyState("failed",d);return;default:}}this._lastPayload.messageId=c.id,this._lastPayload.protocolMessageChannelSerial=e.channelSerial,this.onEvent(l);break}case b.ANNOTATION:{et(e);let o=this.channelOptions;if(this._annotations){let a=await Promise.all((e.annotations||[]).map(c=>c.decode(o,this.logger)));this._annotations._processIncoming(a)}break}case b.ERROR:{let o=e.error;o&&o.code==80016?this.checkPendingState():this.notifyState("failed",h.fromValues(o));break}default:i.logAction(this.logger,i.LOG_MAJOR,"RealtimeChannel.processMessage()","Protocol error: unrecognised message action ("+e.action+")")}}_startDecodeFailureRecovery(e){this._lastPayload.decodeFailureRecoveryInProgress||(i.logAction(this.logger,i.LOG_MAJOR,"RealtimeChannel.processMessage()","Starting decode failure recovery process."),this._lastPayload.decodeFailureRecoveryInProgress=!0,this._attach(!0,e,()=>{this._lastPayload.decodeFailureRecoveryInProgress=!1}))}onAttached(){i.logAction(this.logger,i.LOG_MINOR,"RealtimeChannel.onAttached","activating channel; name = "+this.name)}notifyState(e,n,s,o,a,c){if(i.logAction(this.logger,i.LOG_MICRO,"RealtimeChannel.notifyState","name = "+this.name+", current state = "+this.state+", notifying state "+e),this.clearStateTimer(),["detached","suspended","failed"].includes(e)&&(this.properties.channelSerial=null),e===this.state)return;this._presence&&this._presence.actOnChannelState(e,o,n),this._objects&&this._objects.actOnChannelState(e,c),e==="suspended"&&this.connectionManager.state.sendEvents?this.startRetryTimer():this.cancelRetryTimer(),n&&(this.errorReason=n);let l=new nt(this.state,e,s,a,n),u='Channel state for channel "'+this.name+'"',g=e+(n?"; reason: "+n:"");e==="failed"?i.logAction(this.logger,i.LOG_ERROR,u,g):i.logAction(this.logger,i.LOG_MAJOR,u,g),e!=="attaching"&&e!=="suspended"&&(this.retryCount=0),e==="attached"&&this.onAttached(),e==="attached"?this._attachResume=!0:(e==="detaching"||e==="failed")&&(this._attachResume=!1),this.state=e,this._allChannelChanges.emit(e,l),this.emit(e,l)}requestState(e,n){i.logAction(this.logger,i.LOG_MINOR,"RealtimeChannel.requestState","name = "+this.name+", state = "+e),this.notifyState(e,n),this.checkPendingState()}checkPendingState(){if(!this.connectionManager.state.sendEvents){i.logAction(this.logger,i.LOG_MINOR,"RealtimeChannel.checkPendingState","sendEvents is false; state is "+this.connectionManager.state.state);return}switch(i.logAction(this.logger,i.LOG_MINOR,"RealtimeChannel.checkPendingState","name = "+this.name+", state = "+this.state),this.state){case"attaching":this.startStateTimerIfNotRunning(),this.attachImpl();break;case"detaching":this.startStateTimerIfNotRunning(),this.detachImpl();break;case"attached":this.sync();break;default:break}}timeoutPendingState(){switch(this.state){case"attaching":{let e=new h("Channel attach timed out",90007,408);this.notifyState("suspended",e);break}case"detaching":{let e=new h("Channel detach timed out",90007,408);this.notifyState("attached",e);break}default:this.checkPendingState();break}}startStateTimerIfNotRunning(){this.stateTimer||(this.stateTimer=setTimeout(()=>{i.logAction(this.logger,i.LOG_MINOR,"RealtimeChannel.startStateTimerIfNotRunning","timer expired"),this.stateTimer=null,this.timeoutPendingState()},this.client.options.timeouts.realtimeRequestTimeout))}clearStateTimer(){let e=this.stateTimer;e&&(clearTimeout(e),this.stateTimer=null)}startRetryTimer(){if(this.retryTimer)return;this.retryCount++;let e=Xe(this.client.options.timeouts.channelRetryTimeout,this.retryCount);this.retryTimer=setTimeout(()=>{this.state==="suspended"&&this.connectionManager.state.sendEvents&&(this.retryTimer=null,i.logAction(this.logger,i.LOG_MINOR,"RealtimeChannel retry timer expired","attempting a new attach"),this.requestState("attaching"))},e)}cancelRetryTimer(){this.retryTimer&&(clearTimeout(this.retryTimer),this.retryTimer=null)}getReleaseErr(){let e=this.state;return e==="initialized"||e==="detached"||e==="failed"?null:new h("Can only release a channel in a state where there is no possibility of further updates from the server being received (initialized, detached, or failed); was "+e,90001,400)}setChannelSerial(e){i.logAction(this.logger,i.LOG_MICRO,"RealtimeChannel.setChannelSerial()","Updating channel serial; serial = "+e+"; previous = "+this.properties.channelSerial),e&&(this.properties.channelSerial=e)}async status(){return this.client.rest.channelMixin.status(this)}};function fs(r){let n=r||{},{agent:t}=n;return Cr(n,["agent"])}var Pe=qn;var Dn=class{constructor(t){this.channel=t,this.logger=t.logger,this.subscriptions=new M(this.logger)}async publish(t,e){let n=this.channel.name,s=_n(t,e),o=await s.encode();this.channel.throwIfUnpublishableState(),i.logAction(this.logger,i.LOG_MICRO,"RealtimeAnnotations.publish()","channelName = "+n+", sending annotation with messageSerial = "+s.messageSerial+", type = "+s.type);let a=F({action:b.ANNOTATION,channel:n,annotations:[o]});return this.channel.sendMessage(a)}async delete(t,e){return e.action="annotation.delete",this.publish(t,e)}async subscribe(...t){let e=Pe.processListenerArgs(t),n=e[0],s=e[1],o=this.channel;if(o.state==="failed")throw h.fromValues(o.invalidStateError());if(this.subscriptions.on(n,s),this.channel.channelOptions.attachOnSubscribe!==!1&&await o.attach(),(this.channel.state==="attached"&&this.channel._mode&j.ANNOTATION_SUBSCRIBE)===0)throw new h("You are trying to add an annotation listener, but you haven't requested the annotation_subscribe channel mode in ChannelOptions, so this won't do anything (we only deliver annotations to clients who have explicitly requested them)",93001,400)}unsubscribe(...t){let e=Pe.processListenerArgs(t),n=e[0],s=e[1];this.subscriptions.off(n,s)}_processIncoming(t){for(let e of t)this.subscriptions.emit(e.type||"",e)}async get(t,e){return Re.prototype.get.call(this,t,e)}},je=Dn;var se=class se extends xt{constructor(t){var n,s;if(!se._MsgPack)throw new Error("Expected DefaultRest._MsgPack to have been set");super(R.objectifyOptions(t,!0,"Rest",i.defaultLogger,D(E({},Ut),{Crypto:(n=se.Crypto)!=null?n:void 0,MsgPack:(s=se._MsgPack)!=null?s:void 0,Annotations:{Annotation:re,WireAnnotation:ne,RealtimeAnnotations:je,RestAnnotations:Re}})))}static get Crypto(){if(this._Crypto===null)throw new Error("Encryption not enabled; use ably.encryption.js instead");return this._Crypto}static set Crypto(t){this._Crypto=t}};se._Crypto=null,se.Message=De,se.PresenceMessage=He,se.Annotation=Fe,se._MsgPack=null,se._Http=fe;var We=se;var Hn=class extends M{constructor(e){super(e);this.messages=[]}count(){return this.messages.length}push(e){this.messages.push(e)}shift(){return this.messages.shift()}last(){return this.messages[this.messages.length-1]}copyAll(){return this.messages.slice()}append(e){this.messages.push.apply(this.messages,e)}prepend(e){this.messages.unshift.apply(this.messages,e)}completeMessages(e,n,s){i.logAction(this.logger,i.LOG_MICRO,"MessageQueue.completeMessages()","serial = "+e+"; count = "+n),s=s||null;let o=this.messages;if(o.length===0)throw new Error("MessageQueue.completeMessages(): completeMessages called on any empty MessageQueue");let a=o[0];if(a){let c=a.message.msgSerial,l=e+n;if(l>c){let u=o.splice(0,l-c);for(let g of u)g.callback(s)}o.length==0&&this.emit("idle")}}completeAllMessages(e){this.completeMessages(0,Number.MAX_SAFE_INTEGER||Number.MAX_VALUE,e)}resetSendAttempted(){for(let e of this.messages)e.sendAttempted=!1}clear(){i.logAction(this.logger,i.LOG_MICRO,"MessageQueue.clear()","clearing "+this.messages.length+" messages"),this.messages=[],this.emit("idle")}},Nt=Hn;var rt=class{constructor(t,e){this.message=t,this.callback=e,this.merged=!1;let n=t.action;this.sendAttempted=!1,this.ackRequired=typeof n=="number"&&[b.MESSAGE,b.PRESENCE,b.ANNOTATION,b.OBJECT].includes(n)}},Fn=class extends M{constructor(e){super(e.logger);this.transport=e,this.messageQueue=new Nt(this.logger),e.on("ack",(n,s)=>{this.onAck(n,s)}),e.on("nack",(n,s,o)=>{this.onNack(n,s,o)})}onAck(e,n){i.logAction(this.logger,i.LOG_MICRO,"Protocol.onAck()","serial = "+e+"; count = "+n),this.messageQueue.completeMessages(e,n)}onNack(e,n,s){i.logAction(this.logger,i.LOG_ERROR,"Protocol.onNack()","serial = "+e+"; count = "+n+"; err = "+w(s)),s||(s=new h("Unable to send message; channel not responding",50001,500)),this.messageQueue.completeMessages(e,n,s)}onceIdle(e){let n=this.messageQueue;if(n.count()===0){e();return}n.once("idle",e)}send(e){e.ackRequired&&this.messageQueue.push(e),this.logger.shouldLog(i.LOG_MICRO)&&i.logActionNoStrip(this.logger,i.LOG_MICRO,"Protocol.send()","sending msg; "+Ge(e.message,this.transport.connectionManager.realtime._RealtimePresence,this.transport.connectionManager.realtime._Annotations,this.transport.connectionManager.realtime._objectsPlugin)),e.sendAttempted=!0,this.transport.send(e.message)}getTransport(){return this.transport}getPendingMessages(){return this.messageQueue.copyAll()}clearPendingMessages(){return this.messageQueue.clear()}finish(){let e=this.transport;this.onceIdle(function(){e.disconnect()})}},ms=Fn;var Gn=class{constructor(t,e,n,s){this.previous=t,this.current=e,n&&(this.retryIn=n),s&&(this.reason=s)}},st=Gn;var be={DISCONNECTED:80003,SUSPENDED:80002,FAILED:8e4,CLOSING:80017,CLOSED:80017,UNKNOWN_CONNECTION_ERR:50002,UNKNOWN_CHANNEL_ERR:50001},qo={disconnected:()=>h.fromValues({statusCode:400,code:be.DISCONNECTED,message:"Connection to server temporarily unavailable"}),suspended:()=>h.fromValues({statusCode:400,code:be.SUSPENDED,message:"Connection to server unavailable"}),failed:()=>h.fromValues({statusCode:400,code:be.FAILED,message:"Connection failed or disconnected by server"}),closing:()=>h.fromValues({statusCode:400,code:be.CLOSING,message:"Connection closing"}),closed:()=>h.fromValues({statusCode:400,code:be.CLOSED,message:"Connection closed"}),unknownConnectionErr:()=>h.fromValues({statusCode:500,code:be.UNKNOWN_CONNECTION_ERR,message:"Internal connection error"}),unknownChannelErr:()=>h.fromValues({statusCode:500,code:be.UNKNOWN_CONNECTION_ERR,message:"Internal channel error"})};function ys(r){return!r.statusCode||!r.code||r.statusCode>=500?!0:Object.values(be).includes(r.code)}var ae=qo;var Do=F({action:b.CLOSE}),Ho=F({action:b.DISCONNECT}),jn=class extends M{constructor(e,n,s,o){super(e.logger);o&&(s.format=void 0,s.heartbeats=!0),this.connectionManager=e,this.auth=n,this.params=s,this.timeouts=s.options.timeouts,this.format=s.format,this.isConnected=!1,this.isFinished=!1,this.isDisposed=!1,this.maxIdleInterval=null,this.idleTimer=null,this.lastActivity=null}connect(){}close(){this.isConnected&&this.requestClose(),this.finish("closed",ae.closed())}disconnect(e){this.isConnected&&this.requestDisconnect(),this.finish("disconnected",e||ae.disconnected())}fail(e){this.isConnected&&this.requestDisconnect(),this.finish("failed",e||ae.failed())}finish(e,n){var s;this.isFinished||(this.isFinished=!0,this.isConnected=!1,this.maxIdleInterval=null,clearTimeout((s=this.idleTimer)!=null?s:void 0),this.idleTimer=null,this.emit(e,n),this.dispose())}onProtocolMessage(e){switch(this.logger.shouldLog(i.LOG_MICRO)&&i.logActionNoStrip(this.logger,i.LOG_MICRO,"Transport.onProtocolMessage()","received on "+this.shortName+": "+Ge(e,this.connectionManager.realtime._RealtimePresence,this.connectionManager.realtime._Annotations,this.connectionManager.realtime._objectsPlugin)+"; connectionId = "+this.connectionManager.connectionId),this.onActivity(),e.action){case b.HEARTBEAT:i.logActionNoStrip(this.logger,i.LOG_MICRO,"Transport.onProtocolMessage()",this.shortName+" heartbeat; connectionId = "+this.connectionManager.connectionId),this.emit("heartbeat",e.id);break;case b.CONNECTED:this.onConnect(e),this.emit("connected",e.error,e.connectionId,e.connectionDetails,e);break;case b.CLOSED:this.onClose(e);break;case b.DISCONNECTED:this.onDisconnect(e);break;case b.ACK:this.emit("ack",e.msgSerial,e.count);break;case b.NACK:this.emit("nack",e.msgSerial,e.count,e.error);break;case b.SYNC:this.connectionManager.onChannelMessage(e,this);break;case b.ACTIVATE:break;case b.AUTH:N(this.auth.authorize(),n=>{n&&i.logAction(this.logger,i.LOG_ERROR,"Transport.onProtocolMessage()","Ably requested re-authentication, but unable to obtain a new token: "+w(n))});break;case b.ERROR:if(i.logAction(this.logger,i.LOG_MINOR,"Transport.onProtocolMessage()","received error action; connectionId = "+this.connectionManager.connectionId+"; err = "+p.Config.inspect(e.error)+(e.channel?", channel: "+e.channel:"")),e.channel===void 0){this.onFatalError(e);break}this.connectionManager.onChannelMessage(e,this);break;default:this.connectionManager.onChannelMessage(e,this)}}onConnect(e){if(this.isConnected=!0,!e.connectionDetails)throw new Error("Transport.onConnect(): Connect message recieved without connectionDetails");let n=e.connectionDetails.maxIdleInterval;n&&(this.maxIdleInterval=n+this.timeouts.realtimeRequestTimeout,this.onActivity())}onDisconnect(e){let n=e&&e.error;i.logAction(this.logger,i.LOG_MINOR,"Transport.onDisconnect()","err = "+w(n)),this.finish("disconnected",n)}onFatalError(e){let n=e&&e.error;i.logAction(this.logger,i.LOG_MINOR,"Transport.onFatalError()","err = "+w(n)),this.finish("failed",n)}onClose(e){let n=e&&e.error;i.logAction(this.logger,i.LOG_MINOR,"Transport.onClose()","err = "+w(n)),this.finish("closed",n)}requestClose(){i.logAction(this.logger,i.LOG_MINOR,"Transport.requestClose()",""),this.send(Do)}requestDisconnect(){i.logAction(this.logger,i.LOG_MINOR,"Transport.requestDisconnect()",""),this.send(Ho)}ping(e){let n={action:b.HEARTBEAT};e&&(n.id=e),this.send(F(n))}dispose(){i.logAction(this.logger,i.LOG_MINOR,"Transport.dispose()",""),this.isDisposed=!0,this.off()}onActivity(){this.maxIdleInterval&&(this.lastActivity=this.connectionManager.lastActivity=Date.now(),this.setIdleTimer(this.maxIdleInterval+100))}setIdleTimer(e){this.idleTimer||(this.idleTimer=setTimeout(()=>{this.onIdleTimerExpire()},e))}onIdleTimerExpire(){if(!this.lastActivity||!this.maxIdleInterval)throw new Error("Transport.onIdleTimerExpire(): lastActivity/maxIdleInterval not set");this.idleTimer=null;let e=Date.now()-this.lastActivity,n=this.maxIdleInterval-e;if(n<=0){let s="No activity seen from realtime in "+e+"ms; assuming connection has dropped";i.logAction(this.logger,i.LOG_ERROR,"Transport.onIdleTimerExpire()",s),this.disconnect(new h(s,80003,408))}else this.setIdleTimer(n+100)}static tryConnect(e,n,s,o,a){let c=new e(n,s,o),l,u=function(d){clearTimeout(l),a({event:this.event,error:d})},g=n.options.timeouts.realtimeRequestTimeout;return l=setTimeout(()=>{c.off(["preconnect","disconnected","failed"]),c.dispose(),u.call({event:"disconnected"},new h("Timeout waiting for transport to indicate itself viable",5e4,500))},g),c.on(["failed","disconnected"],u),c.on("preconnect",function(){i.logAction(n.logger,i.LOG_MINOR,"Transport.tryConnect()","viable transport "+c),clearTimeout(l),c.off(["failed","disconnected"],u),a(null,c)}),c.connect(),c}static isAvailable(){throw new h("isAvailable not implemented for transport",5e4,500)}},de=jn;var q;(n=>(n.WebSocket="web_socket",n.Comet="comet",n.XhrPolling="xhr_polling"))(q||(q={}));var Fo=typeof global!="undefined"?global:typeof window!="undefined"?window:self,Wn=()=>{var r;return typeof p.WebStorage!="undefined"&&((r=p.WebStorage)==null?void 0:r.localSupported)},ot=()=>{var r;return typeof p.WebStorage!="undefined"&&((r=p.WebStorage)==null?void 0:r.sessionSupported)},Rs=function(){},Vn="ably-transport-preference";function Go(r,t,e){let n;if(r.channel!==t.channel||(n=r.action)!==b.PRESENCE&&n!==b.MESSAGE||n!==t.action)return!1;let s=n===b.PRESENCE?"presence":"messages",o=r[s].concat(t[s]);return Le(o)>e||!Zt(o,"clientId")||!o.every(function(c){return!c.id})?!1:(r[s]=o,!0)}function zn(r){try{return JSON.parse(r)}catch(t){return null}}var Jn=class{constructor(t,e,n,s){this.options=t,this.host=e,this.mode=n,this.connectionKey=s,this.format=t.useBinaryProtocol?"msgpack":"json"}getConnectParams(t){let e=t?oe(t):{},n=this.options;switch(this.mode){case"resume":e.resume=this.connectionKey;break;case"recover":{let s=zn(n.recover);s&&(e.recover=s.connectionKey);break}default:}return n.clientId!==void 0&&(e.clientId=n.clientId),n.echoMessages===!1&&(e.echo="false"),this.format!==void 0&&(e.format=this.format),this.stream!==void 0&&(e.stream=this.stream),this.heartbeats!==void 0&&(e.heartbeats=this.heartbeats),e.v=R.protocolVersion,e.agent=bt(this.options),n.transportParams!==void 0&&C(e,n.transportParams),e}toString(){let t="[mode="+this.mode;return this.host&&(t+=",host="+this.host),this.connectionKey&&(t+=",connectionKey="+this.connectionKey),this.format&&(t+=",format="+this.format),t+="]",t}},Kn=class r extends M{constructor(e,n){super(e.logger);this.supportedTransports={};this.disconnectedRetryCount=0;this.pendingChannelMessagesState={isProcessing:!1,queue:[]};this.realtime=e,this.initTransports(),this.options=n;let s=n.timeouts,o=s.webSocketConnectTimeout+s.realtimeRequestTimeout;if(this.states={initialized:{state:"initialized",terminal:!1,queueEvents:!0,sendEvents:!1,failState:"disconnected"},connecting:{state:"connecting",terminal:!1,queueEvents:!0,sendEvents:!1,retryDelay:o,failState:"disconnected"},connected:{state:"connected",terminal:!1,queueEvents:!1,sendEvents:!0,failState:"disconnected"},disconnected:{state:"disconnected",terminal:!1,queueEvents:!0,sendEvents:!1,retryDelay:s.disconnectedRetryTimeout,failState:"disconnected"},suspended:{state:"suspended",terminal:!1,queueEvents:!1,sendEvents:!1,retryDelay:s.suspendedRetryTimeout,failState:"suspended"},closing:{state:"closing",terminal:!1,queueEvents:!1,sendEvents:!1,retryDelay:s.realtimeRequestTimeout,failState:"closed"},closed:{state:"closed",terminal:!0,queueEvents:!1,sendEvents:!1,failState:"closed"},failed:{state:"failed",terminal:!0,queueEvents:!1,sendEvents:!1,failState:"failed"}},this.state=this.states.initialized,this.errorReason=null,this.queuedMessages=new Nt(this.logger),this.msgSerial=0,this.connectionDetails=void 0,this.connectionId=void 0,this.connectionKey=void 0,this.connectionStateTtl=s.connectionStateTtl,this.maxIdleInterval=null,this.transports=$t(n.transports||R.defaultTransports,this.supportedTransports),this.transportPreference=null,this.transports.includes(q.WebSocket)&&(this.webSocketTransportAvailable=!0),this.transports.includes(q.XhrPolling)?this.baseTransport=q.XhrPolling:this.transports.includes(q.Comet)&&(this.baseTransport=q.Comet),this.domains=R.getHosts(n),this.activeProtocol=null,this.host=null,this.lastAutoReconnectAttempt=null,this.lastActivity=null,this.forceFallbackHost=!1,this.connectCounter=0,this.wsCheckResult=null,this.webSocketSlowTimer=null,this.webSocketGiveUpTimer=null,this.abandonedWebSocket=!1,i.logAction(this.logger,i.LOG_MINOR,"Realtime.ConnectionManager()","started"),i.logAction(this.logger,i.LOG_MICRO,"Realtime.ConnectionManager()","requested transports = ["+(n.transports||R.defaultTransports)+"]"),i.logAction(this.logger,i.LOG_MICRO,"Realtime.ConnectionManager()","available transports = ["+this.transports+"]"),i.logAction(this.logger,i.LOG_MICRO,"Realtime.ConnectionManager()","http domains = ["+this.domains+"]"),!this.transports.length){let c="no requested transports available";throw i.logAction(this.logger,i.LOG_ERROR,"realtime.ConnectionManager()",c),new Error(c)}let a=p.Config.addEventListener;a&&(ot()&&typeof n.recover=="function"&&a("beforeunload",this.persistConnection.bind(this)),n.closeOnUnload===!0&&a("beforeunload",()=>{i.logAction(this.logger,i.LOG_MAJOR,"Realtime.ConnectionManager()","beforeunload event has triggered the connection to close as closeOnUnload is true"),this.requestState({state:"closing"})}),a("online",()=>{var c;this.state==this.states.disconnected||this.state==this.states.suspended?(i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager caught browser \u2018online\u2019 event","reattempting connection"),this.requestState({state:"connecting"})):this.state==this.states.connecting&&((c=this.pendingTransport)==null||c.off(),this.disconnectAllTransports(),this.startConnect())}),a("offline",()=>{this.state==this.states.connected&&(i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager caught browser \u2018offline\u2019 event","disconnecting active transport"),this.disconnectAllTransports())}))}static supportedTransports(e){let n={supportedTransports:{}};return this.initTransports(e,n),n.supportedTransports}static initTransports(e,n){let s=E(E({},p.Transports.bundledImplementations),e);[q.WebSocket,...p.Transports.order].forEach(o=>{let a=s[o];a&&a.isAvailable()&&(n.supportedTransports[o]=a)})}initTransports(){r.initTransports(this.realtime._additionalTransportImplementations,this)}createTransportParams(e,n){return new Jn(this.options,e,n,this.connectionKey)}getTransportParams(e){(s=>{if(this.connectionKey){s("resume");return}if(typeof this.options.recover=="string"){s("recover");return}let o=this.options.recover,a=this.getSessionRecoverData(),c=this.sessionRecoveryName();if(a&&typeof o=="function"){i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.getTransportParams()","Calling clientOptions-provided recover function with last session data (recovery scope: "+c+")"),o(a,l=>{l?(this.options.recover=a.recoveryKey,s("recover")):s("clean")});return}s("clean")})(s=>{let o=this.createTransportParams(null,s);if(s==="recover"){i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.getTransportParams()","Transport recovery mode = recover; recoveryKey = "+this.options.recover);let a=zn(this.options.recover);a&&(this.msgSerial=a.msgSerial)}else i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.getTransportParams()","Transport params = "+o.toString());e(o)})}tryATransport(e,n,s){i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.tryATransport()","trying "+n),this.proposedTransport=de.tryConnect(this.supportedTransports[n],this,this.realtime.auth,e,(o,a)=>{let c=this.state;if(c==this.states.closing||c==this.states.closed||c==this.states.failed){a&&(i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.tryATransport()","connection "+c.state+" while we were attempting the transport; closing "+a),a.close()),s(!0);return}if(o){i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.tryATransport()","transport "+n+" "+o.event+", err: "+o.error.toString()),Q.isTokenErr(o.error)&&!(this.errorReason&&Q.isTokenErr(this.errorReason))?(this.errorReason=o.error,N(this.realtime.auth._forceNewToken(null,null),l=>{if(l){this.actOnErrorFromAuthorize(l);return}this.tryATransport(e,n,s)})):o.event==="failed"?(this.notifyState({state:"failed",error:o.error}),s(!0)):o.event==="disconnected"&&(ys(o.error)?s(!1):(this.notifyState({state:this.states.connecting.failState,error:o.error}),s(!0)));return}i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.tryATransport()","viable transport "+n+"; setting pending"),this.setTransportPending(a,e),s(null,a)})}setTransportPending(e,n){let s=n.mode;i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.setTransportPending()","transport = "+e+"; mode = "+s),this.pendingTransport=e,this.cancelWebSocketSlowTimer(),this.cancelWebSocketGiveUpTimer(),e.once("connected",(a,c,l)=>{this.activateTransport(a,e,c,l),s==="recover"&&this.options.recover&&(delete this.options.recover,this.unpersistConnection())});let o=this;e.on(["disconnected","closed","failed"],function(a){o.deactivateTransport(e,this.event,a)}),this.emit("transport.pending",e)}activateTransport(e,n,s,o){i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.activateTransport()","transport = "+n),e&&i.logAction(this.logger,i.LOG_ERROR,"ConnectionManager.activateTransport()","error = "+e),s&&i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.activateTransport()","connectionId =  "+s),o&&i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.activateTransport()","connectionDetails =  "+JSON.stringify(o)),this.persistTransportPreference(n);let a=this.state,c=this.states.connected.state;if(i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.activateTransport()","current state = "+a.state),a.state==this.states.closing.state||a.state==this.states.closed.state||a.state==this.states.failed.state)return i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.activateTransport()","Disconnecting transport and abandoning"),n.disconnect(),!1;if(delete this.pendingTransport,!n.isConnected)return i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.activateTransport()","Declining to activate transport "+n+" since it appears to no longer be connected"),!1;let l=this.activeProtocol;this.activeProtocol=new ms(n),this.host=n.params.host;let u=o.connectionKey;if(u&&this.connectionKey!=u&&this.setConnection(s,o,!!e),this.onConnectionDetailsUpdate(o,n),p.Config.nextTick(()=>{n.on("connected",(g,d,m)=>{this.onConnectionDetailsUpdate(m,n),this.emit("update",new st(c,c,null,g))})}),a.state===this.states.connected.state?e&&(this.errorReason=this.realtime.connection.errorReason=e,this.emit("update",new st(c,c,null,e))):(this.notifyState({state:"connected",error:e}),this.errorReason=this.realtime.connection.errorReason=e||null),this.emit("transport.active",n),l)if(l.messageQueue.count()>0&&i.logAction(this.logger,i.LOG_ERROR,"ConnectionManager.activateTransport()","Previous active protocol (for transport "+l.transport.shortName+", new one is "+n.shortName+") finishing with "+l.messageQueue.count()+" messages still pending"),l.transport===n){let g="Assumption violated: activating a transport that was also the transport for the previous active protocol; transport = "+n.shortName+"; stack = "+new Error().stack;i.logAction(this.logger,i.LOG_ERROR,"ConnectionManager.activateTransport()",g)}else l.finish();return!0}deactivateTransport(e,n,s){let o=this.activeProtocol,a=o&&o.getTransport()===e,c=e===this.pendingTransport,l=this.noTransportsScheduledForActivation();if(i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.deactivateTransport()","transport = "+e),i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.deactivateTransport()","state = "+n+(a?"; was active":c?"; was pending":"")+(l?"":"; another transport is scheduled for activation")),s&&s.message&&i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.deactivateTransport()","reason =  "+s.message),a&&(i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.deactivateTransport()","Getting, clearing, and requeuing "+this.activeProtocol.messageQueue.count()+" pending messages"),this.queuePendingMessages(o.getPendingMessages()),o.clearPendingMessages(),this.activeProtocol=this.host=null),this.emit("transport.inactive",e),a&&l||a&&n==="failed"||n==="closed"||o===null&&c){if(n==="disconnected"&&s&&s.statusCode>500&&this.domains.length>1){this.unpersistTransportPreference(),this.forceFallbackHost=!0,this.notifyState({state:n,error:s,retryImmediately:!0});return}let u=n==="failed"&&Q.isTokenErr(s)?"disconnected":n;this.notifyState({state:u,error:s});return}}noTransportsScheduledForActivation(){return!this.pendingTransport||!this.pendingTransport.isConnected}setConnection(e,n,s){let o=this.connectionId;(o&&o!==e||!o&&s)&&(i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.setConnection()","Resetting msgSerial"),this.msgSerial=0,this.queuedMessages.resetSendAttempted()),this.connectionId!==e&&i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.setConnection()","New connectionId; reattaching any attached channels"),this.realtime.connection.id=this.connectionId=e,this.realtime.connection.key=this.connectionKey=n.connectionKey}clearConnection(){this.realtime.connection.id=this.connectionId=void 0,this.realtime.connection.key=this.connectionKey=void 0,this.msgSerial=0,this.unpersistConnection()}createRecoveryKey(){return this.connectionKey?JSON.stringify({connectionKey:this.connectionKey,msgSerial:this.msgSerial,channelSerials:this.realtime.channels.channelSerials()}):null}checkConnectionStateFreshness(){if(!this.lastActivity||!this.connectionId)return;let e=Date.now()-this.lastActivity;e>this.connectionStateTtl+this.maxIdleInterval&&(i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.checkConnectionStateFreshness()","Last known activity from realtime was "+e+"ms ago; discarding connection state"),this.clearConnection(),this.states.connecting.failState="suspended")}persistConnection(){if(ot()){let e=this.createRecoveryKey();e&&this.setSessionRecoverData({recoveryKey:e,disconnectedAt:Date.now(),location:Fo.location,clientId:this.realtime.auth.clientId})}}unpersistConnection(){this.clearSessionRecoverData()}getActiveTransportFormat(){var e;return(e=this.activeProtocol)==null?void 0:e.getTransport().format}getError(){if(this.errorReason){let e=v.fromValues(this.errorReason);return e.cause=this.errorReason,e}return this.getStateError()}getStateError(){var e,n;return(n=(e=ae)[this.state.state])==null?void 0:n.call(e)}activeState(){return this.state.queueEvents||this.state.sendEvents}enactStateChange(e){let n="Connection state",s=e.current+(e.reason?"; reason: "+e.reason:"");e.current==="failed"?i.logAction(this.logger,i.LOG_ERROR,n,s):i.logAction(this.logger,i.LOG_MAJOR,n,s),i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.enactStateChange","setting new state: "+e.current+"; reason = "+(e.reason&&e.reason.message));let o=this.state=this.states[e.current];e.reason&&(this.errorReason=e.reason,this.realtime.connection.errorReason=e.reason),(o.terminal||o.state==="suspended")&&this.clearConnection(),this.emit("connectionstate",e)}startTransitionTimer(e){i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.startTransitionTimer()","transitionState: "+e.state),this.transitionTimer&&(i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.startTransitionTimer()","clearing already-running timer"),clearTimeout(this.transitionTimer)),this.transitionTimer=setTimeout(()=>{this.transitionTimer&&(this.transitionTimer=null,i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager "+e.state+" timer expired","requesting new state: "+e.failState),this.notifyState({state:e.failState}))},e.retryDelay)}cancelTransitionTimer(){i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.cancelTransitionTimer()",""),this.transitionTimer&&(clearTimeout(this.transitionTimer),this.transitionTimer=null)}startSuspendTimer(){this.suspendTimer||(this.suspendTimer=setTimeout(()=>{this.suspendTimer&&(this.suspendTimer=null,i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager suspend timer expired","requesting new state: suspended"),this.states.connecting.failState="suspended",this.notifyState({state:"suspended"}))},this.connectionStateTtl))}checkSuspendTimer(e){e!=="disconnected"&&e!=="suspended"&&e!=="connecting"&&this.cancelSuspendTimer()}cancelSuspendTimer(){this.states.connecting.failState="disconnected",this.suspendTimer&&(clearTimeout(this.suspendTimer),this.suspendTimer=null)}startRetryTimer(e){this.retryTimer=setTimeout(()=>{i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager retry timer expired","retrying"),this.retryTimer=null,this.requestState({state:"connecting"})},e)}cancelRetryTimer(){this.retryTimer&&(clearTimeout(this.retryTimer),this.retryTimer=null)}startWebSocketSlowTimer(){this.webSocketSlowTimer=setTimeout(()=>{i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager WebSocket slow timer","checking connectivity"),this.checkWsConnectivity().then(()=>{i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager WebSocket slow timer","ws connectivity check succeeded"),this.wsCheckResult=!0}).catch(()=>{i.logAction(this.logger,i.LOG_MAJOR,"ConnectionManager WebSocket slow timer","ws connectivity check failed"),this.wsCheckResult=!1}),this.realtime.http.checkConnectivity&&N(this.realtime.http.checkConnectivity(),(e,n)=>{e||!n?(i.logAction(this.logger,i.LOG_MAJOR,"ConnectionManager WebSocket slow timer","http connectivity check failed"),this.cancelWebSocketGiveUpTimer(),this.notifyState({state:"disconnected",error:new h("Unable to connect (network unreachable)",80003,404)})):i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager WebSocket slow timer","http connectivity check succeeded")})},this.options.timeouts.webSocketSlowTimeout)}cancelWebSocketSlowTimer(){this.webSocketSlowTimer&&(clearTimeout(this.webSocketSlowTimer),this.webSocketSlowTimer=null)}startWebSocketGiveUpTimer(e){this.webSocketGiveUpTimer=setTimeout(()=>{var n,s;this.wsCheckResult||(i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager WebSocket give up timer","websocket connection took more than 10s; "+(this.baseTransport?"trying base transport":"")),this.baseTransport?(this.abandonedWebSocket=!0,(n=this.proposedTransport)==null||n.dispose(),(s=this.pendingTransport)==null||s.dispose(),this.connectBase(e,++this.connectCounter)):i.logAction(this.logger,i.LOG_MAJOR,"ConnectionManager WebSocket give up timer","websocket connectivity appears to be unavailable but no other transports to try"))},this.options.timeouts.webSocketConnectTimeout)}cancelWebSocketGiveUpTimer(){this.webSocketGiveUpTimer&&(clearTimeout(this.webSocketGiveUpTimer),this.webSocketGiveUpTimer=null)}notifyState(e){var l,u;let n=e.state,s=n==="disconnected"&&(this.state===this.states.connected||e.retryImmediately||this.state===this.states.connecting&&e.error&&Q.isTokenErr(e.error)&&!(this.errorReason&&Q.isTokenErr(this.errorReason)));if(i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.notifyState()","new state: "+n+(s?"; will retry connection immediately":"")),n==this.state.state||(this.cancelTransitionTimer(),this.cancelRetryTimer(),this.cancelWebSocketSlowTimer(),this.cancelWebSocketGiveUpTimer(),this.checkSuspendTimer(e.state),(n==="suspended"||n==="connected")&&(this.disconnectedRetryCount=0),this.state.terminal))return;let o=this.states[e.state],a=o.retryDelay;o.state==="disconnected"&&(this.disconnectedRetryCount++,a=Xe(o.retryDelay,this.disconnectedRetryCount));let c=new st(this.state.state,o.state,a,e.error||((u=(l=ae)[o.state])==null?void 0:u.call(l)));if(s){let g=()=>{this.state===this.states.disconnected&&(this.lastAutoReconnectAttempt=Date.now(),this.requestState({state:"connecting"}))},d=this.lastAutoReconnectAttempt&&Date.now()-this.lastAutoReconnectAttempt+1;d&&d<1e3?(i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.notifyState()","Last reconnect attempt was only "+d+"ms ago, waiting another "+(1e3-d)+"ms before trying again"),setTimeout(g,1e3-d)):p.Config.nextTick(g)}else(n==="disconnected"||n==="suspended")&&this.startRetryTimer(a);(n==="disconnected"&&!s||n==="suspended"||o.terminal)&&p.Config.nextTick(()=>{this.disconnectAllTransports()}),n=="connected"&&!this.activeProtocol&&i.logAction(this.logger,i.LOG_ERROR,"ConnectionManager.notifyState()","Broken invariant: attempted to go into connected state, but there is no active protocol"),this.enactStateChange(c),this.state.sendEvents?this.sendQueuedMessages():this.state.queueEvents||(this.realtime.channels.propogateConnectionInterruption(n,c.reason),this.failQueuedMessages(c.reason))}requestState(e){var a,c;let n=e.state;if(i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.requestState()","requested state: "+n+"; current state: "+this.state.state),n==this.state.state||(this.cancelWebSocketSlowTimer(),this.cancelWebSocketGiveUpTimer(),this.cancelTransitionTimer(),this.cancelRetryTimer(),this.checkSuspendTimer(n),n=="connecting"&&this.state.state=="connected")||n=="closing"&&this.state.state=="closed")return;let s=this.states[n],o=new st(this.state.state,s.state,null,e.error||((c=(a=ae)[s.state])==null?void 0:c.call(a)));this.enactStateChange(o),n=="connecting"&&p.Config.nextTick(()=>{this.startConnect()}),n=="closing"&&this.closeImpl()}startConnect(){if(this.state!==this.states.connecting){i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.startConnect()","Must be in connecting state to connect, but was "+this.state.state);return}let e=this.realtime.auth,n=++this.connectCounter,s=()=>{this.checkConnectionStateFreshness(),this.getTransportParams(o=>{if(o.mode==="recover"&&o.options.recover){let a=zn(o.options.recover);a&&this.realtime.channels.recoverChannels(a.channelSerials)}n===this.connectCounter&&this.connectImpl(o,n)})};if(i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.startConnect()","starting connection"),this.startSuspendTimer(),this.startTransitionTimer(this.states.connecting),e.method==="basic")s();else{let o=a=>{n===this.connectCounter&&(a?this.actOnErrorFromAuthorize(a):s())};this.errorReason&&Q.isTokenErr(this.errorReason)?N(e._forceNewToken(null,null),o):N(e._ensureValidAuthCredentials(!1),o)}}connectImpl(e,n){let s=this.state.state;if(s!==this.states.connecting.state){i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.connectImpl()","Must be in connecting state to connect, but was "+s);return}let o=this.getTransportPreference();o&&o===this.baseTransport&&this.webSocketTransportAvailable&&this.checkWsConnectivity().then(()=>{this.unpersistTransportPreference(),this.state===this.states.connecting&&(i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.connectImpl():","web socket connectivity available, cancelling connection attempt with "+this.baseTransport),this.disconnectAllTransports(),this.connectWs(e,++this.connectCounter))}).catch(Rs),o&&o===this.baseTransport||this.baseTransport&&!this.webSocketTransportAvailable?this.connectBase(e,n):this.connectWs(e,n)}connectWs(e,n){i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.connectWs()"),this.wsCheckResult=null,this.abandonedWebSocket=!1,this.startWebSocketSlowTimer(),this.startWebSocketGiveUpTimer(e),this.tryTransportWithFallbacks("web_socket",e,!0,n,()=>this.wsCheckResult!==!1&&!this.abandonedWebSocket)}connectBase(e,n){i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.connectBase()"),this.baseTransport?this.tryTransportWithFallbacks(this.baseTransport,e,!1,n,()=>!0):this.notifyState({state:"disconnected",error:new h("No transports left to try",8e4,404)})}tryTransportWithFallbacks(e,n,s,o,a){i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.tryTransportWithFallbacks()",e);let c=m=>{this.notifyState({state:this.states.connecting.failState,error:m})},l=this.domains.slice(),u=(m,f)=>{if(o===this.connectCounter){if(!a()){f&&f.dispose();return}!f&&!m&&d()}},g=l.shift();if(!g){c(new h("Unable to connect (no available host)",80003,404));return}n.host=g;let d=()=>{if(!l.length){c(new h("Unable to connect (and no more fallback hosts to try)",80003,404));return}if(!this.realtime.http.checkConnectivity){c(new v("Internal error: Http.checkConnectivity not set",null,500));return}N(this.realtime.http.checkConnectivity(),(m,f)=>{if(o===this.connectCounter&&a()){if(m){c(m);return}if(!f){c(new h("Unable to connect (network unreachable)",80003,404));return}n.host=Rt(l),this.tryATransport(n,e,u)}})};if(this.forceFallbackHost&&l.length){this.forceFallbackHost=!1,d();return}this.tryATransport(n,e,u)}closeImpl(){i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.closeImpl()","closing connection"),this.cancelSuspendTimer(),this.startTransitionTimer(this.states.closing),this.pendingTransport&&(i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.closeImpl()","Closing pending transport: "+this.pendingTransport),this.pendingTransport.close()),this.activeProtocol&&(i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.closeImpl()","Closing active transport: "+this.activeProtocol.getTransport()),this.activeProtocol.getTransport().close()),this.notifyState({state:"closed"})}onAuthUpdated(e,n){var s;switch(this.state.state){case"connected":{i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.onAuthUpdated()","Sending AUTH message on active transport");let o=(s=this.activeProtocol)==null?void 0:s.getTransport();o&&o.onAuthUpdated&&o.onAuthUpdated(e);let a=F({action:b.AUTH,auth:{accessToken:e.token}});this.send(a);let c=()=>{this.off(l),n(null,e)},l=u=>{u.current==="failed"&&(this.off(c),this.off(l),n(u.reason||this.getStateError()))};this.once("connectiondetails",c),this.on("connectionstate",l);break}case"connecting":i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.onAuthUpdated()","Aborting current connection attempts in order to start again with the new auth details"),this.disconnectAllTransports();default:{i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.onAuthUpdated()","Connection state is "+this.state.state+"; waiting until either connected or failed");let o=a=>{switch(a.current){case"connected":this.off(o),n(null,e);break;case"failed":case"closed":case"suspended":this.off(o),n(a.reason||this.getStateError());break;default:break}};this.on("connectionstate",o),this.state.state==="connecting"?this.startConnect():this.requestState({state:"connecting"})}}}disconnectAllTransports(){i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.disconnectAllTransports()","Disconnecting all transports"),this.connectCounter++,this.pendingTransport&&(i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.disconnectAllTransports()","Disconnecting pending transport: "+this.pendingTransport),this.pendingTransport.disconnect()),delete this.pendingTransport,this.proposedTransport&&(i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.disconnectAllTransports()","Disconnecting proposed transport: "+this.pendingTransport),this.proposedTransport.disconnect()),delete this.pendingTransport,this.activeProtocol&&(i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.disconnectAllTransports()","Disconnecting active transport: "+this.activeProtocol.getTransport()),this.activeProtocol.getTransport().disconnect())}send(e,n,s){s=s||Rs;let o=this.state;if(o.sendEvents){i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.send()","sending event"),this.sendImpl(new rt(e,s));return}if(!(n&&o.queueEvents)){let c="rejecting event, queueEvent was "+n+", state was "+o.state;i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.send()",c),s(this.errorReason||new h(c,9e4,400));return}this.logger.shouldLog(i.LOG_MICRO)&&i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.send()","queueing msg; "+Ge(e,this.realtime._RealtimePresence,this.realtime._Annotations,this.realtime._objectsPlugin)),this.queue(e,s)}sendImpl(e){let n=e.message;e.ackRequired&&!e.sendAttempted&&(n.msgSerial=this.msgSerial++);try{this.activeProtocol.send(e)}catch(s){i.logAction(this.logger,i.LOG_ERROR,"ConnectionManager.sendImpl()","Unexpected exception in transport.send(): "+s.stack)}}queue(e,n){i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.queue()","queueing event");let s=this.queuedMessages.last(),o=this.options.maxMessageSize;s&&!s.sendAttempted&&Go(s.message,e,o)?(s.merged||(s.callback=Se.create(this.logger,[s.callback]),s.merged=!0),s.callback.push(n)):this.queuedMessages.push(new rt(e,n))}sendQueuedMessages(){i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.sendQueuedMessages()","sending "+this.queuedMessages.count()+" queued messages");let e;for(;e=this.queuedMessages.shift();)this.sendImpl(e)}queuePendingMessages(e){e&&e.length&&(i.logAction(this.logger,i.LOG_MICRO,"ConnectionManager.queuePendingMessages()","queueing "+e.length+" pending messages"),this.queuedMessages.prepend(e))}failQueuedMessages(e){let n=this.queuedMessages.count();n>0&&(i.logAction(this.logger,i.LOG_ERROR,"ConnectionManager.failQueuedMessages()","failing "+n+" queued messages, err = "+w(e)),this.queuedMessages.completeAllMessages(e))}onChannelMessage(e,n){this.pendingChannelMessagesState.queue.push({message:e,transport:n}),this.pendingChannelMessagesState.isProcessing||this.processNextPendingChannelMessage()}processNextPendingChannelMessage(){if(this.pendingChannelMessagesState.queue.length>0){this.pendingChannelMessagesState.isProcessing=!0;let e=this.pendingChannelMessagesState.queue.shift();this.processChannelMessage(e.message).catch(n=>{i.logAction(this.logger,i.LOG_ERROR,"ConnectionManager.processNextPendingChannelMessage() received error ",n)}).finally(()=>{this.pendingChannelMessagesState.isProcessing=!1,this.processNextPendingChannelMessage()})}}async processChannelMessage(e){await this.realtime.channels.processChannelMessage(e)}async ping(){var o;if(this.state.state!=="connected")throw new h("Unable to ping service; not connected",4e4,400);let e=(o=this.activeProtocol)==null?void 0:o.getTransport();if(!e)throw this.getStateError();i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.ping()","transport = "+e);let n=Date.now(),s=Te();return ln(new Promise(a=>{let c=l=>{l===s&&(e.off("heartbeat",c),a(Date.now()-n))};e.on("heartbeat",c),e.ping(s)}),this.options.timeouts.realtimeRequestTimeout,"Timeout waiting for heartbeat response")}abort(e){this.activeProtocol.getTransport().fail(e)}getTransportPreference(){var e,n;return this.transportPreference||Wn()&&((n=(e=p.WebStorage)==null?void 0:e.get)==null?void 0:n.call(e,Vn))}persistTransportPreference(e){var n,s;this.transportPreference=e.shortName,Wn()&&((s=(n=p.WebStorage)==null?void 0:n.set)==null||s.call(n,Vn,e.shortName))}unpersistTransportPreference(){var e,n;this.transportPreference=null,Wn()&&((n=(e=p.WebStorage)==null?void 0:e.remove)==null||n.call(e,Vn))}actOnErrorFromAuthorize(e){if(e.code===40171)this.notifyState({state:"failed",error:e});else if(e.code===40102)this.notifyState({state:"failed",error:e});else if(e.statusCode===ge.Forbidden){let n="Client configured authentication provider returned 403; failing the connection";i.logAction(this.logger,i.LOG_ERROR,"ConnectionManager.actOnErrorFromAuthorize()",n),this.notifyState({state:"failed",error:new h(n,80019,403,e)})}else{let n="Client configured authentication provider request failed";i.logAction(this.logger,i.LOG_MINOR,"ConnectionManager.actOnErrorFromAuthorize",n),this.notifyState({state:this.state.failState,error:new h(n,80019,401,e)})}}onConnectionDetailsUpdate(e,n){if(!e)return;this.connectionDetails=e,e.maxMessageSize&&(this.options.maxMessageSize=e.maxMessageSize);let s=e.clientId;if(s){let a=this.realtime.auth._uncheckedSetClientId(s);if(a){i.logAction(this.logger,i.LOG_ERROR,"ConnectionManager.onConnectionDetailsUpdate()",a.message),n.fail(a);return}}let o=e.connectionStateTtl;o&&(this.connectionStateTtl=o),this.maxIdleInterval=e.maxIdleInterval,this.emit("connectiondetails",e)}checkWsConnectivity(){let e=this.options.wsConnectivityCheckUrl||R.wsConnectivityCheckUrl,n=new p.Config.WebSocket(e);return new Promise((s,o)=>{let a=!1;n.onopen=()=>{a||(a=!0,s(),n.close())},n.onclose=n.onerror=()=>{a||(a=!0,o())}})}sessionRecoveryName(){return this.options.recoveryKeyStorageName||"ably-connection-recovery"}getSessionRecoverData(){var e,n;return ot()&&((n=(e=p.WebStorage)==null?void 0:e.getSession)==null?void 0:n.call(e,this.sessionRecoveryName()))}setSessionRecoverData(e){var n,s;return ot()&&((s=(n=p.WebStorage)==null?void 0:n.setSession)==null?void 0:s.call(n,this.sessionRecoveryName(),e))}clearSessionRecoverData(){var e,n;return ot()&&((n=(e=p.WebStorage)==null?void 0:e.removeSession)==null?void 0:n.call(e,this.sessionRecoveryName()))}},qt=Kn;var Qn=class extends M{constructor(e,n){super(e.logger);this.whenState=e=>M.prototype.whenState.call(this,e,this.state);this.ably=e,this.connectionManager=new qt(e,n),this.state=this.connectionManager.state.state,this.key=void 0,this.id=void 0,this.errorReason=null,this.connectionManager.on("connectionstate",s=>{let o=this.state=s.current;p.Config.nextTick(()=>{this.emit(o,s)})}),this.connectionManager.on("update",s=>{p.Config.nextTick(()=>{this.emit("update",s)})})}connect(){i.logAction(this.logger,i.LOG_MINOR,"Connection.connect()",""),this.connectionManager.requestState({state:"connecting"})}async ping(){return i.logAction(this.logger,i.LOG_MINOR,"Connection.ping()",""),this.connectionManager.ping()}close(){i.logAction(this.logger,i.LOG_MINOR,"Connection.close()","connectionKey = "+this.key),this.connectionManager.requestState({state:"closing"})}get recoveryKey(){return this.logger.deprecationWarning("The `Connection.recoveryKey` attribute has been replaced by the `Connection.createRecoveryKey()` method. Replace your usage of `recoveryKey` with the return value of `createRecoveryKey()`. `recoveryKey` will be removed in a future version."),this.createRecoveryKey()}createRecoveryKey(){return this.connectionManager.createRecoveryKey()}},Ps=Qn;var Dt=class Dt extends wt{constructor(e){var n,s,o,a;super(R.objectifyOptions(e,!1,"BaseRealtime",i.defaultLogger));if(i.logAction(this.logger,i.LOG_MINOR,"Realtime()",""),typeof EdgeRuntime=="string")throw new h(`Ably.Realtime instance cannot be used in Vercel Edge runtime. If you are running Vercel Edge functions, please replace your "new Ably.Realtime()" with "new Ably.Rest()" and use Ably Rest API instead of the Realtime API. If you are server-rendering your application in the Vercel Edge runtime, please use the condition "if (typeof EdgeRuntime === 'string')" to prevent instantiating Ably.Realtime instance during SSR in the Vercel Edge runtime.`,4e4,400);this._additionalTransportImplementations=Dt.transportImplementationsFromPlugins(this.options.plugins),this._RealtimePresence=(s=(n=this.options.plugins)==null?void 0:n.RealtimePresence)!=null?s:null,this._objectsPlugin=(a=(o=this.options.plugins)==null?void 0:o.Objects)!=null?a:null,this.connection=new Ps(this,this.options),this._channels=new Xn(this),this.options.autoConnect!==!1&&this.connect()}static transportImplementationsFromPlugins(e){let n={};return e!=null&&e.WebSocketTransport&&(n[q.WebSocket]=e.WebSocketTransport),e!=null&&e.XHRPolling&&(n[q.XhrPolling]=e.XHRPolling),n}get channels(){return this._channels}connect(){i.logAction(this.logger,i.LOG_MINOR,"Realtime.connect()",""),this.connection.connect()}close(){i.logAction(this.logger,i.LOG_MINOR,"Realtime.close()",""),this.connection.close()}};Dt.EventEmitter=M;var $n=Dt,Xn=class extends M{constructor(e){super(e.logger);this.realtime=e,this.all=Object.create(null),e.connection.connectionManager.on("transport.active",()=>{this.onTransportActive()})}channelSerials(){let e={};for(let n of pe(this.all,!0)){let s=this.all[n];s.properties.channelSerial&&(e[n]=s.properties.channelSerial)}return e}recoverChannels(e){for(let n of pe(e,!0)){let s=this.get(n);s.properties.channelSerial=e[n]}}async processChannelMessage(e){let n=e.channel;if(n===void 0){i.logAction(this.logger,i.LOG_ERROR,"Channels.processChannelMessage()","received event unspecified channel, action = "+e.action);return}let s=this.all[n];if(!s){i.logAction(this.logger,i.LOG_ERROR,"Channels.processChannelMessage()","received event for non-existent channel: "+n);return}await s.processMessage(e)}onTransportActive(){for(let e in this.all){let n=this.all[e];n.state==="attaching"||n.state==="detaching"?n.checkPendingState():n.state==="suspended"?n._attach(!1,null):n.state==="attached"&&n.requestState("attaching")}}propogateConnectionInterruption(e,n){let s={closing:"detached",closed:"detached",failed:"failed",suspended:"suspended"},o=["attaching","attached","detaching","suspended"],a=s[e];for(let c in this.all){let l=this.all[c];o.includes(l.state)&&l.notifyState(a,n)}}get(e,n){e=String(e);let s=this.all[e];if(!s)s=this.all[e]=new Pe(this.realtime,e,n);else if(n){if(s._shouldReattachToSetOptions(n,s.channelOptions))throw new h("Channels.get() cannot be used to set channel options that would cause the channel to reattach. Please, use RealtimeChannel.setOptions() instead.",4e4,400);s.setOptions(n)}return s}getDerived(e,n,s){if(n.filter){let o=Ee(n.filter),a=an(e);e=`[filter=${o}${a.qualifierParam}]${a.channelName}`}return this.get(e,s)}release(e){e=String(e);let n=this.all[e];if(!n)return;let s=n.getReleaseErr();if(s)throw s;delete this.all[e]}},bs=$n;function jo(r,t){if(r.isSynthesized()||t.isSynthesized())return r.timestamp>=t.timestamp;let e=r.parseId(),n=t.parseId();return e.msgSerial===n.msgSerial?e.index>n.index:e.msgSerial>n.msgSerial}var ke=class extends M{constructor(e,n,s=jo){super(e.logger);this.presence=e,this.map=Object.create(null),this.syncInProgress=!1,this.residualMembers=null,this.memberKey=n,this.newerThan=s}get(e){return this.map[e]}getClient(e){let n=this.map,s=[];for(let o in n){let a=n[o];a.clientId==e&&a.action!="absent"&&s.push(a)}return s}list(e){let n=this.map,s=e&&e.clientId,o=e&&e.connectionId,a=[];for(let c in n){let l=n[c];l.action!=="absent"&&(s&&s!=l.clientId||o&&o!=l.connectionId||a.push(l))}return a}put(e){(e.action==="enter"||e.action==="update")&&(e=K.fromValues(e),e.action="present");let n=this.map,s=this.memberKey(e);this.residualMembers&&delete this.residualMembers[s];let o=n[s];return o&&!this.newerThan(e,o)?!1:(n[s]=e,!0)}values(){let e=this.map,n=[];for(let s in e){let o=e[s];o.action!="absent"&&n.push(o)}return n}remove(e){let n=this.map,s=this.memberKey(e),o=n[s];return o&&!this.newerThan(e,o)?!1:(this.syncInProgress?(e=K.fromValues(e),e.action="absent",n[s]=e):delete n[s],!!o)}startSync(){let e=this.map,n=this.syncInProgress;i.logAction(this.logger,i.LOG_MINOR,"PresenceMap.startSync()","channel = "+this.presence.channel.name+"; syncInProgress = "+n),this.syncInProgress||(this.residualMembers=oe(e),this.setInProgress(!0))}endSync(){let e=this.map,n=this.syncInProgress;if(i.logAction(this.logger,i.LOG_MINOR,"PresenceMap.endSync()","channel = "+this.presence.channel.name+"; syncInProgress = "+n),n){for(let s in e)e[s].action==="absent"&&delete e[s];this.presence._synthesizeLeaves(Xt(this.residualMembers));for(let s in this.residualMembers)delete e[s];this.residualMembers=null,this.setInProgress(!1)}this.emit("sync")}waitSync(e){let n=this.syncInProgress;if(i.logAction(this.logger,i.LOG_MINOR,"PresenceMap.waitSync()","channel = "+this.presence.channel.name+"; syncInProgress = "+n),!n){e();return}this.once("sync",e)}clear(){this.map={},this.setInProgress(!1),this.residualMembers=null}setInProgress(e){i.logAction(this.logger,i.LOG_MICRO,"PresenceMap.setInProgress()","inProgress = "+e),this.syncInProgress=e,this.presence.syncComplete=!e}};function Wo(r){return r.channel.client.auth.clientId}function Yn(r){let t=r.channel.client,e=t.auth.clientId;return(!e||e==="*")&&t.connection.state==="connected"}function Vo(r,t,e){switch(r.state){case"attached":case"suspended":e();break;case"initialized":case"detached":case"detaching":case"attaching":N(r.attach(),function(n){n?t(n):e()});break;default:t(h.fromValues(r.invalidStateError()))}}var Zn=class extends M{constructor(e){super(e.logger);this.channel=e,this.syncComplete=!1,this.members=new ke(this,n=>n.clientId+":"+n.connectionId),this._myMembers=new ke(this,n=>n.clientId),this.subscriptions=new M(this.logger),this.pendingPresence=[]}async enter(e){if(Yn(this))throw new h("clientId must be specified to enter a presence channel",40012,400);return this._enterOrUpdateClient(void 0,void 0,e,"enter")}async update(e){if(Yn(this))throw new h("clientId must be specified to update presence data",40012,400);return this._enterOrUpdateClient(void 0,void 0,e,"update")}async enterClient(e,n){return this._enterOrUpdateClient(void 0,e,n,"enter")}async updateClient(e,n){return this._enterOrUpdateClient(void 0,e,n,"update")}async _enterOrUpdateClient(e,n,s,o){let a=this.channel;if(!a.connectionManager.activeState())throw a.connectionManager.getError();i.logAction(this.logger,i.LOG_MICRO,"RealtimePresence."+o+"Client()","channel = "+a.name+", id = "+e+", client = "+(n||"(implicit) "+Wo(this)));let c=K.fromData(s);c.action=o,e&&(c.id=e),n&&(c.clientId=n);let l=await c.encode(a.channelOptions);switch(a.state){case"attached":return a.sendPresence([l]);case"initialized":case"detached":a.attach();case"attaching":return new Promise((u,g)=>{this.pendingPresence.push({presence:l,callback:d=>d?g(d):u()})});default:{let u=new v("Unable to "+o+" presence channel while in "+a.state+" state",90001);throw u.code=90001,u}}}async leave(e){if(Yn(this))throw new h("clientId must have been specified to enter or leave a presence channel",40012,400);return this.leaveClient(void 0,e)}async leaveClient(e,n){let s=this.channel;if(!s.connectionManager.activeState())throw s.connectionManager.getError();i.logAction(this.logger,i.LOG_MICRO,"RealtimePresence.leaveClient()","leaving; channel = "+this.channel.name+", client = "+e);let o=K.fromData(n);o.action="leave",e&&(o.clientId=e);let a=await o.encode(s.channelOptions);switch(s.state){case"attached":return s.sendPresence([a]);case"attaching":return new Promise((c,l)=>{this.pendingPresence.push({presence:a,callback:u=>u?l(u):c()})});case"initialized":case"failed":throw new v("Unable to leave presence channel (incompatible state)",90001);default:throw s.invalidStateError()}}async get(e){let n=!e||("waitForSync"in e?e.waitForSync:!0);return new Promise((s,o)=>{function a(c){s(e?c.list(e):c.values())}if(this.channel.state==="suspended"){n?o(h.fromValues({statusCode:400,code:91005,message:"Presence state is out of sync due to channel being in the SUSPENDED state"})):a(this.members);return}Vo(this.channel,c=>o(c),()=>{let c=this.members;n?c.waitSync(function(){a(c)}):a(c)})})}async history(e){i.logAction(this.logger,i.LOG_MICRO,"RealtimePresence.history()","channel = "+this.name);let n=this.channel.client.rest.presenceMixin;if(e&&e.untilAttach)if(this.channel.state==="attached")delete e.untilAttach,e.from_serial=this.channel.properties.attachSerial;else throw new h("option untilAttach requires the channel to be attached, was: "+this.channel.state,4e4,400);return n.history(this,e)}setPresence(e,n,s){i.logAction(this.logger,i.LOG_MICRO,"RealtimePresence.setPresence()","received presence for "+e.length+" participants; syncChannelSerial = "+s);let o,a,c=this.members,l=this._myMembers,u=[],g=this.channel.connectionManager.connectionId;n&&(this.members.startSync(),s&&(a=s.match(/^[\w-]+:(.*)$/))&&(o=a[1]));for(let d of e)switch(d.action){case"leave":c.remove(d)&&u.push(d),d.connectionId===g&&!d.isSynthesized()&&l.remove(d);break;case"enter":case"present":case"update":c.put(d)&&u.push(d),d.connectionId===g&&l.put(d);break}n&&!o&&(c.endSync(),this.channel.syncChannelSerial=null);for(let d=0;d<u.length;d++){let m=u[d];this.subscriptions.emit(m.action,m)}}onAttached(e){i.logAction(this.logger,i.LOG_MINOR,"RealtimePresence.onAttached()","channel = "+this.channel.name+", hasPresence = "+e),e?this.members.startSync():(this._synthesizeLeaves(this.members.values()),this.members.clear()),this._ensureMyMembersPresent();let n=this.pendingPresence,s=n.length;if(s){this.pendingPresence=[];let o=[],a=Se.create(this.logger);i.logAction(this.logger,i.LOG_MICRO,"RealtimePresence.onAttached","sending "+s+" queued presence messages");for(let c=0;c<s;c++){let l=n[c];o.push(l.presence),a.push(l.callback)}this.channel.sendPresence(o).then(()=>a()).catch(c=>a(c))}}actOnChannelState(e,n,s){switch(e){case"attached":this.onAttached(n);break;case"detached":case"failed":this._clearMyMembers(),this.members.clear();case"suspended":this.failPendingPresence(s);break}}failPendingPresence(e){if(this.pendingPresence.length){i.logAction(this.logger,i.LOG_MINOR,"RealtimeChannel.failPendingPresence","channel; name = "+this.channel.name+", err = "+w(e));for(let n=0;n<this.pendingPresence.length;n++)try{this.pendingPresence[n].callback(e)}catch(s){}this.pendingPresence=[]}}_clearMyMembers(){this._myMembers.clear()}_ensureMyMembersPresent(){let e=this._myMembers,n=this.channel.connectionManager.connectionId;for(let s in e.map){let o=e.map[s];i.logAction(this.logger,i.LOG_MICRO,"RealtimePresence._ensureMyMembersPresent()",'Auto-reentering clientId "'+o.clientId+'" into the presence set');let a=o.connectionId===n?o.id:void 0;this._enterOrUpdateClient(a,o.clientId,o.data,"enter").catch(c=>{let l=new h("Presence auto re-enter failed",91004,400,c);i.logAction(this.logger,i.LOG_ERROR,"RealtimePresence._ensureMyMembersPresent()","Presence auto re-enter failed; reason = "+w(c));let u=new nt(this.channel.state,this.channel.state,!0,!1,l);this.channel.emit("update",u)})}}_synthesizeLeaves(e){let n=this.subscriptions;e.forEach(function(s){let o=K.fromValues({action:"leave",connectionId:s.connectionId,clientId:s.clientId,data:s.data,encoding:s.encoding,timestamp:Date.now()});n.emit("leave",o)})}async subscribe(...e){let n=Pe.processListenerArgs(e),s=n[0],o=n[1],a=this.channel;if(a.state==="failed")throw h.fromValues(a.invalidStateError());this.subscriptions.on(s,o),a.channelOptions.attachOnSubscribe!==!1&&await a.attach()}unsubscribe(...e){let n=Pe.processListenerArgs(e),s=n[0],o=n[1];this.subscriptions.off(s,o)}},Cs=Zn;var zo=q.WebSocket;function Jo(r){return!!r.on}var er=class extends de{constructor(e,n,s){super(e,n,s);this.shortName=zo;s.heartbeats=p.Config.useProtocolHeartbeats,this.wsHost=s.host}static isAvailable(){return!!p.Config.WebSocket}createWebSocket(e,n){return this.uri=e+le(n),new p.Config.WebSocket(this.uri)}toString(){return"WebSocketTransport; uri="+this.uri}connect(){i.logAction(this.logger,i.LOG_MINOR,"WebSocketTransport.connect()","starting"),de.prototype.connect.call(this);let e=this,n=this.params,s=n.options,a=(s.tls?"wss://":"ws://")+this.wsHost+":"+R.getPort(s)+"/";i.logAction(this.logger,i.LOG_MINOR,"WebSocketTransport.connect()","uri: "+a),N(this.auth.getAuthParams(),function(c,l){if(e.isDisposed)return;let u="";for(let d in l)u+=" "+d+": "+l[d]+";";if(i.logAction(e.logger,i.LOG_MINOR,"WebSocketTransport.connect()","authParams:"+u+" err: "+c),c){e.disconnect(c);return}let g=n.getConnectParams(l);try{let d=e.wsConnection=e.createWebSocket(a,g);d.binaryType=p.Config.binaryType,d.onopen=function(){e.onWsOpen()},d.onclose=function(m){e.onWsClose(m)},d.onmessage=function(m){e.onWsData(m.data)},d.onerror=function(m){e.onWsError(m)},Jo(d)&&d.on("ping",function(){e.onActivity()})}catch(d){i.logAction(e.logger,i.LOG_ERROR,"WebSocketTransport.connect()","Unexpected exception creating websocket: err = "+(d.stack||d.message)),e.disconnect(d)}})}send(e){let n=this.wsConnection;if(!n){i.logAction(this.logger,i.LOG_ERROR,"WebSocketTransport.send()","No socket connection");return}try{n.send(hs(e,this.connectionManager.realtime._MsgPack,this.params.format))}catch(s){let o="Exception from ws connection when trying to send: "+w(s);i.logAction(this.logger,i.LOG_ERROR,"WebSocketTransport.send()",o),this.finish("disconnected",new h(o,5e4,500))}}onWsData(e){i.logAction(this.logger,i.LOG_MICRO,"WebSocketTransport.onWsData()","data received; length = "+e.length+"; type = "+typeof e);try{this.onProtocolMessage(ds(e,this.connectionManager.realtime._MsgPack,this.connectionManager.realtime._RealtimePresence,this.connectionManager.realtime._Annotations,this.connectionManager.realtime._objectsPlugin,this.format))}catch(n){i.logAction(this.logger,i.LOG_ERROR,"WebSocketTransport.onWsData()","Unexpected exception handing channel message: "+n.stack)}}onWsOpen(){i.logAction(this.logger,i.LOG_MINOR,"WebSocketTransport.onWsOpen()","opened WebSocket"),this.emit("preconnect")}onWsClose(e){let n,s;if(typeof e=="object"?(s=e.code,n=e.wasClean||s===1e3):(s=e,n=s==1e3),delete this.wsConnection,n){i.logAction(this.logger,i.LOG_MINOR,"WebSocketTransport.onWsClose()","Cleanly closed WebSocket");let o=new h("Websocket closed",80003,400);this.finish("disconnected",o)}else{let o="Unclean disconnection of WebSocket ; code = "+s,a=new h(o,80003,400);i.logAction(this.logger,i.LOG_MINOR,"WebSocketTransport.onWsClose()",o),this.finish("disconnected",a)}this.emit("disposed")}onWsError(e){i.logAction(this.logger,i.LOG_MINOR,"WebSocketTransport.onError()","Error from WebSocket: "+e.message),p.Config.nextTick(()=>{this.disconnect(Error(e.message))})}dispose(){i.logAction(this.logger,i.LOG_MINOR,"WebSocketTransport.dispose()",""),this.isDisposed=!0;let e=this.wsConnection;e&&(e.onmessage=function(){},delete this.wsConnection,p.Config.nextTick(()=>{if(i.logAction(this.logger,i.LOG_MICRO,"WebSocketTransport.dispose()","closing websocket"),!e)throw new Error("WebSocketTransport.dispose(): wsConnection is not defined");e.close()}))}},Ht=er;var Ft=class{static subscribeFilter(t,e,n){let s=o=>{var c,l,u,g,d,m;let a={name:o.name,refTimeserial:(l=(c=o.extras)==null?void 0:c.ref)==null?void 0:l.timeserial,refType:(g=(u=o.extras)==null?void 0:u.ref)==null?void 0:g.type,isRef:!!((m=(d=o.extras)==null?void 0:d.ref)!=null&&m.timeserial),clientId:o.clientId};Object.entries(e).find(([f,y])=>y!==void 0?a[f]!==y:!1)||n(o)};this.addFilteredSubscription(t,e,n,s),t.subscriptions.on(s)}static addFilteredSubscription(t,e,n,s){var o;if(t.filteredSubscriptions||(t.filteredSubscriptions=new Map),t.filteredSubscriptions.has(n)){let a=t.filteredSubscriptions.get(n);a.set(e,((o=a==null?void 0:a.get(e))==null?void 0:o.concat(s))||[s])}else t.filteredSubscriptions.set(n,new Map([[e,[s]]]))}static getAndDeleteFilteredSubscriptions(t,e,n){if(!t.filteredSubscriptions)return[];if(!n&&e)return Array.from(t.filteredSubscriptions.entries()).map(([a,c])=>{var u;let l=c.get(e);return c.delete(e),c.size===0&&((u=t.filteredSubscriptions)==null||u.delete(a)),l}).reduce((a,c)=>c?a.concat(...c):a,[]);if(!n||!t.filteredSubscriptions.has(n))return[];let s=t.filteredSubscriptions.get(n);if(!e){let a=Array.from(s.values()).reduce((c,l)=>c.concat(...l),[]);return t.filteredSubscriptions.delete(n),a}let o=s.get(e);return s.delete(e),o||[]}};var z=class z extends bs{constructor(t){var n;let e=z._MsgPack;if(!e)throw new Error("Expected DefaultRealtime._MsgPack to have been set");super(R.objectifyOptions(t,!0,"Realtime",i.defaultLogger,D(E({},Ut),{Crypto:(n=z.Crypto)!=null?n:void 0,MsgPack:e,RealtimePresence:{RealtimePresence:Cs,PresenceMessage:K,WirePresenceMessage:he},Annotations:{Annotation:re,WireAnnotation:ne,RealtimeAnnotations:je,RestAnnotations:Re},WebSocketTransport:Ht,MessageInteractions:Ft})))}static get Crypto(){if(this._Crypto===null)throw new Error("Encryption not enabled; use ably.encryption.js instead");return this._Crypto}static set Crypto(t){this._Crypto=t}};z.Utils=O,z.ConnectionManager=qt,z.ProtocolMessage=ps,z._Crypto=null,z.Message=De,z.PresenceMessage=He,z.Annotation=Fe,z._MsgPack=null,z._Http=fe,z._PresenceMap=ke,z._MessageEncoding=we;var Ve=z;var rr=Uint8Array,ut=Uint32Array,sr=Math.pow,Ts=new ut(8),Is=[],it=new ut(64);function As(r){return(r-(r|0))*sr(2,32)|0}var at=2,ct=0;for(;ct<64;){for(tr=!0,Gt=2;Gt<=at/2;Gt++)at%Gt===0&&(tr=!1);tr&&(ct<8&&(Ts[ct]=As(sr(at,1/2))),Is[ct]=As(sr(at,1/3)),ct++),at++}var tr,Gt,Ko=!!new rr(new ut([1]).buffer)[0];function nr(r){return Ko?r>>>24|(r>>>16&255)<<8|(r&65280)<<8|r<<24:r}function ce(r,t){return r>>>t|r<<32-t}function lt(r){var t=Ts.slice(),e=r.length,n=e*8,s=512-(n+64)%512-1+n+65,o=new rr(s/8),a=new ut(o.buffer);o.set(r,0),o[e]=128,a[a.length-1]=nr(n);for(var c,l=0;l<s/32;l+=16){var u=t.slice();for(c=0;c<64;c++){var g;if(c<16)g=nr(a[l+c]);else{var d=it[c-15],m=it[c-2];g=it[c-7]+it[c-16]+(ce(d,7)^ce(d,18)^d>>>3)+(ce(m,17)^ce(m,19)^m>>>10)}it[c]=g|=0;for(var f=(ce(u[4],6)^ce(u[4],11)^ce(u[4],25))+(u[4]&u[5]^~u[4]&u[6])+u[7]+g+Is[c],y=(ce(u[0],2)^ce(u[0],13)^ce(u[0],22))+(u[0]&u[1]^u[2]&(u[0]^u[1])),P=7;P>0;P--)u[P]=u[P-1];u[0]=f+y|0,u[4]=u[4]+f|0}for(c=0;c<8;c++)t[c]=t[c]+u[c]|0}return new rr(new ut(t.map(function(A){return nr(A)})).buffer)}function ws(r,t){if(r.length>64&&(r=lt(r)),r.length<64){let c=new Uint8Array(64);c.set(r,0),r=c}for(var e=new Uint8Array(64),n=new Uint8Array(64),s=0;s<64;s++)e[s]=54^r[s],n[s]=92^r[s];var o=new Uint8Array(t.length+64);o.set(e,0),o.set(t,64);var a=new Uint8Array(64+32);return a.set(n,0),a.set(lt(o),64),lt(a)}var or=class{constructor(){this.base64CharSet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";this.hexCharSet="0123456789abcdef"}uint8ViewToBase64(t){let e="",n=this.base64CharSet,s=t.byteLength,o=s%3,a=s-o,c,l,u,g,d;for(let m=0;m<a;m=m+3)d=t[m]<<16|t[m+1]<<8|t[m+2],c=(d&16515072)>>18,l=(d&258048)>>12,u=(d&4032)>>6,g=d&63,e+=n[c]+n[l]+n[u]+n[g];return o==1?(d=t[a],c=(d&252)>>2,l=(d&3)<<4,e+=n[c]+n[l]+"=="):o==2&&(d=t[a]<<8|t[a+1],c=(d&64512)>>10,l=(d&1008)>>4,u=(d&15)<<2,e+=n[c]+n[l]+n[u]+"="),e}base64ToArrayBuffer(t){let e=atob==null?void 0:atob(t),n=e.length,s=new Uint8Array(n);for(let o=0;o<n;o++){let a=e.charCodeAt(o);s[o]=a}return this.toArrayBuffer(s)}isBuffer(t){return t instanceof ArrayBuffer||ArrayBuffer.isView(t)}toBuffer(t){if(!ArrayBuffer)throw new Error("Can't convert to Buffer: browser does not support the necessary types");if(t instanceof ArrayBuffer)return new Uint8Array(t);if(ArrayBuffer.isView(t))return new Uint8Array(this.toArrayBuffer(t));throw new Error("BufferUtils.toBuffer expected an ArrayBuffer or a view onto one")}toArrayBuffer(t){if(!ArrayBuffer)throw new Error("Can't convert to ArrayBuffer: browser does not support the necessary types");if(t instanceof ArrayBuffer)return t;if(ArrayBuffer.isView(t))return t.buffer.slice(t.byteOffset,t.byteOffset+t.byteLength);throw new Error("BufferUtils.toArrayBuffer expected an ArrayBuffer or a view onto one")}base64Encode(t){return this.uint8ViewToBase64(this.toBuffer(t))}base64UrlEncode(t){return this.base64Encode(t).replace(/\+/g,"-").replace(/\//g,"_").replace(/=+$/,"")}base64Decode(t){if(ArrayBuffer&&p.Config.atob)return this.base64ToArrayBuffer(t);throw new Error("Expected ArrayBuffer to exist and Platform.Config.atob to be configured")}hexEncode(t){return this.toBuffer(t).reduce((n,s)=>n+s.toString(16).padStart(2,"0"),"")}hexDecode(t){if(t.length%2!==0)throw new Error("Can't create a byte array from a hex string of odd length");let e=new Uint8Array(t.length/2);for(let n=0;n<e.length;n++)e[n]=parseInt(t.slice(2*n,2*(n+1)),16);return this.toArrayBuffer(e)}utf8Encode(t){if(p.Config.TextEncoder){let e=new p.Config.TextEncoder().encode(t);return this.toArrayBuffer(e)}else throw new Error("Expected TextEncoder to be configured")}utf8Decode(t){if(!this.isBuffer(t))throw new Error("Expected input of utf8decode to be an arraybuffer or typed array");if(TextDecoder)return new TextDecoder().decode(t);throw new Error("Expected TextDecoder to be configured")}areBuffersEqual(t,e){if(!t||!e)return!1;let n=this.toArrayBuffer(t),s=this.toArrayBuffer(e);if(n.byteLength!=s.byteLength)return!1;let o=new Uint8Array(n),a=new Uint8Array(s);for(var c=0;c<o.length;c++)if(o[c]!=a[c])return!1;return!0}byteLength(t){return t instanceof ArrayBuffer||ArrayBuffer.isView(t)?t.byteLength:-1}arrayBufferViewToBuffer(t){return this.toArrayBuffer(t)}concat(t){let e=t.reduce((o,a)=>o+a.byteLength,0),n=new Uint8Array(e),s=0;for(let o of t){let a=this.toBuffer(o);n.set(a,s),s+=a.byteLength}return n.buffer}sha256(t){let e=lt(this.toBuffer(t));return this.toArrayBuffer(e)}hmacSha256(t,e){let n=ws(this.toBuffer(e),this.toBuffer(t));return this.toArrayBuffer(n)}},ir=new or;var Os=function(r,t){var e="aes",n=256,s="cbc",o=16;function a(m){if(m.algorithm==="aes"&&m.mode==="cbc"){if(m.keyLength===128||m.keyLength===256)return;throw new Error("Unsupported key length "+m.keyLength+" for aes-cbc encryption. Encryption key must be 128 or 256 bits (16 or 32 ASCII characters)")}}function c(m){return m.replace("_","/").replace("-","+")}function l(m){return m instanceof u}class u{constructor(f,y,P,A){this.algorithm=f,this.keyLength=y,this.mode=P,this.key=A}}class g{static getDefaultParams(f){var y;if(!f.key)throw new Error("Crypto.getDefaultParams: a key is required");typeof f.key=="string"?y=t.toArrayBuffer(t.base64Decode(c(f.key))):f.key instanceof ArrayBuffer?y=f.key:y=t.toArrayBuffer(f.key);var P=f.algorithm||e,A=y.byteLength*8,T=f.mode||s,k=new u(P,A,T,y);if(f.keyLength&&f.keyLength!==k.keyLength)throw new Error("Crypto.getDefaultParams: a keyLength of "+f.keyLength+" was specified, but the key actually has length "+k.keyLength);return a(k),k}static async generateRandomKey(f){try{return r.getRandomArrayBuffer((f||n)/8)}catch(y){throw new h("Failed to generate random key: "+y.message,400,5e4,y)}}static getCipher(f,y){var A;var P=l(f)?f:this.getDefaultParams(f);return{cipherParams:P,cipher:new d(P,(A=f.iv)!=null?A:null,y)}}}g.CipherParams=u;class d{constructor(f,y,P){this.logger=P;if(!crypto.subtle)throw isSecureContext?new Error("Crypto operations are not possible since the browser\u2019s SubtleCrypto class is unavailable (reason unknown)."):new Error("Crypto operations are is not possible since the current environment is a non-secure context and hence the browser\u2019s SubtleCrypto class is not available.");this.algorithm=f.algorithm+"-"+String(f.keyLength)+"-"+f.mode,this.webCryptoAlgorithm=f.algorithm+"-"+f.mode,this.key=t.toArrayBuffer(f.key),this.iv=y?t.toArrayBuffer(y):null}concat(f,y){let P=new ArrayBuffer(f.byteLength+y.byteLength),A=new DataView(P),T=new DataView(t.toArrayBuffer(f));for(let U=0;U<T.byteLength;U++)A.setInt8(U,T.getInt8(U));let k=new DataView(t.toArrayBuffer(y));for(let U=0;U<k.byteLength;U++)A.setInt8(T.byteLength+U,k.getInt8(U));return P}async encrypt(f){i.logAction(this.logger,i.LOG_MICRO,"CBCCipher.encrypt()","");let y=await this.getIv(),P=await crypto.subtle.importKey("raw",this.key,this.webCryptoAlgorithm,!1,["encrypt"]),A=await crypto.subtle.encrypt({name:this.webCryptoAlgorithm,iv:y},P,f);return this.concat(y,A)}async decrypt(f){i.logAction(this.logger,i.LOG_MICRO,"CBCCipher.decrypt()","");let y=t.toArrayBuffer(f),P=y.slice(0,o),A=y.slice(o),T=await crypto.subtle.importKey("raw",this.key,this.webCryptoAlgorithm,!1,["decrypt"]);return crypto.subtle.decrypt({name:this.webCryptoAlgorithm,iv:P},T,A)}async getIv(){if(this.iv){var f=this.iv;return this.iv=null,f}let y=await r.getRandomArrayBuffer(o);return t.toArrayBuffer(y)}}return g};var ks=(s=>(s[s.REQ_SEND=0]="REQ_SEND",s[s.REQ_RECV=1]="REQ_RECV",s[s.REQ_RECV_POLL=2]="REQ_RECV_POLL",s[s.REQ_RECV_STREAM=3]="REQ_RECV_STREAM",s))(ks||{}),Y=ks;function Ms(){return new h("No HTTP request plugin provided. Provide at least one of the FetchRequest or XHRRequest plugins.",400,4e4)}var ht,Es=(ht=class{constructor(r){this.checksInProgress=null;this.checkConnectivity=void 0;this.supportsAuthHeaders=!1;this.supportsLinkHeaders=!1;var l;this.client=r!=null?r:null;let t=(r==null?void 0:r.options.connectivityCheckUrl)||R.connectivityCheckUrl,e=(l=r==null?void 0:r.options.connectivityCheckParams)!=null?l:null,n=!(r!=null&&r.options.connectivityCheckUrl),s=E(E({},Es.bundledRequestImplementations),r==null?void 0:r._additionalHTTPRequestImplementations),o=s.XHRRequest,a=s.FetchRequest,c=!!(o||a);if(!c)throw Ms();p.Config.xhrSupported&&o?(this.supportsAuthHeaders=!0,this.Request=async function(u,g,d,m,f){return new Promise(y=>{var A;let P=o.createRequest(g,d,m,f,Y.REQ_SEND,(A=r&&r.options.timeouts)!=null?A:null,this.logger,u);P.once("complete",(T,k,U,Me,I)=>y({error:T,body:k,headers:U,unpacked:Me,statusCode:I})),P.exec()})},r!=null&&r.options.disableConnectivityCheck?this.checkConnectivity=async function(){return!0}:this.checkConnectivity=async function(){var d;i.logAction(this.logger,i.LOG_MICRO,"(XHRRequest)Http.checkConnectivity()","Sending; "+t);let u=await this.doUri(x.Get,t,null,null,e),g=!1;return n?g=!u.error&&((d=u.body)==null?void 0:d.replace(/\n/,""))=="yes":g=!u.error&&Hr(u.statusCode),i.logAction(this.logger,i.LOG_MICRO,"(XHRRequest)Http.checkConnectivity()","Result: "+g),g}):p.Config.fetchSupported&&a?(this.supportsAuthHeaders=!0,this.Request=async(u,g,d,m,f)=>a(u,r!=null?r:null,g,d,m,f),r!=null&&r.options.disableConnectivityCheck?this.checkConnectivity=async function(){return!0}:this.checkConnectivity=async function(){var d;i.logAction(this.logger,i.LOG_MICRO,"(Fetch)Http.checkConnectivity()","Sending; "+t);let u=await this.doUri(x.Get,t,null,null,null),g=!u.error&&((d=u.body)==null?void 0:d.replace(/\n/,""))=="yes";return i.logAction(this.logger,i.LOG_MICRO,"(Fetch)Http.checkConnectivity()","Result: "+g),g}):this.Request=async()=>({error:c?new v("no supported HTTP transports available",null,400):Ms()})}get logger(){var r,t;return(t=(r=this.client)==null?void 0:r.logger)!=null?t:i.defaultLogger}async doUri(r,t,e,n,s){return this.Request?this.Request(r,t,e,s,n):{error:new v("Request invoked before assigned to",null,500)}}shouldFallback(r){let t=r.statusCode;return t===408&&!r.code||t===400&&!r.code||t>=500&&t<=504}},ht.methods=[x.Get,x.Delete,x.Post,x.Put,x.Patch],ht.methodsWithoutBody=[x.Get,x.Delete],ht.methodsWithBody=[x.Post,x.Put,x.Patch],ht),ar=Es;var ze="ablyjs-storage-test",Je=typeof global!="undefined"?global:typeof window!="undefined"?window:self,cr=class{constructor(){try{Je.sessionStorage.setItem(ze,ze),Je.sessionStorage.removeItem(ze),this.sessionSupported=!0}catch(t){this.sessionSupported=!1}try{Je.localStorage.setItem(ze,ze),Je.localStorage.removeItem(ze),this.localSupported=!0}catch(t){this.localSupported=!1}}get(t){return this._get(t,!1)}getSession(t){return this._get(t,!0)}remove(t){return this._remove(t,!1)}removeSession(t){return this._remove(t,!0)}set(t,e,n){return this._set(t,e,n,!1)}setSession(t,e,n){return this._set(t,e,n,!0)}_set(t,e,n,s){let o={value:e};return n&&(o.expires=Date.now()+n),this.storageInterface(s).setItem(t,JSON.stringify(o))}_get(t,e){if(e&&!this.sessionSupported)throw new Error("Session Storage not supported");if(!e&&!this.localSupported)throw new Error("Local Storage not supported");let n=this.storageInterface(e).getItem(t);if(!n)return null;let s=JSON.parse(n);return s.expires&&s.expires<Date.now()?(this.storageInterface(e).removeItem(t),null):s.value}_remove(t,e){return this.storageInterface(e).removeItem(t)}storageInterface(t){return t?Je.sessionStorage:Je.localStorage}},jt=new cr;var L=Ye(),Qo=typeof EdgeRuntime=="string";typeof Window=="undefined"&&typeof WorkerGlobalScope=="undefined"&&!Qo&&console.log("Warning: this distribution of Ably is intended for browsers. On nodejs, please use the 'ably' package on npm");function $o(){let r=L.location;return!L.WebSocket||!r||!r.origin||r.origin.indexOf("http")>-1}function Xo(){return typeof WorkerGlobalScope!="undefined"&&self instanceof WorkerGlobalScope}var Yo=L.navigator&&L.navigator.userAgent.toString(),Zo=L.location&&L.location.href,ei={agent:"browser",logTimestamps:!0,userAgent:Yo,currentUrl:Zo,binaryType:"arraybuffer",WebSocket:L.WebSocket,fetchSupported:!!L.fetch,xhrSupported:L.XMLHttpRequest&&"withCredentials"in new XMLHttpRequest,allowComet:$o(),useProtocolHeartbeats:!0,supportsBinary:!!L.TextDecoder,preferBinary:!1,ArrayBuffer:L.ArrayBuffer,atob:L.atob,nextTick:typeof L.setImmediate!="undefined"?L.setImmediate.bind(L):function(r){setTimeout(r,0)},addEventListener:L.addEventListener,inspect:JSON.stringify,stringByteSize:function(r){return L.TextDecoder&&new L.TextEncoder().encode(r).length||r.length},TextEncoder:L.TextEncoder,TextDecoder:L.TextDecoder,getRandomArrayBuffer:async function(r){let t=new Uint8Array(r);return L.crypto.getRandomValues(t),t.buffer},isWebworker:Xo(),push:{platform:"browser",formFactor:"desktop",storage:jt}},lr=ei;function ti(r){let t=[80015,80017,80030];return r.code?Q.isTokenErr(r)?!1:t.includes(r.code)?!0:r.code>=4e4&&r.code<5e4:!1}function ur(r){return ti(r)?[F({action:b.ERROR,error:r})]:[F({action:b.DISCONNECTED,error:r})]}var hr=class extends de{constructor(e,n,s){super(e,n,s,!0);this.onAuthUpdated=e=>{this.authParams={access_token:e.token}};this.stream="stream"in s?s.stream:!0,this.sendRequest=null,this.recvRequest=null,this.pendingCallback=null,this.pendingItems=null}connect(){i.logAction(this.logger,i.LOG_MINOR,"CometTransport.connect()","starting"),de.prototype.connect.call(this);let e=this.params,n=e.options,s=e.host||n.primaryDomain,o=R.getPort(n),a=n.tls?"https://":"http://";this.baseUri=a+s+":"+o+"/comet/";let c=this.baseUri+"connect";i.logAction(this.logger,i.LOG_MINOR,"CometTransport.connect()","uri: "+c),N(this.auth.getAuthParams(),(l,u)=>{if(l){this.disconnect(l);return}if(this.isDisposed)return;this.authParams=u;let g=this.params.getConnectParams(u);"stream"in g&&(this.stream=g.stream),i.logAction(this.logger,i.LOG_MINOR,"CometTransport.connect()","connectParams:"+le(g));let d=!1,m=this.recvRequest=this.createRequest(c,null,g,null,this.stream?Y.REQ_RECV_STREAM:Y.REQ_RECV);m.on("data",f=>{this.recvRequest&&(d||(d=!0,this.emit("preconnect")),this.onData(f))}),m.on("complete",f=>{if(this.recvRequest||(f=f||new h("Request cancelled",80003,400)),this.recvRequest=null,!d&&!f&&(d=!0,this.emit("preconnect")),this.onActivity(),f){f.code?this.onData(ur(f)):this.disconnect(f);return}p.Config.nextTick(()=>{this.recv()})}),m.exec()})}requestClose(){i.logAction(this.logger,i.LOG_MINOR,"CometTransport.requestClose()"),this._requestCloseOrDisconnect(!0)}requestDisconnect(){i.logAction(this.logger,i.LOG_MINOR,"CometTransport.requestDisconnect()"),this._requestCloseOrDisconnect(!1)}_requestCloseOrDisconnect(e){let n=e?this.closeUri:this.disconnectUri;if(n){let s=this.createRequest(n,null,this.authParams,null,Y.REQ_SEND);s.on("complete",o=>{o&&(i.logAction(this.logger,i.LOG_ERROR,"CometTransport.request"+(e?"Close()":"Disconnect()"),"request returned err = "+w(o)),this.finish("disconnected",o))}),s.exec()}}dispose(){i.logAction(this.logger,i.LOG_MINOR,"CometTransport.dispose()",""),this.isDisposed||(this.isDisposed=!0,this.recvRequest&&(i.logAction(this.logger,i.LOG_MINOR,"CometTransport.dispose()","aborting recv request"),this.recvRequest.abort(),this.recvRequest=null),this.finish("disconnected",ae.disconnected()),p.Config.nextTick(()=>{this.emit("disposed")}))}onConnect(e){var o;if(this.isDisposed)return;let n=(o=e.connectionDetails)==null?void 0:o.connectionKey;de.prototype.onConnect.call(this,e);let s=this.baseUri+n;i.logAction(this.logger,i.LOG_MICRO,"CometTransport.onConnect()","baseUri = "+s),this.sendUri=s+"/send",this.recvUri=s+"/recv",this.closeUri=s+"/close",this.disconnectUri=s+"/disconnect"}send(e){if(this.sendRequest){this.pendingItems=this.pendingItems||[],this.pendingItems.push(e);return}let n=this.pendingItems||[];n.push(e),this.pendingItems=null,this.sendItems(n)}sendAnyPending(){let e=this.pendingItems;e&&(this.pendingItems=null,this.sendItems(e))}sendItems(e){let n=this.sendRequest=this.createRequest(this.sendUri,null,this.authParams,this.encodeRequest(e),Y.REQ_SEND);n.on("complete",(s,o)=>{if(s&&i.logAction(this.logger,i.LOG_ERROR,"CometTransport.sendItems()","on complete: err = "+w(s)),this.sendRequest=null,s){s.code?this.onData(ur(s)):this.disconnect(s);return}o&&this.onData(o),this.pendingItems&&p.Config.nextTick(()=>{this.sendRequest||this.sendAnyPending()})}),n.exec()}recv(){if(this.recvRequest||!this.isConnected)return;let e=this.recvRequest=this.createRequest(this.recvUri,null,this.authParams,null,this.stream?Y.REQ_RECV_STREAM:Y.REQ_RECV_POLL);e.on("data",n=>{this.onData(n)}),e.on("complete",n=>{if(this.recvRequest=null,this.onActivity(),n){n.code?this.onData(ur(n)):this.disconnect(n);return}p.Config.nextTick(()=>{this.recv()})}),e.exec()}onData(e){try{let n=this.decodeResponse(e);if(n&&n.length)for(let s=0;s<n.length;s++)this.onProtocolMessage(Lt(n[s],this.connectionManager.realtime._RealtimePresence,this.connectionManager.realtime._Annotations,this.connectionManager.realtime._objectsPlugin))}catch(n){i.logAction(this.logger,i.LOG_ERROR,"CometTransport.onData()","Unexpected exception handing channel event: "+n.stack)}}encodeRequest(e){return JSON.stringify(e)}decodeResponse(e){return typeof e=="string"?JSON.parse(e):e}},vs=hr;function ni(r,t){return $e(pe(t)).includes("x-ably-errorcode")}function ri(r,t){if(ni(r,t))return r.error&&h.fromValues(r.error)}var si=function(){},oi=0,Ss={};function ii(r,t){return r.getResponseHeader&&r.getResponseHeader(t)}function ai(r){return r.getResponseHeader&&(r.getResponseHeader("transfer-encoding")||!r.getResponseHeader("content-length"))}function ci(r){let t=r.getAllResponseHeaders().trim().split(`\r
`),e={};for(let n=0;n<t.length;n++){let s=t[n].split(":").map(o=>o.trim());e[s[0].toLowerCase()]=s[1]}return e}var dr=class r extends M{constructor(e,n,s,o,a,c,l,u){super(l);s=s||{},s.rnd=Te(),this.uri=e+le(s),this.headers=n||{},this.body=o,this.method=u?u.toUpperCase():V(o)?"GET":"POST",this.requestMode=a,this.timeouts=c,this.timedOut=!1,this.requestComplete=!1,this.id=String(++oi),Ss[this.id]=this}static createRequest(e,n,s,o,a,c,l,u){let g=c||R.TIMEOUTS;return new r(e,n,oe(s),o,a,g,l,u)}complete(e,n,s,o,a){this.requestComplete||(this.requestComplete=!0,!e&&n&&this.emit("data",n),this.emit("complete",e,n,s,o,a),this.dispose())}abort(){this.dispose()}exec(){let e=this.headers,n=this.requestMode==Y.REQ_SEND?this.timeouts.httpRequestTimeout:this.timeouts.recvTimeout,s=this.timer=setTimeout(()=>{this.timedOut=!0,a.abort()},n),o=this.method,a=this.xhr=new XMLHttpRequest,c=e.accept,l=this.body,u="text";c?c.indexOf("application/x-msgpack")===0&&(u="arraybuffer"):e.accept="application/json",l&&(e["content-type"]||(e["content-type"]="application/json")).indexOf("application/json")>-1&&typeof l!="string"&&(l=JSON.stringify(l)),a.open(o,this.uri,!0),a.responseType=u,"authorization"in e&&(a.withCredentials=!0);for(let I in e)a.setRequestHeader(I,e[I]);let g=(I,$,G,Ke)=>{var Rr;let Ce=$+" (event type: "+I.type+")";(Rr=this==null?void 0:this.xhr)!=null&&Rr.statusText&&(Ce+=", current statusText is "+this.xhr.statusText),i.logAction(this.logger,i.LOG_ERROR,"Request.on"+I.type+"()",Ce),this.complete(new v(Ce,G,Ke))};a.onerror=function(I){g(I,"XHR error occurred",null,400)},a.onabort=I=>{this.timedOut?g(I,"Request aborted due to request timeout expiring",null,408):g(I,"Request cancelled",null,400)},a.ontimeout=function(I){g(I,"Request timed out",null,408)};let d,m,f,y=0,P=!1,A=()=>{if(clearTimeout(s),f=m<400,m==204){this.complete(null,null,null,null,m);return}d=this.requestMode==Y.REQ_RECV_STREAM&&f&&ai(a)},T=()=>{let I;try{let G=ii(a,"content-type");if(G?G.indexOf("application/json")>=0:a.responseType=="text"){let Ce=a.responseType==="arraybuffer"?p.BufferUtils.utf8Decode(a.response):String(a.responseText);Ce.length?I=JSON.parse(Ce):I=Ce,P=!0}else I=a.response;I.response!==void 0?(m=I.statusCode,f=m<400,e=I.headers,I=I.response):e=ci(a)}catch(G){this.complete(new v("Malformed response body from server: "+G.message,null,400));return}if(f||Array.isArray(I)){this.complete(null,I,e,P,m);return}let $=ri(I,e);$||($=new v("Error response received from server: "+m+" body was: "+p.Config.inspect(I),null,m)),this.complete($,I,e,P,m)};function k(){let I=a.responseText,$=I.length-1,G,Ke;for(;y<$&&(G=I.indexOf(`
`,y))>-1;)Ke=I.slice(y,G),y=G+1,U(Ke)}let U=I=>{try{I=JSON.parse(I)}catch($){this.complete(new v("Malformed response body from server: "+$.message,null,400));return}this.emit("data",I)},Me=()=>{k(),this.streamComplete=!0,p.Config.nextTick(()=>{this.complete()})};a.onreadystatechange=function(){let I=a.readyState;I<3||a.status!==0&&(m===void 0&&(m=a.status,A()),I==3&&d?k():I==4&&(d?Me():T()))},a.send(l)}dispose(){let e=this.xhr;if(e){e.onreadystatechange=e.onerror=e.onabort=e.ontimeout=si,this.xhr=null;let n=this.timer;n&&(clearTimeout(n),this.timer=null),this.requestComplete||e.abort()}delete Ss[this.id]}},Wt=dr;var xs=q.XhrPolling,pr=class extends vs{constructor(e,n,s){super(e,n,s);this.shortName=xs;s.stream=!1,this.shortName=xs}static isAvailable(){return!!(p.Config.xhrSupported&&p.Config.allowComet)}toString(){return"XHRPollingTransport; uri="+this.baseUri+"; isConnected="+this.isConnected}createRequest(e,n,s,o,a){return Wt.createRequest(e,n,s,o,a,this.timeouts,this.logger)}},Us=pr;var li=["xhr_polling"],ui={order:li,bundledImplementations:{web_socket:Ht,xhr_polling:Us}},Bs=ui;var hi={connectivityCheckUrl:"https://internet-up.ably-realtime.com/is-the-internet-up.txt",wsConnectivityCheckUrl:"wss://ws-up.ably-realtime.com",defaultTransports:[q.XhrPolling,q.WebSocket]},_s=hi;function di(r){if(r===void 0)return"undefined";let t,e;if(r instanceof ArrayBuffer?(e="ArrayBuffer",t=new DataView(r)):r instanceof DataView&&(e="DataView",t=r),!t)return JSON.stringify(r);let n=[];for(let s=0;s<r.byteLength;s++){if(s>20){n.push("...");break}let o=t.getUint8(s).toString(16);o.length===1&&(o="0"+o),n.push(o)}return"<"+e+" "+n.join(" ")+">"}function dt(r,t,e){for(let n=0,s=e.length;n<s;n++){let o=e.charCodeAt(n);if(o<128){r.setUint8(t++,o>>>0&127|0);continue}if(o<2048){r.setUint8(t++,o>>>6&31|192),r.setUint8(t++,o>>>0&63|128);continue}if(o<65536){r.setUint8(t++,o>>>12&15|224),r.setUint8(t++,o>>>6&63|128),r.setUint8(t++,o>>>0&63|128);continue}if(o<1114112){r.setUint8(t++,o>>>18&7|240),r.setUint8(t++,o>>>12&63|128),r.setUint8(t++,o>>>6&63|128),r.setUint8(t++,o>>>0&63|128);continue}throw new Error("bad codepoint "+o)}}function Ls(r,t,e){let n="";for(let s=t,o=t+e;s<o;s++){let a=r.getUint8(s);if(!(a&128)){n+=String.fromCharCode(a);continue}if((a&224)===192){n+=String.fromCharCode((a&15)<<6|r.getUint8(++s)&63);continue}if((a&240)===224){n+=String.fromCharCode((a&15)<<12|(r.getUint8(++s)&63)<<6|(r.getUint8(++s)&63)<<0);continue}if((a&248)===240){n+=String.fromCharCode((a&7)<<18|(r.getUint8(++s)&63)<<12|(r.getUint8(++s)&63)<<6|(r.getUint8(++s)&63)<<0);continue}throw new Error("Invalid byte "+a.toString(16))}return n}function fr(r){let t=0;for(let e=0,n=r.length;e<n;e++){let s=r.charCodeAt(e);if(s<128){t+=1;continue}if(s<2048){t+=2;continue}if(s<65536){t+=3;continue}if(s<1114112){t+=4;continue}throw new Error("bad codepoint "+s)}return t}function pi(r,t){let e=gt(r,t);if(e===0)return;let n=new ArrayBuffer(e),s=new DataView(n);return pt(r,s,0,t),n}var mr=65536*65536,Ns=1/mr;function gi(r,t){return t=t||0,r.getInt32(t)*mr+r.getUint32(t+4)}function fi(r,t){return t=t||0,r.getUint32(t)*mr+r.getUint32(t+4)}function mi(r,t,e){e<9223372036854776e3?(r.setInt32(t,Math.floor(e*Ns)),r.setInt32(t+4,e&-1)):(r.setUint32(t,2147483647),r.setUint32(t+4,2147483647))}function yi(r,t,e){e<18446744073709552e3?(r.setUint32(t,Math.floor(e*Ns)),r.setInt32(t+4,e&-1)):(r.setUint32(t,4294967295),r.setUint32(t+4,4294967295))}var gr=class{constructor(t,e){this.map=t=>{let e={};for(let n=0;n<t;n++){let s=this.parse();e[s]=this.parse()}return e};this.bin=t=>{let e=new ArrayBuffer(t);return new Uint8Array(e).set(new Uint8Array(this.view.buffer,this.offset,t),0),this.offset+=t,e};this.buf=this.bin;this.str=t=>{let e=Ls(this.view,this.offset,t);return this.offset+=t,e};this.array=t=>{let e=new Array(t);for(let n=0;n<t;n++)e[n]=this.parse();return e};this.ext=t=>(this.offset+=t,{type:this.view.getInt8(this.offset),data:this.buf(t)});this.parse=()=>{let t=this.view.getUint8(this.offset),e,n;if(!(t&128))return this.offset++,t;if((t&240)===128)return n=t&15,this.offset++,this.map(n);if((t&240)===144)return n=t&15,this.offset++,this.array(n);if((t&224)===160)return n=t&31,this.offset++,this.str(n);if((t&224)===224)return e=this.view.getInt8(this.offset),this.offset++,e;switch(t){case 192:return this.offset++,null;case 193:this.offset++;return;case 194:return this.offset++,!1;case 195:return this.offset++,!0;case 196:return n=this.view.getUint8(this.offset+1),this.offset+=2,this.bin(n);case 197:return n=this.view.getUint16(this.offset+1),this.offset+=3,this.bin(n);case 198:return n=this.view.getUint32(this.offset+1),this.offset+=5,this.bin(n);case 199:return n=this.view.getUint8(this.offset+1),this.offset+=2,this.ext(n);case 200:return n=this.view.getUint16(this.offset+1),this.offset+=3,this.ext(n);case 201:return n=this.view.getUint32(this.offset+1),this.offset+=5,this.ext(n);case 202:return e=this.view.getFloat32(this.offset+1),this.offset+=5,e;case 203:return e=this.view.getFloat64(this.offset+1),this.offset+=9,e;case 204:return e=this.view.getUint8(this.offset+1),this.offset+=2,e;case 205:return e=this.view.getUint16(this.offset+1),this.offset+=3,e;case 206:return e=this.view.getUint32(this.offset+1),this.offset+=5,e;case 207:return e=fi(this.view,this.offset+1),this.offset+=9,e;case 208:return e=this.view.getInt8(this.offset+1),this.offset+=2,e;case 209:return e=this.view.getInt16(this.offset+1),this.offset+=3,e;case 210:return e=this.view.getInt32(this.offset+1),this.offset+=5,e;case 211:return e=gi(this.view,this.offset+1),this.offset+=9,e;case 212:return n=1,this.offset++,this.ext(n);case 213:return n=2,this.offset++,this.ext(n);case 214:return n=4,this.offset++,this.ext(n);case 215:return n=8,this.offset++,this.ext(n);case 216:return n=16,this.offset++,this.ext(n);case 217:return n=this.view.getUint8(this.offset+1),this.offset+=2,this.str(n);case 218:return n=this.view.getUint16(this.offset+1),this.offset+=3,this.str(n);case 219:return n=this.view.getUint32(this.offset+1),this.offset+=5,this.str(n);case 220:return n=this.view.getUint16(this.offset+1),this.offset+=3,this.array(n);case 221:return n=this.view.getUint32(this.offset+1),this.offset+=5,this.array(n);case 222:return n=this.view.getUint16(this.offset+1),this.offset+=3,this.map(n);case 223:return n=this.view.getUint32(this.offset+1),this.offset+=5,this.map(n)}throw new Error("Unknown type 0x"+t.toString(16))};this.offset=e||0,this.view=t}};function Ri(r){let t=new DataView(r),e=new gr(t),n=e.parse();if(e.offset!==r.byteLength)throw new Error(r.byteLength-e.offset+" trailing bytes");return n}function qs(r,t){return Object.keys(r).filter(function(e){let n=r[e],s=typeof n;return(!t||n!=null)&&(s!=="function"||!!n.toJSON)})}function pt(r,t,e,n){let s=typeof r;if(typeof r=="string"){let o=fr(r);if(o<32)return t.setUint8(e,o|160),dt(t,e+1,r),1+o;if(o<256)return t.setUint8(e,217),t.setUint8(e+1,o),dt(t,e+2,r),2+o;if(o<65536)return t.setUint8(e,218),t.setUint16(e+1,o),dt(t,e+3,r),3+o;if(o<4294967296)return t.setUint8(e,219),t.setUint32(e+1,o),dt(t,e+5,r),5+o}if(ArrayBuffer.isView&&ArrayBuffer.isView(r)&&(r=r.buffer),r instanceof ArrayBuffer){let o=r.byteLength;if(o<256)return t.setUint8(e,196),t.setUint8(e+1,o),new Uint8Array(t.buffer).set(new Uint8Array(r),e+2),2+o;if(o<65536)return t.setUint8(e,197),t.setUint16(e+1,o),new Uint8Array(t.buffer).set(new Uint8Array(r),e+3),3+o;if(o<4294967296)return t.setUint8(e,198),t.setUint32(e+1,o),new Uint8Array(t.buffer).set(new Uint8Array(r),e+5),5+o}if(typeof r=="number"){if(Math.floor(r)!==r)return t.setUint8(e,203),t.setFloat64(e+1,r),9;if(r>=0){if(r<128)return t.setUint8(e,r),1;if(r<256)return t.setUint8(e,204),t.setUint8(e+1,r),2;if(r<65536)return t.setUint8(e,205),t.setUint16(e+1,r),3;if(r<4294967296)return t.setUint8(e,206),t.setUint32(e+1,r),5;if(r<18446744073709552e3)return t.setUint8(e,207),yi(t,e+1,r),9;throw new Error("Number too big 0x"+r.toString(16))}if(r>=-32)return t.setInt8(e,r),1;if(r>=-128)return t.setUint8(e,208),t.setInt8(e+1,r),2;if(r>=-32768)return t.setUint8(e,209),t.setInt16(e+1,r),3;if(r>=-2147483648)return t.setUint8(e,210),t.setInt32(e+1,r),5;if(r>=-9223372036854776e3)return t.setUint8(e,211),mi(t,e+1,r),9;throw new Error("Number too small -0x"+(-r).toString(16).substr(1))}if(s==="undefined")return n?0:(t.setUint8(e,212),t.setUint8(e+1,0),t.setUint8(e+2,0),3);if(r===null)return n?0:(t.setUint8(e,192),1);if(s==="boolean")return t.setUint8(e,r?195:194),1;if(typeof r.toJSON=="function")return pt(r.toJSON(),t,e,n);if(s==="object"){let o,a=0,c,l=Array.isArray(r);if(l?o=r.length:(c=qs(r,n),o=c.length),o<16?(t.setUint8(e,o|(l?144:128)),a=1):o<65536?(t.setUint8(e,l?220:222),t.setUint16(e+1,o),a=3):o<4294967296&&(t.setUint8(e,l?221:223),t.setUint32(e+1,o),a=5),l)for(let u=0;u<o;u++)a+=pt(r[u],t,e+a,n);else if(c)for(let u=0;u<o;u++){let g=c[u];a+=pt(g,t,e+a),a+=pt(r[g],t,e+a,n)}return a}if(s==="function")return 0;throw new Error("Unknown type "+s)}function gt(r,t){let e=typeof r;if(e==="string"){let n=fr(r);if(n<32)return 1+n;if(n<256)return 2+n;if(n<65536)return 3+n;if(n<4294967296)return 5+n}if(ArrayBuffer.isView&&ArrayBuffer.isView(r)&&(r=r.buffer),r instanceof ArrayBuffer){let n=r.byteLength;if(n<256)return 2+n;if(n<65536)return 3+n;if(n<4294967296)return 5+n}if(typeof r=="number"){if(Math.floor(r)!==r)return 9;if(r>=0){if(r<128)return 1;if(r<256)return 2;if(r<65536)return 3;if(r<4294967296)return 5;if(r<18446744073709552e3)return 9;throw new Error("Number too big 0x"+r.toString(16))}if(r>=-32)return 1;if(r>=-128)return 2;if(r>=-32768)return 3;if(r>=-2147483648)return 5;if(r>=-9223372036854776e3)return 9;throw new Error("Number too small -0x"+r.toString(16).substr(1))}if(e==="boolean")return 1;if(r===null)return t?0:1;if(r===void 0)return t?0:3;if(typeof r.toJSON=="function")return gt(r.toJSON(),t);if(e==="object"){let n,s=0;if(Array.isArray(r)){n=r.length;for(let o=0;o<n;o++)s+=gt(r[o],t)}else{let o=qs(r,t);n=o.length;for(let a=0;a<n;a++){let c=o[a];s+=gt(c)+gt(r[c],t)}}if(n<16)return 1+s;if(n<65536)return 3+s;if(n<4294967296)return 5+s;throw new Error("Array or object too long 0x"+n.toString(16))}if(e==="function")return 0;throw new Error("Unknown type "+e)}var Vt={encode:pi,decode:Ri,inspect:di,utf8Write:dt,utf8Read:Ls,utf8ByteCount:fr};function Pi(r,t){return!!t.get("x-ably-errorcode")}function bi(r,t){if(Pi(r,t))return r.error&&h.fromValues(r.error)}function Ci(r){let t={};return r.forEach((e,n)=>{t[n]=e}),t}async function yr(r,t,e,n,s,o){let a=new Headers(n||{}),c=r?r.toUpperCase():V(o)?"GET":"POST",l=new AbortController,u,g=new Promise(f=>{u=setTimeout(()=>{l.abort(),f({error:new v("Request timed out",null,408)})},t?t.options.timeouts.httpRequestTimeout:R.TIMEOUTS.httpRequestTimeout)}),d={method:c,headers:a,body:o,signal:l.signal};p.Config.isWebworker||(d.credentials=a.has("authorization")?"include":"same-origin");let m=(async()=>{try{let f=new URLSearchParams(s||{});f.set("rnd",Te());let y=e+"?"+f,P=await Ye().fetch(y,d);if(clearTimeout(u),P.status==204)return{error:null,statusCode:P.status};let A=P.headers.get("Content-Type"),T;A&&A.indexOf("application/x-msgpack")>-1?T=await P.arrayBuffer():A&&A.indexOf("application/json")>-1?T=await P.json():T=await P.text();let k=!!A&&A.indexOf("application/x-msgpack")===-1,U=Ci(P.headers);return P.ok?{error:null,body:T,headers:U,unpacked:k,statusCode:P.status}:{error:bi(T,P.headers)||new v("Error response received from server: "+P.status+" body was: "+p.Config.inspect(T),null,P.status),body:T,headers:U,unpacked:k,statusCode:P.status}}catch(f){return clearTimeout(u),{error:f}}})();return Promise.race([g,m])}var Ds={XHRRequest:Wt,FetchRequest:yr};var Hs=Os(lr,ir);p.Crypto=Hs;p.BufferUtils=ir;p.Http=ar;p.Config=lr;p.Transports=Bs;p.WebStorage=jt;for(let r of[We,Ve])r.Crypto=Hs,r._MsgPack=Vt;ar.bundledRequestImplementations=Ds;i.initLogHandlers();p.Defaults=Nr(_s);p.Config.agent&&(p.Defaults.agent+=" "+p.Config.agent);var Ai={ErrorInfo:h,Rest:We,Realtime:Ve,msgpack:Vt,makeProtocolMessageFromDeserialized:Ln};
if (typeof module.exports == "object" && typeof exports == "object") {
  var __cp = (to, from, except, desc) => {
    if ((from && typeof from === "object") || typeof from === "function") {
      for (let key of Object.getOwnPropertyNames(from)) {
        if (!Object.prototype.hasOwnProperty.call(to, key) && key !== except)
        Object.defineProperty(to, key, {
          get: () => from[key],
          enumerable: !(desc = Object.getOwnPropertyDescriptor(from, key)) || desc.enumerable,
        });
      }
    }
    return to;
  };
  module.exports = __cp(module.exports, exports);
}
return module.exports;
}))
//# sourceMappingURL=ably.min.js.map
