"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useChannelAttach = void 0;
const react_1 = require("react");
const useConnectionStateListener_js_1 = require("./useConnectionStateListener.js");
const useAbly_js_1 = require("./useAbly.js");
const constants_js_1 = require("./constants.js");
const utils_js_1 = require("../utils.js");
function useChannelAttach(channel, ablyId, skip) {
    const ably = (0, useAbly_js_1.useAbly)(ablyId);
    // we need to listen for the current connection state in order to react to it.
    // for example, we should attach when first connected, re-enter when reconnected,
    // and be able to prevent attaching when the connection is in an inactive state.
    // all of that can be achieved by using the useConnectionStateListener hook.
    const [connectionState, setConnectionState] = (0, react_1.useState)(ably.connection.state);
    (0, useConnectionStateListener_js_1.useConnectionStateListener)((stateChange) => {
        setConnectionState(stateChange.current);
    }, ablyId);
    if (ably.connection.state !== connectionState) {
        setConnectionState(ably.connection.state);
    }
    const shouldAttachToTheChannel = !skip && !constants_js_1.INACTIVE_CONNECTION_STATES.includes(connectionState);
    (0, react_1.useEffect)(() => {
        if (shouldAttachToTheChannel) {
            channel.attach().catch((reason) => {
                // we use a fire-and-forget approach for attaching, but calling detach during the attaching process or while
                // suspending can cause errors that will be automatically resolved
                (0, utils_js_1.logError)(ably, reason.toString());
            });
        }
    }, [shouldAttachToTheChannel, channel]);
    // we expose `connectionState` here for reuse in the usePresence hook, where we need to prevent
    // entering and leaving presence in a similar manner
    return { connectionState };
}
exports.useChannelAttach = useChannelAttach;
//# sourceMappingURL=useChannelAttach.js.map