import * as Ably from 'ably';
export type ChannelNameAndOptions = {
    channelName: string;
    ablyId?: string;
    skip?: boolean;
    onConnectionError?: (error: Ably.ErrorInfo) => unknown;
    onChannelError?: (error: Ably.ErrorInfo) => unknown;
};
export type ChannelNameAndAblyId = Pick<ChannelNameAndOptions, 'channelName' | 'ablyId'>;
export type ChannelParameters = string | ChannelNameAndOptions;
export declare const version = "2.10.0";
/**
 * channel options for react-hooks
 */
export declare function channelOptionsForReactHooks(options?: Ably.ChannelOptions): Ably.ChannelOptions;
